/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.annotation.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.operamasks.faces.annotation.cache.CacheFilter;
import org.operamasks.faces.annotation.cache.ClassMetaInfo;
import org.operamasks.faces.annotation.cache.HashMapClassMetaInfo;
import org.operamasks.faces.annotation.cache.MemberMetaInfo;
import org.operamasks.faces.application.ApplicationAssociate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationCache {
    public static final String KEY = AnnotationCache.class.getName();
    private ConcurrentHashMap<Class<?>, ClassMetaInfo> cache = new ConcurrentHashMap();
    private CacheFilter filter;
    Map<Field, MemberMetaInfo<Field>> fieldMetaPool = new HashMap<Field, MemberMetaInfo<Field>>();
    Map<Method, MemberMetaInfo<Method>> methodMetaPool = new HashMap<Method, MemberMetaInfo<Method>>();

    public static AnnotationCache getInstance() {
        ApplicationAssociate assoc = ApplicationAssociate.getInstance();
        return assoc.getSingleton(KEY, AnnotationCache.class);
    }

    public void add(Class<?> clazz) {
        if (!this.cache.containsKey(clazz)) {
            HashMapClassMetaInfo meta = new HashMapClassMetaInfo(clazz, this.fieldMetaPool, this.methodMetaPool);
            this.cache.put(clazz, meta);
        }
    }

    public ClassMetaInfo get(Class<?> clazz) {
        return this.cache.get(clazz);
    }

    public void setFilter(CacheFilter filter) {
        this.filter = filter;
    }

    public MemberMetaInfo<Method> getMethodMetaInfo(Method method) {
        return this.methodMetaPool.get(method);
    }

    public MemberMetaInfo<Field> getFieldMetaInfo(Field field) {
        return this.fieldMetaPool.get(field);
    }
}

