/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.annotation.cache;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.operamasks.faces.annotation.cache.ClassMetaInfo;
import org.operamasks.faces.annotation.cache.MemberMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapClassMetaInfo
implements ClassMetaInfo {
    private Map<Class<? extends Annotation>, List<MemberMetaInfo<Field>>> fieldMeta = null;
    private Map<Class<? extends Annotation>, List<MemberMetaInfo<Method>>> methodMeta = null;
    private Map<Class<? extends Annotation>, List<MemberMetaInfo<Field>>> fieldMetaInParent = null;
    private Map<Class<? extends Annotation>, List<MemberMetaInfo<Method>>> methodMetaInParent = null;
    private Map<String, Object> attributes;
    private List<Annotation> classMeta = null;
    private List<Annotation> classMetaInParent = null;
    private Map<Field, MemberMetaInfo<Field>> fieldMetaPool = null;
    private Map<Method, MemberMetaInfo<Method>> methodMetaPool = null;
    Class<?> cachedClass;
    private static final List<MemberMetaInfo<Field>> EMPTY_FIELD_LIST = new ArrayList<MemberMetaInfo<Field>>();
    private static final List<MemberMetaInfo<Method>> EMPTY_METHOD_LIST = new ArrayList<MemberMetaInfo<Method>>();
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    public HashMapClassMetaInfo(Class<?> clazz) {
        this(clazz, new HashMap<Field, MemberMetaInfo<Field>>(), new HashMap<Method, MemberMetaInfo<Method>>());
    }

    public HashMapClassMetaInfo(Class<?> clazz, Map<Field, MemberMetaInfo<Field>> fieldMetaPool, Map<Method, MemberMetaInfo<Method>> methodMetaPool) {
        this.fieldMetaPool = fieldMetaPool;
        this.methodMetaPool = methodMetaPool;
        this.buildFieldMetaInfo(clazz);
        this.buildMethodMetaInfo(clazz);
        this.buildClassMetaInfo(clazz);
        this.cachedClass = clazz;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap<String, Object>();
        }
        return this.attributes;
    }

    private void buildClassMetaInfo(Class<?> clazz) {
        this.classMeta = null;
        this.classMetaInParent = null;
        Class<?> parent = clazz;
        while (parent.getSuperclass() != null) {
            Annotation[] annotations = parent.getAnnotations();
            if (annotations.length > 0) {
                if (parent == clazz) {
                    this.classMeta = new ArrayList<Annotation>(Arrays.asList(clazz.getAnnotations()));
                }
                if (this.classMetaInParent == null) {
                    this.classMetaInParent = new ArrayList<Annotation>();
                }
                this.classMetaInParent.addAll(Arrays.asList(annotations));
            }
            parent = parent.getSuperclass();
        }
    }

    private void buildFieldMetaInfo(Class<?> clazz) {
        this.fieldMeta = null;
        this.fieldMetaInParent = null;
        Class<?> parent = clazz;
        while (parent.getSuperclass() != null) {
            for (Field field : parent.getDeclaredFields()) {
                Annotation[] anno = field.getAnnotations();
                if (anno.length == 0) continue;
                MemberMetaInfo<Field> metaInfo = this.fieldMetaPool.get(field);
                if (metaInfo == null) {
                    metaInfo = new MemberMetaInfo<Field>(field);
                    this.fieldMetaPool.put(field, metaInfo);
                }
                for (Annotation meta : anno) {
                    if (clazz == parent) {
                        if (this.fieldMeta == null) {
                            this.fieldMeta = new HashMap<Class<? extends Annotation>, List<MemberMetaInfo<Field>>>();
                        }
                        this.addMetaInfo(this.fieldMeta, meta, metaInfo);
                    }
                    if (this.fieldMetaInParent == null) {
                        this.fieldMetaInParent = new HashMap<Class<? extends Annotation>, List<MemberMetaInfo<Field>>>();
                    }
                    this.addMetaInfo(this.fieldMetaInParent, meta, metaInfo);
                }
            }
            parent = parent.getSuperclass();
        }
    }

    private void buildMethodMetaInfo(Class<?> clazz) {
        this.methodMeta = null;
        this.methodMetaInParent = null;
        Class<?> parent = clazz;
        while (parent.getSuperclass() != null) {
            for (Method method : parent.getDeclaredMethods()) {
                Annotation[] anno = method.getAnnotations();
                if (anno.length == 0) continue;
                MemberMetaInfo<Method> metaInfo = this.methodMetaPool.get(method);
                if (metaInfo == null) {
                    metaInfo = new MemberMetaInfo<Method>(method);
                    this.methodMetaPool.put(method, metaInfo);
                }
                for (Annotation meta : anno) {
                    if (clazz == parent) {
                        if (this.methodMeta == null) {
                            this.methodMeta = new HashMap<Class<? extends Annotation>, List<MemberMetaInfo<Method>>>();
                        }
                        this.addMetaInfo(this.methodMeta, meta, metaInfo);
                    }
                    if (this.methodMetaInParent == null) {
                        this.methodMetaInParent = new HashMap<Class<? extends Annotation>, List<MemberMetaInfo<Method>>>();
                    }
                    this.addMetaInfo(this.methodMetaInParent, meta, metaInfo);
                }
            }
            parent = parent.getSuperclass();
        }
    }

    private <T extends AccessibleObject> void addMetaInfo(Map<Class<? extends Annotation>, List<MemberMetaInfo<T>>> metaMap, Annotation meta, MemberMetaInfo<T> metaInfo) {
        List<MemberMetaInfo<T>> metaInfoList = metaMap.get(meta.annotationType());
        if (metaInfoList == null) {
            metaInfoList = new ArrayList<MemberMetaInfo<T>>();
            metaMap.put(meta.annotationType(), metaInfoList);
        }
        if (!metaInfoList.contains(metaInfo)) {
            metaInfoList.add(metaInfo);
        }
    }

    @Override
    public Class<?> getCachedClass() {
        return this.cachedClass;
    }

    @Override
    public List<MemberMetaInfo<Field>> getFields(Class<? extends Annotation> annotation) {
        if (this.fieldMeta == null || this.fieldMeta.get(annotation) == null) {
            return EMPTY_FIELD_LIST;
        }
        return this.fieldMeta.get(annotation);
    }

    @Override
    public List<MemberMetaInfo<Method>> getMethods(Class<? extends Annotation> annotation) {
        if (this.methodMeta == null || this.methodMeta.get(annotation) == null) {
            return EMPTY_METHOD_LIST;
        }
        return this.methodMeta.get(annotation);
    }

    @Override
    public List<MemberMetaInfo<Field>> getFieldsInParent(Class<? extends Annotation> annotation) {
        if (this.fieldMetaInParent == null || this.fieldMetaInParent.get(annotation) == null) {
            return EMPTY_FIELD_LIST;
        }
        return this.fieldMetaInParent.get(annotation);
    }

    @Override
    public List<MemberMetaInfo<Method>> getMethodsInParent(Class<? extends Annotation> annotation) {
        if (this.methodMetaInParent == null || this.methodMetaInParent.get(annotation) == null) {
            return EMPTY_METHOD_LIST;
        }
        return this.methodMetaInParent.get(annotation);
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.classMeta != null) {
            return this.classMeta.toArray(EMPTY_ANNOTATION_ARRAY);
        }
        return EMPTY_ANNOTATION_ARRAY;
    }

    @Override
    public <T extends Annotation> T[] getAnnotations(Class<T> annotationClass) {
        return this.pickOutAnnotations(this.classMeta, annotationClass);
    }

    @Override
    public Annotation[] getAnnotationsInParent() {
        if (this.classMetaInParent != null) {
            return this.classMetaInParent.toArray(EMPTY_ANNOTATION_ARRAY);
        }
        return EMPTY_ANNOTATION_ARRAY;
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsInParent(Class<T> annotationClass) {
        return this.pickOutAnnotations(this.classMetaInParent, annotationClass);
    }

    private <T extends Annotation> T[] pickOutAnnotations(List<Annotation> list, Class<T> annotationClass) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (list != null) {
            for (Annotation meta : list) {
                if (meta.annotationType() != annotationClass) continue;
                annotations.add(meta);
            }
        }
        Annotation[] a = (Annotation[])Array.newInstance(annotationClass, annotations.size());
        if (annotations.size() > 0) {
            return annotations.toArray(a);
        }
        return a;
    }
}

