/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.beans.IntrospectionException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Parser;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.application.InjectionManager;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.application.ManagedBeanFactory;
import org.operamasks.faces.beans.ObjectFactory;
import org.operamasks.faces.config.ManagedBeanConfig;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.resources.Resources;
import org.operamasks.util.BeanProperty;
import org.operamasks.util.BeanUtils;
import org.operamasks.util.Utils;

public abstract class AbstractManagedBeanFactory
implements ManagedBeanFactory {
    protected ManagedBeanConfig mbean;
    protected InjectionManager injectionManager;
    protected ClassLoader loader;
    private static ThreadLocal<Map<ManagedBeanConfig, Object>> beanRefLocal = new ThreadLocal<Map<ManagedBeanConfig, Object>>(){

        @Override
        protected Map<ManagedBeanConfig, Object> initialValue() {
            return new IdentityHashMap<ManagedBeanConfig, Object>();
        }
    };

    public AbstractManagedBeanFactory(ManagedBeanConfig mbean) {
        this.mbean = mbean;
        ApplicationAssociate assoc = ApplicationAssociate.getInstance();
        this.injectionManager = assoc.getInjectionManager();
        this.loader = assoc.getClassLoader();
    }

    public ManagedBeanConfig getConfig() {
        return this.mbean;
    }

    public String getBeanName() {
        return this.mbean.getManagedBeanName();
    }

    public String getBeanClassName() {
        return this.mbean.getManagedBeanClass();
    }

    public ManagedBeanScope getScope() {
        return this.mbean.getManagedBeanScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createBean(FacesContext context) throws FacesException {
        Object bean;
        String classname = this.mbean.getManagedBeanClass();
        Map<ManagedBeanConfig, Object> beanRefs = beanRefLocal.get();
        if (beanRefs.containsKey(this.mbean)) {
            throw new FacesException(Resources._T("JSF_CYCLIC_MANAGEDBEAN_REFERENCE", classname));
        }
        try {
            bean = this.instantiateBean(context);
        }
        catch (Exception ex) {
            throw new FacesException(Resources._T("JSF_CREATE_MANAGED_BEAN_ERROR", classname), (Throwable)ex);
        }
        try {
            beanRefs.put(this.mbean, bean);
            this.injectBean(bean);
            bean = this.populateBean(bean);
            this.invokePostConstruct(bean);
        }
        finally {
            beanRefs.remove(this.mbean);
        }
        return this.postCreateBean(bean);
    }

    public void destroyBean(Object bean) {
        this.invokePreDestroy(bean);
    }

    public boolean isInstance(Object bean) {
        return this.getBeanClassName().equals(bean.getClass().getName());
    }

    protected abstract Object instantiateBean(FacesContext var1) throws Exception;

    protected void injectBean(Object bean) {
        this.injectionManager.inject(bean);
    }

    protected void invokePostConstruct(Object bean) {
        this.injectionManager.invokePostConstruct(bean);
    }

    protected void invokePreDestroy(Object bean) {
        this.injectionManager.invokePreDestroy(bean);
    }

    protected Object postCreateBean(Object bean) {
        if (bean instanceof ObjectFactory) {
            return ((ObjectFactory)bean).getObject();
        }
        return bean;
    }

    protected Object populateBean(Object bean) {
        try {
            if (this.mbean.getListEntries() != null) {
                this.copyListEntries((List)bean, this.mbean.getListEntries());
            } else if (this.mbean.getMapEntries() != null) {
                this.copyMapEntries((Map)bean, this.mbean.getMapEntries());
            } else {
                this.setBeanProperties(bean);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new FacesException(Resources._T("JSF_CREATE_MANAGED_BEAN_ERROR", this.mbean.getManagedBeanClass()), (Throwable)ex);
        }
        return bean;
    }

    private void copyListEntries(List list, ManagedBeanConfig.ListEntries listEntries) throws ClassNotFoundException {
        Class valueClass = listEntries.getValueClass() != null ? Utils.findClass((String)listEntries.getValueClass(), (ClassLoader)this.loader) : String.class;
        for (String strValue : listEntries.getValues()) {
            Object value = strValue == null ? null : (ValueExpression.class.isAssignableFrom(valueClass) ? FacesUtils.createValueExpression(strValue, Object.class) : (FacesUtils.isValueExpression(strValue) ? this.checkAndEvaluateExpression(strValue, valueClass) : TypeCoercion.coerce((Object)strValue, (Class)valueClass)));
            list.add(value);
        }
    }

    private void copyMapEntries(Map map, ManagedBeanConfig.MapEntries mapEntries) throws ClassNotFoundException {
        Class keyClass = mapEntries.getKeyClass() != null ? Utils.findClass((String)mapEntries.getKeyClass(), (ClassLoader)this.loader) : String.class;
        Class valueClass = mapEntries.getValueClass() != null ? Utils.findClass((String)mapEntries.getValueClass(), (ClassLoader)this.loader) : String.class;
        for (ManagedBeanConfig.MapEntry entry : mapEntries.getMapEntries()) {
            String strKey = entry.getKey();
            String strValue = entry.getValue();
            Object key = strKey == null ? null : (FacesUtils.isValueExpression(strKey) ? this.checkAndEvaluateExpression(strKey, keyClass) : TypeCoercion.coerce((Object)strKey, (Class)keyClass));
            Object value = strValue == null ? null : (ValueExpression.class.isAssignableFrom(valueClass) ? FacesUtils.createValueExpression(strValue, Object.class) : (FacesUtils.isValueExpression(strValue) ? this.checkAndEvaluateExpression(strValue, valueClass) : TypeCoercion.coerce((Object)strValue, (Class)valueClass)));
            map.put(key, value);
        }
    }

    private void setBeanProperties(Object bean) throws ClassNotFoundException {
        for (ManagedBeanConfig.Property property : this.mbean.getManagedProperties()) {
            BeanProperty bp;
            String name = property.getPropertyName();
            if (name == null || name.length() == 0) continue;
            try {
                bp = BeanUtils.getProperty(bean.getClass(), (String)name);
            }
            catch (IntrospectionException ex) {
                throw new FacesException((Throwable)ex);
            }
            Object value = property.getListEntries() != null ? this.getArrayOrListValue(bean, property, bp) : (property.getMapEntries() != null ? this.getMapValue(bean, property, bp) : this.getSimpleValue(bean, property, bp));
            if (bp != null && bp.getWriteMethod() != null) {
                try {
                    bp.getWriteMethod().invoke(bean, value);
                    continue;
                }
                catch (InvocationTargetException ex) {
                    throw new FacesException(ex.getTargetException());
                }
                catch (Exception ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
            if (property.checkAndGetField(bean.getClass()) != null) {
                try {
                    property.getField().set(bean, value);
                    continue;
                }
                catch (Exception ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
            if (bean instanceof UIComponent) {
                ((UIComponent)bean).getAttributes().put(name, value);
                continue;
            }
            throw new FacesException(Resources._T("JSF_BEAN_PROPERTY_NOT_WRITEABLE", bean.getClass().getName(), name));
        }
    }

    private Object getArrayOrListValue(Object bean, ManagedBeanConfig.Property property, BeanProperty bp) throws ClassNotFoundException {
        Object values;
        int i;
        Class propertyClass = null;
        boolean isArray = false;
        Object oldValues = null;
        if (property.checkAndGetField(bean.getClass()) != null) {
            propertyClass = property.getField().getType();
            isArray = propertyClass.isArray();
            if (!isArray && propertyClass != List.class) {
                throw new FacesException(Resources._T("JSF_BEAN_PROPERTY_NOT_ARRAY_OR_LIST", bean.getClass().getName(), property.getPropertyName()));
            }
            try {
                oldValues = property.getField().get(bean);
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
        if (bp != null) {
            propertyClass = bp.getType();
            isArray = propertyClass.isArray();
            if (!isArray && propertyClass != List.class) {
                throw new FacesException(Resources._T("JSF_BEAN_PROPERTY_NOT_ARRAY_OR_LIST", bean.getClass().getName(), property.getPropertyName()));
            }
            Method readMethod = bp.getReadMethod();
            if (readMethod != null) {
                try {
                    oldValues = readMethod.invoke(bean, new Object[0]);
                }
                catch (InvocationTargetException ex) {
                    throw new FacesException(ex.getTargetException());
                }
                catch (Exception ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
        }
        ArrayList<Object> newValues = new ArrayList<Object>();
        if (oldValues != null) {
            if (isArray) {
                int len = Array.getLength(oldValues);
                for (i = 0; i < len; ++i) {
                    newValues.add(Array.get(oldValues, i));
                }
            } else {
                newValues.addAll((List)oldValues);
            }
        }
        this.copyListEntries(newValues, property.getListEntries());
        if (isArray) {
            values = Array.newInstance(propertyClass.getComponentType(), newValues.size());
            for (i = 0; i < newValues.size(); ++i) {
                Array.set(values, i, newValues.get(i));
            }
        } else {
            values = newValues;
        }
        return values;
    }

    private Object getMapValue(Object bean, ManagedBeanConfig.Property property, BeanProperty bp) throws ClassNotFoundException {
        Map result = null;
        if (property.checkAndGetField(bean.getClass()) != null) {
            if (property.getField().getType() != Map.class) {
                throw new FacesException(Resources._T("JSF_BEAN_PROPERTY_NOT_MAP", bean.getClass().getName(), property.getPropertyName()));
            }
            try {
                result = (Map)property.getField().get(bean);
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
        if (bp != null) {
            if (bp.getType() != Map.class) {
                throw new FacesException(Resources._T("JSF_BEAN_PROPERTY_NOT_MAP", bean.getClass().getName(), property.getPropertyName()));
            }
            Method readMethod = bp.getReadMethod();
            if (readMethod != null) {
                try {
                    result = (Map)readMethod.invoke(bean, new Object[0]);
                }
                catch (InvocationTargetException ex) {
                    throw new FacesException(ex.getTargetException());
                }
                catch (Exception ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
        }
        if (result == null) {
            result = new HashMap();
        }
        this.copyMapEntries(result, property.getMapEntries());
        return result;
    }

    private Object getSimpleValue(Object bean, ManagedBeanConfig.Property property, BeanProperty bp) throws ClassNotFoundException {
        Class valueClass = property.checkAndGetField(bean.getClass()) != null ? property.getField().getType() : (bp != null ? bp.getType() : (property.getPropertyClass() != null ? Utils.findClass((String)property.getPropertyClass(), (ClassLoader)this.loader) : String.class));
        String strValue = property.getValue();
        Object result = strValue == null ? null : (ValueExpression.class.isAssignableFrom(valueClass) ? FacesUtils.createValueExpression(strValue, Object.class) : (FacesUtils.isValueExpression(strValue) ? this.checkAndEvaluateExpression(strValue, valueClass) : TypeCoercion.coerce((Object)strValue, (Class)valueClass)));
        return result;
    }

    private Object checkAndEvaluateExpression(String expression, Class expectedType) throws FacesException {
        if (!this.isValidLifespan(expression)) {
            throw new FacesException("Cannot inject a managed bean into larger scope.");
        }
        return FacesUtils.evaluateExpressionGet(expression, expectedType);
    }

    private boolean isValidLifespan(String expression) {
        ManagedBeanScope scope = this.mbean.getManagedBeanScope();
        ManagedBeanScope refscope = this.getExpressionScope(expression);
        if (refscope == null) {
            return true;
        }
        if (scope == ManagedBeanScope.NONE) {
            return refscope == ManagedBeanScope.NONE;
        }
        if (scope == ManagedBeanScope.REQUEST) {
            return true;
        }
        if (scope == ManagedBeanScope.SESSION) {
            return refscope == ManagedBeanScope.SESSION || refscope == ManagedBeanScope.APPLICATION || refscope == ManagedBeanScope.NONE;
        }
        if (scope == ManagedBeanScope.APPLICATION) {
            return refscope == ManagedBeanScope.APPLICATION || refscope == ManagedBeanScope.NONE;
        }
        if (scope == ManagedBeanScope.CONVERSATION) {
            return refscope != ManagedBeanScope.REQUEST;
        }
        return false;
    }

    private ManagedBeanScope getExpressionScope(String expression) {
        ELNode node = Parser.parse((String)expression);
        String identifier = null;
        if (node instanceof ELNode.IDENT) {
            identifier = ((ELNode.IDENT)node).id;
        } else if (node instanceof ELNode.ACCESS) {
            ELNode leftmost = node;
            while ((leftmost = ((ELNode.ACCESS)leftmost).right) instanceof ELNode.ACCESS) {
            }
            if (leftmost instanceof ELNode.IDENT) {
                identifier = ((ELNode.IDENT)leftmost).id;
            }
        }
        if (identifier == null) {
            return null;
        }
        ManagedBeanFactory refBean = ManagedBeanContainer.getInstance().getBeanFactory(identifier);
        if (refBean != null) {
            return refBean.getScope();
        }
        if (identifier.equalsIgnoreCase("requestScope")) {
            return ManagedBeanScope.REQUEST;
        }
        if (identifier.equalsIgnoreCase("sessionScope")) {
            return ManagedBeanScope.SESSION;
        }
        if (identifier.equalsIgnoreCase("applicationScope")) {
            return ManagedBeanScope.APPLICATION;
        }
        if (identifier.equalsIgnoreCase("conversation")) {
            return ManagedBeanScope.CONVERSATION;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext ec = context.getExternalContext();
        if (ec.getRequestMap().get(identifier) != null) {
            return ManagedBeanScope.REQUEST;
        }
        if (ec.getSessionMap().get(identifier) != null) {
            return ManagedBeanScope.SESSION;
        }
        if (ec.getApplicationMap().get(identifier) != null) {
            return ManagedBeanScope.APPLICATION;
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

