/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELContextListener;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ConverterRegistry;
import org.operamasks.faces.application.ELResolverRegistry;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.application.ValidatorRegistry;
import org.operamasks.faces.application.impl.DefaultConverterRegistry;
import org.operamasks.faces.application.impl.DefaultValidatorRegistry;
import org.operamasks.faces.application.impl.ResourceBundleWrapper;
import org.operamasks.faces.component.ComponentConfig;
import org.operamasks.faces.component.ComponentContainer;
import org.operamasks.faces.component.ComponentFactory;
import org.operamasks.faces.component.NormalComponentFactory;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.el.MethodBindingMethodExpressionAdapter;
import org.operamasks.faces.el.ValueBindingValueExpressionAdapter;
import org.operamasks.resources.Resources;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationImpl
extends Application {
    private ApplicationAssociate associate;
    private Logger logger = Logger.getLogger("org.operamasks.faces.application");
    private Locale defaultLocale;
    private Collection<Locale> supportedLocales;
    private String defaultRenderKitId;
    private String messageBundle;
    private ActionListener actionListener;
    private NavigationHandler navigationHandler;
    private ViewHandler viewHandler;
    private StateManager stateManager;
    private ConverterRegistry converterRegistry;
    private ValidatorRegistry validatorRegistry;
    private ELResolverRegistry elResolverRegistry;
    private List<ELContextListener> elContextListeners = new CopyOnWriteArrayList<ELContextListener>();
    private static final ELContextListener[] EMPTY_EL_CONTEXT_LISTENER_ARRAY = new ELContextListener[0];

    protected ApplicationImpl(ApplicationAssociate associate) {
        this.associate = associate;
        this.converterRegistry = DefaultConverterRegistry.getInstance();
        this.validatorRegistry = DefaultValidatorRegistry.getInstance();
        this.elResolverRegistry = ELResolverRegistry.getInstance();
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener listener) {
        this.assertNotNull(listener);
        this.actionListener = listener;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) {
        this.assertNotNull(locale);
        this.defaultLocale = locale;
    }

    public Iterator<Locale> getSupportedLocales() {
        Collection<Locale> locales = this.supportedLocales;
        if (locales == null) {
            locales = Collections.emptyList();
        }
        return locales.iterator();
    }

    public void setSupportedLocales(Collection<Locale> locales) {
        this.assertNotNull(locales);
        this.supportedLocales = new ArrayList<Locale>(locales);
    }

    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }

    public void setDefaultRenderKitId(String renderKitId) {
        this.assertNotNull(renderKitId);
        this.defaultRenderKitId = renderKitId;
    }

    public String getMessageBundle() {
        return this.messageBundle;
    }

    public void setMessageBundle(String bundle) {
        this.assertNotNull(bundle);
        this.messageBundle = bundle;
    }

    public NavigationHandler getNavigationHandler() {
        return this.navigationHandler;
    }

    public void setNavigationHandler(NavigationHandler handler) {
        this.assertNotNull(handler);
        this.navigationHandler = handler;
    }

    public PropertyResolver getPropertyResolver() {
        return this.elResolverRegistry.getPropertyResolverAdapter();
    }

    public void setPropertyResolver(PropertyResolver resolver) {
        this.assertNotNull(resolver);
        this.assertNotRequestMade();
        this.elResolverRegistry.setPropertyResolverFromApp(resolver);
    }

    public VariableResolver getVariableResolver() {
        return this.elResolverRegistry.getVariableResolverAdapter();
    }

    public void setVariableResolver(VariableResolver resolver) {
        this.assertNotNull(resolver);
        this.assertNotRequestMade();
        this.elResolverRegistry.setVariableResolverFromApp(resolver);
    }

    public ResourceBundle getResourceBundle(FacesContext context, String var) {
        this.assertNotNull(context);
        this.assertNotNull(var);
        Locale locale = FacesUtils.getCurrentLocale();
        ClassLoader loader = this.associate.getClassLoader();
        String basename = this.associate.getResourceBundleBaseName(var);
        ResourceBundle bundle = null;
        if (basename != null) {
            try {
                bundle = ResourceBundle.getBundle(basename, locale, loader);
            }
            catch (MissingResourceException ex) {
                bundle = ResourceBundle.getBundle(basename, Locale.ENGLISH, loader);
            }
        }
        if (bundle == null) {
            return null;
        }
        return new ResourceBundleWrapper(bundle);
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public void setViewHandler(ViewHandler handler) {
        this.assertNotNull(handler);
        this.assertNotResponseRendered();
        this.viewHandler = handler;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public void setStateManager(StateManager manager) {
        this.assertNotNull(manager);
        this.assertNotRequestMade();
        this.stateManager = manager;
    }

    public void addComponent(String componentType, String componentClass) {
        this.assertNotNull(componentType);
        this.assertNotNull(componentClass);
        ComponentContainer container = ComponentContainer.getInstance();
        if (!container.containsComponentFactory(componentType)) {
            container.addComponentFactory(new NormalComponentFactory(new ComponentConfig(componentType, componentClass)));
        }
    }

    public UIComponent createComponent(String componentType) throws FacesException {
        this.assertNotNull(componentType);
        ComponentContainer container = ComponentContainer.getInstance();
        ComponentFactory fac = container.getComponentFactory(componentType);
        if (fac == null) {
            throw new FacesException(Resources._T("JSF_NO_SUCH_COMPONENT_TYPE", componentType));
        }
        return fac.createComponent();
    }

    public UIComponent createComponent(ValueBinding binding, FacesContext context, String componentType) throws FacesException {
        this.assertNotNull(binding);
        this.assertNotNull(context);
        this.assertNotNull(componentType);
        try {
            Object component = binding.getValue(context);
            if (!(component instanceof UIComponent)) {
                component = this.createComponent(componentType);
                binding.setValue(context, component);
            } else if (component != null) {
                String id = ((UIComponent)component).getId();
                if (id != null && id.startsWith("j_id")) {
                    ((UIComponent)component).setId(context.getViewRoot().createUniqueId());
                }
                this.processChildrenComponentId(context, (UIComponent)component);
            }
            return (UIComponent)component;
        }
        catch (FacesException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new FacesException(Resources._T("JSF_CREATE_COMPONENT_ERROR", componentType), (Throwable)ex);
        }
    }

    private void processChildrenComponentId(FacesContext context, UIComponent component) {
        Iterator children;
        if (component != null && (children = component.getFacetsAndChildren()) != null) {
            while (children.hasNext()) {
                UIComponent kid = (UIComponent)children.next();
                if (kid == null) {
                    this.logger.warning("May be due to thread synchronization problems caused kid is null, skip here");
                    continue;
                }
                String id = kid.getId();
                if (id != null && id.startsWith("j_id")) {
                    UIViewRoot viewRoot = context.getViewRoot();
                    kid.setId(viewRoot.createUniqueId());
                }
                this.processChildrenComponentId(context, kid);
            }
        }
    }

    public UIComponent createComponent(ValueExpression binding, FacesContext context, String componentType) throws FacesException {
        this.assertNotNull(binding);
        this.assertNotNull(context);
        this.assertNotNull(componentType);
        try {
            Object component = binding.getValue(context.getELContext());
            if (!(component instanceof UIComponent)) {
                component = this.createComponent(componentType);
                binding.setValue(context.getELContext(), component);
            } else if (component != null) {
                String id = ((UIComponent)component).getId();
                if (id != null && id.startsWith("j_id")) {
                    ((UIComponent)component).setId(context.getViewRoot().createUniqueId());
                }
                this.processChildrenComponentId(context, (UIComponent)component);
            }
            return (UIComponent)component;
        }
        catch (FacesException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new FacesException(Resources._T("JSF_CREATE_COMPONENT_ERROR", componentType), (Throwable)ex);
        }
    }

    public Iterator<String> getComponentTypes() {
        ComponentContainer container = ComponentContainer.getInstance();
        return container.getComponentTypes().iterator();
    }

    public void addConverter(String converterId, String converterClassName) {
        try {
            Class converterClass = Utils.findClass((String)converterClassName, (ClassLoader)this.associate.getClassLoader());
            ConverterFactory factory = this.converterRegistry.createConverterFactory(converterClass);
            this.converterRegistry.addConverterFactory(converterId, factory);
        }
        catch (ClassNotFoundException ex) {
            throw new FacesException(Resources._T("JSF_CLASS_NOT_FOUND", converterClassName), (Throwable)ex);
        }
    }

    public void addConverter(Class targetClass, String converterClassName) {
        try {
            Class converterClass = Utils.findClass((String)converterClassName, (ClassLoader)this.associate.getClassLoader());
            ConverterFactory factory = this.converterRegistry.createConverterFactory(converterClass);
            this.converterRegistry.addConverterFactory(targetClass, factory);
        }
        catch (ClassNotFoundException ex) {
            throw new FacesException(Resources._T("JSF_CLASS_NOT_FOUND", converterClassName), (Throwable)ex);
        }
    }

    public Converter createConverter(String converterId) {
        return this.converterRegistry.createConverter(converterId);
    }

    public Converter createConverter(Class targetClass) {
        return this.converterRegistry.createConverter(targetClass);
    }

    public Iterator<String> getConverterIds() {
        return this.converterRegistry.getConverterIds();
    }

    public Iterator<Class> getConverterTypes() {
        return this.converterRegistry.getConverterTypes();
    }

    public void addValidator(String validatorId, String validatorClassName) {
        try {
            Class validatorClass = Utils.findClass((String)validatorClassName, (ClassLoader)this.associate.getClassLoader());
            ValidatorFactory factory = this.validatorRegistry.createValidatorFactory(validatorClass);
            this.validatorRegistry.addValidatorFactory(validatorId, factory);
        }
        catch (ClassNotFoundException ex) {
            throw new FacesException(Resources._T("JSF_CLASS_NOT_FOUND", validatorClassName), (Throwable)ex);
        }
    }

    public Validator createValidator(String validatorId) {
        return this.validatorRegistry.createValidator(validatorId);
    }

    public Iterator<String> getValidatorIds() {
        return this.validatorRegistry.getValidatorIds();
    }

    public MethodBinding createMethodBinding(String ref, Class[] params) throws ReferenceSyntaxException {
        if (ref == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            params = new Class[]{};
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            MethodExpression expr = this.getExpressionFactory().createMethodExpression(context.getELContext(), ref, null, params);
            return new MethodBindingMethodExpressionAdapter(expr);
        }
        catch (ELException ex) {
            throw new ReferenceSyntaxException((Throwable)ex);
        }
    }

    public ValueBinding createValueBinding(String ref) throws ReferenceSyntaxException {
        this.assertNotNull(ref);
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ValueExpression expr = this.getExpressionFactory().createValueExpression(context.getELContext(), ref, Object.class);
            return new ValueBindingValueExpressionAdapter(expr);
        }
        catch (ELException ex) {
            throw new ReferenceSyntaxException((Throwable)ex);
        }
    }

    public void addELContextListener(ELContextListener listener) {
        this.assertNotNull(listener);
        this.elContextListeners.add(listener);
    }

    public void removeELContextListener(ELContextListener listener) {
        if (listener != null && this.elContextListeners != null) {
            this.elContextListeners.remove(listener);
        }
    }

    public ELContextListener[] getELContextListeners() {
        if (this.elContextListeners == null) {
            return EMPTY_EL_CONTEXT_LISTENER_ARRAY;
        }
        return this.elContextListeners.toArray(EMPTY_EL_CONTEXT_LISTENER_ARRAY);
    }

    public ExpressionFactory getExpressionFactory() {
        return ELEngine.getExpressionFactory();
    }

    public Object evaluateExpressionGet(FacesContext context, String expression, Class expectedType) {
        return ELEngine.evaluateExpression((ELContext)context.getELContext(), (String)expression, (Class)expectedType);
    }

    public void addELResolver(ELResolver resolver) {
        this.assertNotNull(resolver);
        this.assertNotRequestMade();
        this.elResolverRegistry.addELResolverFromApp(resolver);
    }

    public ELResolver getELResolver() {
        return this.elResolverRegistry.getELResolverForFaces();
    }

    private void assertNotNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    private void assertNotRequestMade() {
        if (this.associate.isRequestMade()) {
            throw new IllegalStateException(Resources._T("JSF_ILLEGAL_ADD_ELRESOLVER"));
        }
    }

    private void assertNotResponseRendered() {
        if (this.associate.isResponseRendered()) {
            throw new IllegalStateException(Resources._T("JSF_ILLEGAL_SETTING_VIEWHANDLER"));
        }
    }
}

