/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.application.impl.DynamicFacesConfig;
import org.operamasks.faces.application.impl.DynamicViewMapper;
import org.operamasks.faces.internal.util.DynamicFacesStrategy;

public class DefaultDynamicViewMapper
implements DynamicViewMapper {
    private ViewMapping viewMapping = new ViewMapping();
    private SimpleCache<String, DynamicFacesConfig> cache = SimpleCache.make(20);
    private static final String FULL_VIEW_ID = "#{~view}";
    private static final String FULL_VIEW_ID_CAPITALIZE = "#{~View}";
    private static final String WILDCARD_VIEW_ID = "#{@view}";
    private static final String WILDCARD_VIEW_ID_CAPITALIZE = "#{@View}";
    private static final String VIEW_NAME_ONLY = "#{view}";
    private static final String VIEW_NAME_ONLY_CAPITALIZE = "#{View}";

    public static DefaultDynamicViewMapper getInstance() {
        return ApplicationAssociate.getInstance().getSingleton(DefaultDynamicViewMapper.class);
    }

    public void addViewMapping(String viewId, String templateContextHandlerName, String strategy, String keepGenerated) {
        this.viewMapping.addMapping(viewId, templateContextHandlerName, strategy, keepGenerated);
    }

    public DynamicFacesConfig mapViewId(String viewId) {
        DynamicFacesConfig templateHandlerConfig = this.cache.get(viewId);
        if (templateHandlerConfig != null) {
            return templateHandlerConfig;
        }
        templateHandlerConfig = this.viewMapping.findMapping(viewId);
        if (templateHandlerConfig != null) {
            String templateContextHandlerName = templateHandlerConfig.getTemplateContextHandlerName();
            if (templateContextHandlerName.indexOf("#{") != -1) {
                templateContextHandlerName = this.mapViewId(templateContextHandlerName, viewId);
                templateHandlerConfig.setTemplateContextHandlerName(templateContextHandlerName);
            }
            this.cache.put(viewId, templateHandlerConfig);
        }
        return templateHandlerConfig;
    }

    private String mapViewId(String pattern, String viewId) {
        int dash;
        int dot = viewId.lastIndexOf(46);
        if (dot > viewId.lastIndexOf(47)) {
            viewId = viewId.substring(0, dot);
        }
        if ((viewId = viewId.replace('/', '.')).startsWith(".")) {
            viewId = viewId.substring(1);
        }
        while ((dash = viewId.indexOf(45)) != -1) {
            viewId = viewId.substring(0, dash) + DefaultDynamicViewMapper.capitalize(viewId.substring(dash + 1));
        }
        int lastDot = viewId.lastIndexOf(46);
        if (pattern.indexOf(FULL_VIEW_ID) != -1) {
            return pattern.replace(FULL_VIEW_ID, viewId);
        }
        if (pattern.indexOf(FULL_VIEW_ID_CAPITALIZE) != -1) {
            viewId = DefaultDynamicViewMapper.capitalize(viewId, lastDot + 1);
            return pattern.replace(FULL_VIEW_ID_CAPITALIZE, viewId);
        }
        if (pattern.indexOf(WILDCARD_VIEW_ID) != -1) {
            viewId = this.getWildcardViewId(viewId);
            return pattern.replace(WILDCARD_VIEW_ID, viewId);
        }
        if (pattern.indexOf(WILDCARD_VIEW_ID_CAPITALIZE) != -1) {
            viewId = this.getWildcardViewId(viewId);
            lastDot = viewId.lastIndexOf(46);
            viewId = DefaultDynamicViewMapper.capitalize(viewId, lastDot + 1);
            return pattern.replace(WILDCARD_VIEW_ID_CAPITALIZE, viewId);
        }
        if (pattern.indexOf(VIEW_NAME_ONLY) != -1) {
            viewId = viewId.substring(lastDot + 1);
            return pattern.replace(VIEW_NAME_ONLY, viewId);
        }
        if (pattern.indexOf(VIEW_NAME_ONLY_CAPITALIZE) != -1) {
            viewId = DefaultDynamicViewMapper.capitalize(viewId.substring(lastDot + 1));
            return pattern.replace(VIEW_NAME_ONLY_CAPITALIZE, viewId);
        }
        return pattern;
    }

    private String getWildcardViewId(String viewId) {
        String mostExactWildcard = null;
        for (String wildward : this.viewMapping.wildcards) {
            if ((wildward = wildward.replace('/', '.')).startsWith(".")) {
                wildward = wildward.substring(1, wildward.length());
            }
            if (!viewId.startsWith(wildward) || mostExactWildcard != null && wildward.length() <= mostExactWildcard.length()) continue;
            mostExactWildcard = wildward;
        }
        if (mostExactWildcard != null) {
            viewId = viewId.substring(mostExactWildcard.length());
        }
        return viewId;
    }

    private static final String capitalize(String s) {
        if (s.length() > 0) {
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return s;
    }

    private static final String capitalize(String s, int i) {
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        if (i < s.length() - 1) {
            s = s.substring(0, i) + Character.toUpperCase(s.charAt(i)) + s.substring(i + 1);
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleCache<K, V> {
        private int capacity;
        private Map<Object, V> cache;
        private Map<Object, V> cache2;
        private static Object NULL_KEY = new Object();

        public static <K, V> SimpleCache<K, V> make(int capacity) {
            return new SimpleCache<K, V>(capacity);
        }

        public SimpleCache(int capacity) {
            this.capacity = capacity;
            this.cache = new ConcurrentHashMap<Object, V>(capacity);
            this.cache2 = new ConcurrentHashMap<Object, V>(capacity);
        }

        public V get(Object key) {
            V result;
            if (key == null) {
                key = NULL_KEY;
            }
            if ((result = this.cache.get(key)) == null) {
                result = this.cache2.get(key);
            }
            return result;
        }

        public void put(K key, V value) {
            assert (value != null);
            if (this.cache.size() > this.capacity) {
                this.cache2.clear();
                this.cache2.putAll(this.cache);
                this.cache.clear();
            }
            if (key == null) {
                this.cache.put(NULL_KEY, value);
            } else {
                this.cache.put(key, value);
            }
        }
    }

    private static final class ViewMapping {
        private static Map<String, DynamicFacesStrategy> DFACES_STRATEGIES = new HashMap<String, DynamicFacesStrategy>();
        private Map<String, DynamicFacesConfig> viewMap = new HashMap<String, DynamicFacesConfig>();
        private TreeSet<String> wildcards = new TreeSet<String>(new DescOrder());

        private ViewMapping() {
        }

        public void addMapping(String viewId, String templateContextHandlerName, String strategy, String keepGenerated) {
            DynamicFacesConfig templateHandlerConfig = this.viewMap.get(viewId);
            if (templateHandlerConfig == null) {
                DynamicFacesStrategy dynamicFacesStrategy;
                boolean dynamicFacesKeepGenerated = false;
                if ("true".equals(keepGenerated)) {
                    dynamicFacesKeepGenerated = true;
                }
                if ((dynamicFacesStrategy = DFACES_STRATEGIES.get(strategy)) == null) {
                    dynamicFacesStrategy = DynamicFacesStrategy.REQUEST;
                }
                templateHandlerConfig = new DynamicFacesConfig(templateContextHandlerName, dynamicFacesStrategy, dynamicFacesKeepGenerated);
                this.viewMap.put(viewId, templateHandlerConfig);
            }
            if (viewId.endsWith("*") && !viewId.equals("*")) {
                viewId = viewId.substring(0, viewId.length() - 1);
                this.wildcards.add(viewId);
            }
        }

        public DynamicFacesConfig findMapping(String viewId) {
            DynamicFacesConfig resultConfig = null;
            resultConfig = this.viewMap.get(viewId);
            if (resultConfig == null) {
                for (String wildcard : this.wildcards) {
                    if (!viewId.startsWith(wildcard)) continue;
                    resultConfig = this.viewMap.get(wildcard.concat("*"));
                }
            }
            if (resultConfig == null) {
                resultConfig = this.viewMap.get("*");
            }
            return resultConfig;
        }

        static {
            DFACES_STRATEGIES.put("request", DynamicFacesStrategy.REQUEST);
            DFACES_STRATEGIES.put("conversation", DynamicFacesStrategy.CONVERSATION);
            DFACES_STRATEGIES.put("session", DynamicFacesStrategy.SESSION);
            DFACES_STRATEGIES.put("application", DynamicFacesStrategy.APPLICATION);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DescOrder
    implements Comparator<String> {
        private DescOrder() {
        }

        @Override
        public int compare(String a, String b) {
            return b.compareTo(a);
        }
    }
}

