/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.ServletResponse;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.config.NavigationCase;
import org.operamasks.faces.internal.stub.component.UpdaterStub;
import org.operamasks.faces.internal.util.OMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNavigationHandler
extends NavigationHandler {
    private static final String KEY = DefaultNavigationHandler.class.getName();
    private Map<String, List<NavigationCase>> navigationMap = new HashMap<String, List<NavigationCase>>();
    private TreeSet<String> wildcards = new TreeSet<String>(new DescOrder());
    public static final String VIEW_SCHEME = "view:";
    public static final String REDIRECT_SCHEME = "redirect:";
    private boolean implicitNavigation;
    private boolean implicitNavigationSet;
    private static final String IMPLICIT_NAVIGATION_PARAM = "org.operamasks.faces.IMPLICIT_NAVIGATION";
    private String defaultSuffix;

    public DefaultNavigationHandler() {
        ApplicationAssociate.getInstance().setAttribute(KEY, (Object)this);
    }

    public static DefaultNavigationHandler getInstance() {
        return (DefaultNavigationHandler)((Object)ApplicationAssociate.getInstance().getAttribute(KEY));
    }

    public void addNavigationCase(NavigationCase navcase) {
        String fromViewId = navcase.getFromViewId();
        List<NavigationCase> navList = this.navigationMap.get(fromViewId);
        if (navList == null) {
            navList = new ArrayList<NavigationCase>();
            navList.add(navcase);
            this.navigationMap.put(fromViewId, navList);
        } else {
            boolean found = false;
            for (NavigationCase oldcase : navList) {
                if (!DefaultNavigationHandler.eq(navcase.getFromAction(), oldcase.getFromAction()) || !DefaultNavigationHandler.eq(navcase.getFromOutcome(), oldcase.getFromOutcome())) continue;
                oldcase.setToViewId(navcase.getToViewId());
                oldcase.setRedirect(navcase.isRedirect());
                found = true;
                break;
            }
            if (!found) {
                navList.add(navcase);
            }
        }
        if (fromViewId.endsWith("*") && !fromViewId.equals("*")) {
            fromViewId = fromViewId.substring(0, fromViewId.length() - 1);
            this.wildcards.add(fromViewId);
        }
    }

    public NavigationCase findNavigationCase(String viewId, String action, String outcome) {
        NavigationCase result = this.findExactMatch(viewId, action, outcome);
        if (result == null && (result = this.findWildcardMatch(viewId, action, outcome)) == null) {
            result = this.findDefaultMatch(action, outcome);
        }
        return result;
    }

    private NavigationCase findExactMatch(String viewId, String action, String outcome) {
        List<NavigationCase> navList = this.navigationMap.get(viewId);
        if (navList != null) {
            return this.getViewFromActionOutcome(navList, action, outcome);
        }
        return null;
    }

    private NavigationCase findWildcardMatch(String viewId, String action, String outcome) {
        for (String fromViewId : this.wildcards) {
            NavigationCase navcase;
            List<NavigationCase> navList;
            if (!viewId.startsWith(fromViewId) || (navList = this.navigationMap.get(fromViewId.concat("*"))) == null || (navcase = this.getViewFromActionOutcome(navList, action, outcome)) == null) continue;
            return navcase;
        }
        return null;
    }

    private NavigationCase findDefaultMatch(String action, String outcome) {
        List<NavigationCase> defaultNavList = this.navigationMap.get("*");
        if (defaultNavList != null) {
            return this.getViewFromActionOutcome(defaultNavList, action, outcome);
        }
        return null;
    }

    private NavigationCase getViewFromActionOutcome(List<NavigationCase> navList, String action, String outcome) {
        for (NavigationCase navcase : navList) {
            String fromAction = navcase.getFromAction();
            String fromOutcome = navcase.getFromOutcome();
            if (fromAction != null && !fromAction.equals(action) || fromOutcome != null && !fromOutcome.equals(outcome)) continue;
            return navcase;
        }
        return null;
    }

    private static final boolean eq(Object x, Object y) {
        if (x == null) {
            return y == null;
        }
        if (y == null) {
            return false;
        }
        return x.equals(y);
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (outcome == null) {
            return;
        }
        String renderId = OMUtils.getRequestRenderId(context);
        boolean handled = false;
        if (renderId != null) {
            handled = this.handlePartialNavigation(context, renderId, fromAction, outcome, (UIComponent)context.getViewRoot());
        }
        if (!handled) {
            this.handleStandardNavigation(context, fromAction, outcome);
        }
    }

    private void handleStandardNavigation(FacesContext context, String fromAction, String outcome) {
        String viewId = context.getViewRoot().getViewId();
        String toViewId = this.getToViewId(context, viewId, fromAction, outcome, true);
        if (toViewId != null) {
            ViewHandler vh = context.getApplication().getViewHandler();
            UIViewRoot newRoot = vh.createView(context, toViewId);
            context.setViewRoot(newRoot);
        }
    }

    private boolean handlePartialNavigation(FacesContext context, String renderId, String fromAction, String outcome, UIComponent component) {
        boolean handled = false;
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UpdaterStub) {
                String toViewId;
                UpdaterStub updater = (UpdaterStub)child;
                String id = updater.getRenderId();
                if (id == null || !id.equals(renderId)) continue;
                String viewId = updater.getSubviewId();
                String contextPath = updater.getContext();
                if (viewId == null) continue;
                if (contextPath != null) {
                    toViewId = this.getToViewId(context, contextPath + viewId, fromAction, outcome, false);
                    if (toViewId != null) {
                        if (toViewId.startsWith(contextPath)) {
                            toViewId = toViewId.substring(contextPath.length());
                        }
                    } else {
                        toViewId = this.getToViewId(context, viewId, fromAction, outcome, false);
                    }
                } else {
                    toViewId = this.getToViewId(context, viewId, fromAction, outcome, false);
                }
                if (toViewId == null) continue;
                updater.setSubviewId(toViewId);
                updater.setNewView(true);
                handled = true;
                continue;
            }
            handled |= this.handlePartialNavigation(context, renderId, fromAction, outcome, child);
        }
        return handled;
    }

    private String getToViewId(FacesContext context, String fromViewId, String fromAction, String outcome, boolean handleRedirect) {
        String query;
        int q;
        String uri;
        String suffix = this.getDefaultSuffix(context);
        boolean redirect = false;
        if (outcome.startsWith(VIEW_SCHEME)) {
            uri = outcome.substring(VIEW_SCHEME.length());
            if (uri.startsWith(REDIRECT_SCHEME)) {
                uri = uri.substring(REDIRECT_SCHEME.length());
                redirect = true;
            }
        } else {
            uri = outcome;
        }
        if ((q = uri.indexOf(63)) != -1) {
            query = uri.substring(q);
            uri = uri.substring(0, q);
        } else {
            query = null;
        }
        NavigationCase navcase = this.findNavigationCase(fromViewId, fromAction, uri);
        if (navcase != null) {
            if (handleRedirect && (redirect || navcase.isRedirect())) {
                this.redirect(context, navcase.getToViewId(), query);
                return null;
            }
            return navcase.getToViewId();
        }
        if (outcome.startsWith(VIEW_SCHEME)) {
            if (!uri.endsWith(suffix)) {
                uri = uri.concat(suffix);
            }
        } else if (!this.isImplicitNavigation(context) || !uri.endsWith(suffix)) {
            return null;
        }
        if (!uri.startsWith("/")) {
            uri = fromViewId.substring(0, fromViewId.lastIndexOf(47) + 1) + uri;
        }
        if (handleRedirect && redirect) {
            this.redirect(context, uri, query);
            return null;
        }
        return uri;
    }

    private void redirect(FacesContext context, String viewId, String query) {
        try {
            ViewHandler vh = context.getApplication().getViewHandler();
            String url = vh.getActionURL(context, viewId);
            if (query != null) {
                url = url.indexOf("?") < 0 ? url.concat(query) : url.concat("&").concat(query.substring(1));
            }
            context.responseComplete();
            boolean isAjaxResponse = OMUtils.isAjaxResponse(context);
            if (isAjaxResponse) {
                ServletResponse response = (ServletResponse)context.getExternalContext().getResponse();
                response.setContentType("text/javascript");
                response.getWriter().write("window.location='" + url + "';");
                response.getWriter().close();
            } else {
                context.getExternalContext().redirect(url);
            }
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private boolean isImplicitNavigation(FacesContext context) {
        if (this.implicitNavigationSet) {
            return this.implicitNavigation;
        }
        String paramValue = context.getExternalContext().getInitParameter(IMPLICIT_NAVIGATION_PARAM);
        this.implicitNavigation = paramValue == null || paramValue != null && paramValue.equalsIgnoreCase("true");
        this.implicitNavigationSet = true;
        return this.implicitNavigation;
    }

    private String getDefaultSuffix(FacesContext context) {
        if (this.defaultSuffix == null) {
            this.defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
            if (this.defaultSuffix == null) {
                this.defaultSuffix = ".jsp";
            }
        }
        return this.defaultSuffix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescOrder
    implements Comparator<String>,
    Serializable {
        private DescOrder() {
        }

        @Override
        public int compare(String a, String b) {
            return b.compareTo(a);
        }
    }
}

