/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.validator.Validator;
import org.operamasks.faces.application.TargetCreator;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.application.ValidatorRegistry;
import org.operamasks.faces.binding.factories.AdaptingValidatorFactory;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidatorRegistry
extends ValidatorRegistry {
    private Map<String, ValidatorFactory> registry = new ConcurrentHashMap<String, ValidatorFactory>();

    protected DefaultValidatorRegistry() {
    }

    @Override
    public ValidatorFactory createValidatorFactory(TargetCreator creator) {
        return new AdaptingValidatorFactory(creator);
    }

    @Override
    public ValidatorFactory createValidatorFactory(Class<?> validatorClass) {
        return new AdaptingValidatorFactory(validatorClass);
    }

    @Override
    public void addValidatorFactory(String validatorId, ValidatorFactory validatorFactory) {
        this.registry.put(validatorId, validatorFactory);
    }

    @Override
    public ValidatorFactory getValidatorFactory(String validatorId) {
        return this.registry.get(validatorId);
    }

    @Override
    public Validator createValidator(String validatorId) {
        ValidatorFactory validatorFactory = this.registry.get(validatorId);
        if (validatorFactory == null) {
            throw new FacesException(Resources._T("JSF_NO_SUCH_VALIDATOR_ID", validatorId));
        }
        return validatorFactory.createValidator();
    }

    @Override
    public Iterator<String> getValidatorIds() {
        return this.registry.keySet().iterator();
    }
}

