/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.operamasks.faces.component.ComponentContainer;
import org.operamasks.faces.component.ComponentFactory;
import org.operamasks.resources.Resources;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeStructure
implements Serializable {
    private String id;
    private String className;
    private ArrayList<TreeStructure> children;
    private HashMap<String, TreeStructure> facets;
    private static final long serialVersionUID = -8679279788535268484L;

    public TreeStructure() {
    }

    public TreeStructure(UIComponent component) {
        this.id = component.getId();
        this.className = component.getClass().getName();
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public Collection<TreeStructure> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public Map<String, TreeStructure> getFacets() {
        if (this.facets == null) {
            return Collections.emptyMap();
        }
        return this.facets;
    }

    public void addChild(TreeStructure treeStruct) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(treeStruct);
    }

    public void addFacet(String facetName, TreeStructure treeStruct) {
        if (this.facets == null) {
            this.facets = new HashMap();
        }
        this.facets.put(facetName, treeStruct);
    }

    public UIComponent createComponent() {
        try {
            Class c = Utils.findClass((String)this.className);
            ComponentContainer container = ComponentContainer.getInstance();
            ComponentFactory fac = container.getComponentFactoryByName(c.getName());
            if (fac == null) {
                throw new FacesException(Resources._T("JSF_CREATE_COMPONENT_ERROR", c.getName()));
            }
            UIComponent newComponent = fac.createComponent();
            if (this.id != null) {
                newComponent.setId(this.id);
            }
            return newComponent;
        }
        catch (Throwable ex) {
            throw new FacesException(ex);
        }
    }
}

