/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.vendor.tomcat;

import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.faces.FacesException;
import org.apache.AnnotationProcessor;
import org.operamasks.faces.application.InjectionManager;

public class TomcatInjectionManager
implements InjectionManager {
    private AnnotationProcessor processor;

    public TomcatInjectionManager(Object processor) {
        this.processor = (AnnotationProcessor)processor;
    }

    public void inject(Object bean) {
        try {
            this.processor.processAnnotations(bean);
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    public void invokePostConstruct(Object bean) {
        try {
            Method m = this.findAnnotationMethod(bean.getClass(), PostConstruct.class);
            if (m != null) {
                m.invoke(bean, new Object[0]);
            }
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    public void invokePreDestroy(Object bean) {
        try {
            Method m = this.findAnnotationMethod(bean.getClass(), PreDestroy.class);
            if (m != null) {
                m.invoke(bean, new Object[0]);
            }
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private Method findAnnotationMethod(Class c, Class annotation) {
        while (c != null) {
            for (Method m : c.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(annotation)) continue;
                return m;
            }
            c = c.getSuperclass();
        }
        return null;
    }
}

