/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.factories;

import java.lang.reflect.Method;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import org.operamasks.faces.annotation.Validate;
import org.operamasks.faces.application.TargetCreator;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.application.impl.DefaultTargetCreator;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.impl.EmptyValueValidatorAdapter;
import org.operamasks.faces.binding.impl.ValidatorAdapter;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptingValidatorFactory
implements ValidatorFactory {
    private TargetCreator creator;
    private Method validateMethod;

    public AdaptingValidatorFactory(TargetCreator creator) {
        this.creator = creator;
    }

    public AdaptingValidatorFactory(Class<?> validatorClass) {
        this.creator = new DefaultTargetCreator(validatorClass);
    }

    @Override
    public Validator createValidator() {
        Object target = this.creator.createTarget(null);
        if (target instanceof Validator) {
            return (Validator)target;
        }
        return this.createValidatorAdapter(target);
    }

    private Validator createValidatorAdapter(Object target) {
        if (this.validateMethod == null) {
            this.validateMethod = this.getValidateMethod(this.creator.getTargetClass());
        }
        ModelBean bean = ModelBean.wrap(target);
        Method method = this.validateMethod;
        Validate meta = method.getAnnotation(Validate.class);
        if (meta.ignoreEmpty()) {
            return new ValidatorAdapter(bean, method, meta.script(), meta.message());
        }
        return new EmptyValueValidatorAdapter(bean, method, meta.script(), meta.message());
    }

    private Method getValidateMethod(Class<?> targetClass) {
        for (Method method : targetClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Validate.class)) continue;
            if (!this.checkValidateMethod(method)) {
                throw new FacesException(Resources._T("MVB_INVALID_VALIDATE_METHOD", method.getName()));
            }
            return method;
        }
        throw new FacesException(Resources._T("MVB_VALIDATE_METHOD_NOT_FOUND", targetClass.getName()));
    }

    private boolean checkValidateMethod(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 1) {
            return true;
        }
        if (params.length == 3) {
            return params[0] == FacesContext.class && params[1] == UIComponent.class;
        }
        return false;
    }
}

