/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.persistence.EntityManager;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.impl.DependencyBinder;
import org.operamasks.faces.binding.impl.EntityManagerWrapper;
import org.operamasks.faces.binding.impl.LoggerWrapper;
import org.operamasks.faces.binding.impl.PropertyBinding;
import org.operamasks.faces.event.EventBroadcaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Binders {
    private Map<Class, DependencyBinder> binders = new HashMap<Class, DependencyBinder>();
    private static final String CONFIG_FILE = "/org/operamasks/faces/binding/impl/binders.properties";

    public static DependencyBinder getDependencyBinder(Class<?> type) {
        Binders binders = ApplicationAssociate.getInstance().getSingleton(Binders.class);
        return binders.getBinder(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Binders() throws IOException {
        InputStream configStream = null;
        try {
            Properties config = new Properties();
            configStream = this.getClass().getResourceAsStream(CONFIG_FILE);
            config.load(configStream);
            ClassLoader loader = ApplicationAssociate.getInstance().getClassLoader();
            for (Object key : config.keySet()) {
                try {
                    String binderClassName = config.getProperty((String)key);
                    if (binderClassName.indexOf(46) == -1) {
                        binderClassName = Binders.class.getName() + "$" + binderClassName;
                    }
                    Class<?> targetClass = loader.loadClass((String)key);
                    Class<?> binderClass = loader.loadClass(binderClassName);
                    DependencyBinder binder = (DependencyBinder)binderClass.newInstance();
                    this.binders.put(targetClass, binder);
                }
                catch (Throwable ex) {}
            }
        }
        finally {
            if (configStream != null) {
                configStream.close();
            }
        }
    }

    DependencyBinder getBinder(Class<?> type) {
        return this.binders.get(type);
    }

    static final class EntityManagerBinder
    extends DependencyBinder {
        EntityManagerBinder() {
        }

        public void inject(FacesContext ctx, PropertyBinding binding, ModelBean bean) {
            EntityManager value;
            if (binding.isReadable() && binding.isWriteable() && (value = (EntityManager)binding.getModelValue(bean)) != null && !(value instanceof EntityManagerWrapper)) {
                value = new EntityManagerWrapper(bean, value);
                binding.setModelValue(bean, value);
            }
        }
    }

    static final class EventBroadcasterBinder
    extends DependencyBinder {
        EventBroadcasterBinder() {
        }

        public void inject(FacesContext ctx, PropertyBinding binding, ModelBean bean) {
            if (binding.getModelValue(bean) == null) {
                binding.setModelValue(bean, EventBroadcaster.getInstance());
            }
        }
    }

    static final class NavigationHandlerBinder
    extends DependencyBinder {
        NavigationHandlerBinder() {
        }

        public void inject(FacesContext ctx, PropertyBinding binding, ModelBean bean) {
            if (binding.getModelValue(bean) == null) {
                binding.setModelValue(bean, ctx.getApplication().getNavigationHandler());
            }
        }
    }

    static final class ExpressionFactoryBinder
    extends DependencyBinder {
        ExpressionFactoryBinder() {
        }

        public void inject(FacesContext ctx, PropertyBinding binding, ModelBean bean) {
            if (binding.getModelValue(bean) == null) {
                binding.setModelValue(bean, ctx.getApplication().getExpressionFactory());
            }
        }
    }

    static final class ApplicationBinder
    extends DependencyBinder {
        ApplicationBinder() {
        }

        public void inject(FacesContext ctx, PropertyBinding binding, ModelBean bean) {
            if (binding.getModelValue(bean) == null) {
                binding.setModelValue(bean, ctx.getApplication());
            }
        }
    }

    static final class ExternalContextBinder
    extends DependencyBinder {
        ExternalContextBinder() {
        }

        public void inject(FacesContext ctx, PropertyBinding binding, ModelBean bean) {
            binding.setModelValue(bean, ctx.getExternalContext());
        }
    }

    static final class FacesContextBinder
    extends DependencyBinder {
        FacesContextBinder() {
        }

        public void inject(FacesContext ctx, PropertyBinding binding, ModelBean bean) {
            binding.setModelValue(bean, ctx);
        }
    }

    static final class LoggerBinder
    extends DependencyBinder {
        LoggerBinder() {
        }

        public void inject(FacesContext ctx, PropertyBinding binding, ModelBean bean) {
            Logger logger = (Logger)binding.getModelValue(bean);
            if (logger == null) {
                String name = binding.getDeclaringClass().getName();
                logger = new LoggerWrapper(bean, Logger.getLogger(name), name);
                binding.setModelValue(bean, logger);
            } else if (!(logger instanceof LoggerWrapper)) {
                logger = new LoggerWrapper(bean, logger, logger.getName());
                binding.setModelValue(bean, logger);
            }
        }
    }
}

