/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.binding.impl.ValueWrapper;
import org.operamasks.faces.developer.util.FacesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BindingUtils {
    public static final String LABEL_FOR_CACHE_KEY = "BindingUtils.labelFor.key";

    public static final Method getInterfaceMethod(Method method) {
        Class<?> declClass = method.getDeclaringClass();
        if (declClass.isInterface()) {
            return method;
        }
        for (Class<?> c : declClass.getInterfaces()) {
            try {
                return c.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException ex) {
            }
        }
        return method;
    }

    public static final Method getReadMethod(Class targetClass, String name, Class type) {
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        if (type == Boolean.TYPE) {
            try {
                return targetClass.getMethod("is" + name, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        try {
            return targetClass.getMethod("get" + name, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static final Method getWriteMethod(Class targetClass, String name, Class type) {
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            return targetClass.getMethod("set" + name, type);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static boolean isBindingPresent(Class targetClass, Method method, Class<? extends Annotation> at) {
        if (method.isAnnotationPresent(at)) {
            return true;
        }
        for (Class c = targetClass.getSuperclass(); c != null; c = c.getSuperclass()) {
            try {
                Method m = c.getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (!m.isAnnotationPresent(at)) continue;
                return true;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    public static Set<UIComponent> findLabelComponent(FacesContext ctx, UIComponent from) {
        UIComponent parent;
        String key;
        Set<UIComponent> labels;
        FacesContext context = FacesContext.getCurrentInstance();
        Map reqMap = context.getExternalContext().getRequestMap();
        Map<String, Set<UIComponent>> forMap = (Map<String, Set<UIComponent>>)reqMap.get(LABEL_FOR_CACHE_KEY);
        if (forMap == null) {
            forMap = BindingUtils.buildForLabelMap(ctx);
            reqMap.put(LABEL_FOR_CACHE_KEY, forMap);
        }
        if ((labels = forMap.get(key = (parent = BindingUtils.getNamingContainer(ctx, from)).getId() + from.getId())) == null) {
            key = parent.getId() + from.getClientId(ctx);
            labels = forMap.get(key);
        }
        return labels;
    }

    public static void clearCache(FacesContext context) {
        context.getExternalContext().getRequestMap().remove(LABEL_FOR_CACHE_KEY);
    }

    private static UIComponent getNamingContainer(FacesContext ctx, UIComponent from) {
        UIComponent parent;
        for (parent = from; parent != null && !(parent instanceof NamingContainer); parent = parent.getParent()) {
        }
        if (parent == null) {
            parent = ctx.getViewRoot();
        }
        return parent;
    }

    private static Map<String, Set<UIComponent>> buildForLabelMap(FacesContext ctx) {
        HashMap<String, Set<UIComponent>> forMap = new HashMap<String, Set<UIComponent>>();
        Iterator<UIComponent> kids = FacesUtils.createChildrenIterator((UIComponent)ctx.getViewRoot(), false);
        while (kids.hasNext()) {
            String forId;
            UIComponent kid = kids.next();
            if (!"javax.faces.Output".equals(kid.getFamily()) || (forId = (String)kid.getAttributes().get("for")) == null) continue;
            UIComponent parent = BindingUtils.getNamingContainer(ctx, kid);
            String key = parent.getId() + forId;
            Set labels = FacesUtils.createIfAbsent(forMap, key, HashSet.class);
            labels.add(kid);
        }
        return forMap;
    }

    public static UIComponent findLabelFacet(FacesContext ctx, UIComponent from, boolean create) {
        UIComponent parent;
        for (parent = from; parent != null && !(parent instanceof UIColumn); parent = parent.getParent()) {
        }
        if (parent == null) {
            return null;
        }
        if (parent.getFacetCount() > 0) {
            for (UIComponent facet : parent.getFacets().values()) {
                if (BindingUtils.isLabelFor(ctx, facet, from)) {
                    return facet;
                }
                if (facet.getChildCount() <= 0) continue;
                Iterator<UIComponent> kids = FacesUtils.createChildrenIterator(facet, false);
                while (kids.hasNext()) {
                    UIComponent kid = kids.next();
                    if (!BindingUtils.isLabelFor(ctx, kid, from)) continue;
                    return kid;
                }
            }
        }
        if (create && parent.getFacets().get("header") == null) {
            UIComponent header = ctx.getApplication().createComponent("javax.faces.HtmlOutputText");
            header.setTransient(true);
            parent.getFacets().put("header", header);
            return header;
        }
        return null;
    }

    private static boolean isLabelFor(FacesContext ctx, UIComponent label, UIComponent comp) {
        String forId;
        return "javax.faces.Output".equals(label.getFamily()) && (forId = (String)label.getAttributes().get("for")) != null && (forId.equals(comp.getId()) || forId.equals(comp.getClientId(ctx)));
    }

    public static ValueExpression createValueWrapper(Object scope, String expression, Class<?> expectedType) {
        Object value = FacesUtils.isValueExpression(expression) ? FacesUtils.createValueExpression(scope, expression, expectedType) : (expectedType == String.class || expectedType == Object.class ? expression : TypeCoercion.coerce((Object)expression, expectedType));
        return new ValueWrapper(value, expectedType);
    }

    private BindingUtils() {
    }
}

