/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import elite.lang.Closure;
import javax.el.ELContext;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class ClosureValidatorAdapter
implements Validator,
StateHolder {
    private Closure closure;

    public ClosureValidatorAdapter(Closure closure) {
        this.closure = closure;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value != null) {
            Object result;
            ELContext elctx = context.getELContext();
            try {
                switch (this.closure.arity(elctx)) {
                    case 1: {
                        result = this.closure.call(elctx, new Object[]{value});
                        break;
                    }
                    case 2: {
                        result = this.closure.call(elctx, new Object[]{component, value});
                        break;
                    }
                    case 3: {
                        result = this.closure.call(elctx, new Object[]{context, component, value});
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (ValidatorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String errInfo = ex.getMessage();
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, errInfo, errInfo);
                throw new ValidatorException(message, ex.getCause());
            }
            if (result != null) {
                if (result instanceof String) {
                    String errInfo = (String)result;
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, errInfo, errInfo);
                    throw new ValidatorException(message);
                }
                if (Boolean.FALSE.equals(result)) {
                    String errInfo = (String)component.getAttributes().get("validatorMessage");
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, errInfo, errInfo);
                    throw new ValidatorException(message);
                }
            }
        }
    }

    public Object saveState(FacesContext context) {
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
    }

    public boolean isTransient() {
        return true;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

