/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.faces.FacesException;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import org.operamasks.faces.annotation.Transactional;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.binding.ModelBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelBean
extends ModelBean {
    private final Object target;

    public DefaultModelBean(Object target) {
        assert (target != null);
        this.target = target;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.target.getClass();
    }

    @Override
    public Object preInvoke(Method method) {
        return this.target;
    }

    @Override
    public Throwable postInvoke(Object target, Throwable exception) {
        return exception;
    }

    @Override
    public boolean preInvokeTx(Method method) throws Exception {
        UserTransaction tx = null;
        if (method.isAnnotationPresent(Transactional.class)) {
            tx = ApplicationAssociate.getInstance().getUserTransaction();
        }
        if (tx != null && tx.getStatus() == 6) {
            tx.begin();
            return true;
        }
        return false;
    }

    @Override
    public Throwable postInvokeTx(boolean transacted, Throwable exception) {
        if (transacted) {
            UserTransaction tx = ApplicationAssociate.getInstance().getUserTransaction();
            assert (tx != null);
            if (exception != null) {
                try {
                    tx.rollback();
                }
                catch (Exception ex) {}
            } else {
                try {
                    tx.commit();
                }
                catch (RollbackException ex) {
                }
                catch (Throwable ex) {
                    exception = ex;
                }
            }
        }
        return exception;
    }

    @Override
    public Object getField(Field field) {
        try {
            return field.get(this.target);
        }
        catch (IllegalAccessException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    @Override
    public void setField(Field field, Object value) {
        try {
            field.set(this.target, value);
        }
        catch (IllegalAccessException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    @Override
    public Object getValue(ELContext context, Object property) {
        return context.getELResolver().getValue(context, this.target, property);
    }

    @Override
    public Class<?> getType(ELContext context, Object property) {
        return context.getELResolver().getType(context, this.target, property);
    }

    @Override
    public void setValue(ELContext context, Object property, Object value) {
        context.getELResolver().setValue(context, this.target, property, value);
    }

    @Override
    public boolean isReadOnly(ELContext context, Object property) {
        return context.getELResolver().isReadOnly(context, this.target, property);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DefaultModelBean) {
            DefaultModelBean other = (DefaultModelBean)obj;
            return this.target == other.target;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.target.hashCode();
    }
}

