/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import elite.lang.Closure;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.faces.context.FacesContext;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.MethodResolvable;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.application.impl.ResourceBundleWrapper;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Injector;
import org.operamasks.faces.binding.impl.PropertyBinding;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalStringBinding
extends PropertyBinding
implements Injector {
    private String basename;
    private String key;
    private Map<Locale, Object> cache = new ConcurrentHashMap<Locale, Object>();

    public LocalStringBinding(String viewId) {
        super(viewId);
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        this.inject(ctx, mbc.getModelBean());
    }

    @Override
    public void outject(FacesContext ctx, ModelBean bean) {
    }

    @Override
    public void inject(FacesContext ctx, ModelBean bean) {
        Object value = this.getValue(bean);
        if (value != null) {
            this.setModelValue(bean, value);
        }
    }

    public Object getValue(ModelBean bean) {
        Locale locale = FacesUtils.getCurrentLocale();
        Object value = this.cache.get(locale);
        if (value != null) {
            return value;
        }
        if (this.type.isArray()) {
            return this.loadArray(bean, locale);
        }
        if (this.type == List.class) {
            return this.loadList(bean, locale);
        }
        if (this.type == Map.class) {
            return this.loadMap(bean, locale);
        }
        if (this.type == ResourceBundle.class) {
            return this.loadResourceBundle(locale);
        }
        return this.loadSingle(bean, locale);
    }

    private String getString(String key, Locale locale) {
        return OMUtils.getLocalString(this.getDeclaringClass(), this.basename, key, locale);
    }

    private Object loadSingle(ModelBean bean, Locale locale) {
        String text = this.getString(this.key, locale);
        if (text == null) {
            return null;
        }
        if (FacesUtils.isValueExpression(text)) {
            return bean.evaluateExpression(text, this.type);
        }
        Object value = TypeCoercion.coerce((Object)text, (Class)this.type);
        this.cache.put(locale, value);
        return value;
    }

    private Object loadArray(ModelBean bean, Locale locale) {
        String text;
        Class<?> elemType = this.type.getComponentType();
        ArrayList<Object> list = new ArrayList<Object>();
        boolean cacheable = true;
        int i = 0;
        while ((text = this.getString(this.key + "[" + i + "]", locale)) != null) {
            if (FacesUtils.isValueExpression(text)) {
                cacheable = false;
                list.add(bean.evaluateExpression(text, elemType));
            } else {
                list.add(TypeCoercion.coerce((Object)text, elemType));
            }
            ++i;
        }
        Object[] result = (Object[])Array.newInstance(elemType, list.size());
        list.toArray(result);
        if (cacheable) {
            this.cache.put(locale, result);
        }
        return result;
    }

    private Object loadList(ModelBean bean, Locale locale) {
        String text;
        Class<?> elemType = this.getActualTypeArgument(0);
        ArrayList<Object> list = new ArrayList<Object>();
        boolean cacheable = true;
        int i = 0;
        while ((text = this.getString(this.key + "[" + i + "]", locale)) != null) {
            if (FacesUtils.isValueExpression(text)) {
                cacheable = false;
                list.add(bean.evaluateExpression(text, elemType));
            } else {
                list.add(TypeCoercion.coerce((Object)text, elemType));
            }
            ++i;
        }
        if (cacheable) {
            this.cache.put(locale, list);
        }
        return list;
    }

    private Class<?> getActualTypeArgument(int ordinal) {
        Type[] args;
        Type type = null;
        Field field = this.getField();
        if (field != null) {
            type = field.getGenericType();
        } else {
            Method method = this.getWriteMethod();
            if (method != null) {
                type = method.getGenericReturnType();
            }
        }
        if (type != null && type instanceof ParameterizedType && (args = ((ParameterizedType)type).getActualTypeArguments()).length > ordinal && args[ordinal] instanceof Class) {
            return (Class)args[ordinal];
        }
        return Object.class;
    }

    private Object loadMap(ModelBean bean, Locale locale) {
        return new LocalStringMap(bean, this.getDeclaringClass(), this.basename, locale);
    }

    private Object loadResourceBundle(Locale locale) {
        ResourceBundle bundle = OMUtils.getLocalStringBundle(this.getDeclaringClass(), this.basename, locale);
        if (bundle != null) {
            bundle = new ResourceBundleWrapper(bundle);
        }
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalStringMap
    extends AbstractMap<String, String>
    implements MethodResolvable,
    Serializable {
        private static final long serialVersionUID = -1L;
        private final transient ModelBean bean;
        private final Class<?> declaringClass;
        private final String basename;
        private final Locale locale;
        private Map<String, String> stringMap = null;

        LocalStringMap(ModelBean bean, Class<?> declaringClass, String basename, Locale locale) {
            this.bean = bean;
            this.declaringClass = declaringClass;
            this.basename = basename;
            this.locale = locale;
        }

        private String getString(String key) {
            return OMUtils.getLocalString(this.declaringClass, this.basename, key, this.locale);
        }

        @Override
        public boolean containsKey(Object key) {
            return key != null && this.getString(key.toString()) != null;
        }

        @Override
        public String get(Object key) {
            String msgtext = this.getString(key.toString());
            if (msgtext != null) {
                msgtext = this.bean.evaluateExpression(msgtext, String.class);
            }
            return msgtext;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.stringMap().entrySet();
        }

        @Override
        public Set<String> keySet() {
            return this.stringMap().keySet();
        }

        @Override
        public Collection<String> values() {
            return this.stringMap().values();
        }

        private Map<String, String> stringMap() {
            if (this.stringMap != null) {
                return this.stringMap;
            }
            ResourceBundle bundle = OMUtils.getLocalStringBundle(this.declaringClass, this.basename, this.locale);
            if (bundle == null) {
                this.stringMap = Collections.emptyMap();
                return this.stringMap;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                map.put(key, bundle.getString(key));
            }
            this.stringMap = map;
            return this.stringMap;
        }

        public String format(String key, Object ... params) {
            String msgtext = this.getString(key);
            if (msgtext == null || params == null || params.length == 0) {
                return msgtext;
            }
            return MessageFormat.format(msgtext, params);
        }

        public MethodInfo getMethodInfo(ELContext ctx, String name) throws MethodNotFoundException {
            if (this.getString(name) == null) {
                throw new MethodNotFoundException(Resources._T("MVB_LOCAL_STRING_KEY_NOT_FOUND", name));
            }
            return new MethodInfo(name, String.class, new Class[0]);
        }

        public Object invoke(ELContext ctx, String name, Closure[] args) throws MethodNotFoundException {
            String msgtext = this.getString(name);
            if (msgtext == null) {
                throw new MethodNotFoundException(Resources._T("MVB_LOCAL_STRING_KEY_NOT_FOUND", name));
            }
            if (args.length != 0) {
                msgtext = MessageFormat.format(msgtext, ELEngine.getArgValues((ELContext)ctx, (Closure[])args));
            }
            return msgtext;
        }

        private Object writeReplace() {
            return null;
        }
    }
}

