/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.Iterator;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.operamasks.faces.binding.ComponentBinder;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBeanFilter;
import org.operamasks.faces.binding.ModelBinder;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.ModelBindingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModelBindingContextImpl
implements ModelBindingContext {
    private PhaseId phaseId;
    private String viewId;
    private ModelBean[] modelBeans;
    private ModelBeanFilter modelBeanFilter;
    private ModelBean currentModelBean;
    private UIComponent currentComponent;

    public ModelBindingContextImpl(PhaseId phaseId, String viewId, ModelBean[] modelBeans) {
        this.phaseId = phaseId;
        this.viewId = viewId;
        this.modelBeans = modelBeans;
    }

    @Override
    public void setModelBeanFilter(ModelBeanFilter filter) {
        this.modelBeanFilter = filter;
    }

    @Override
    public ModelBeanFilter getModelBeanFilter() {
        return this.modelBeanFilter;
    }

    @Override
    public PhaseId getPhaseId() {
        return this.phaseId;
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public ModelBean getModelBean() {
        return this.currentModelBean;
    }

    @Override
    public UIComponent getComponent() {
        return this.currentComponent;
    }

    @Override
    public UIComponent getComponent(String id) {
        String prefix;
        int i;
        char c;
        String compId;
        FacesContext ctx = FacesContext.getCurrentInstance();
        UIComponent comp = this.currentComponent;
        if (id.equals(comp.getId()) || id.equals(comp.getClientId(ctx))) {
            return comp;
        }
        if (this.currentModelBean != null && (compId = comp.getId()) != null && compId.endsWith(id) && ((c = compId.charAt(i = compId.length() - id.length() - 1)) == '_' || c == '-') && this.currentModelBean.isMatchingPrefix(prefix = compId.substring(0, i))) {
            return comp;
        }
        return null;
    }

    @Override
    public void applyGlobal(FacesContext context) {
        for (ModelBean bean : this.modelBeans) {
            ModelBinder binder = bean.getModelBinder();
            if (binder == null) continue;
            this.currentModelBean = bean;
            binder.applyGlobal(context, this);
        }
    }

    @Override
    public void applyModel(FacesContext context, UIComponent component) {
        this.currentComponent = component;
        String id = component.getId();
        if (id != null && !id.startsWith("j_id")) {
            for (ModelBean bean : this.modelBeans) {
                ModelBinder binder;
                if (this.modelBeanFilter != null && !this.modelBeanFilter.accept(bean) || (binder = bean.getModelBinder()) == null) continue;
                this.currentModelBean = bean;
                binder.applyModel(context, this);
            }
        }
        if (component instanceof ComponentBinder) {
            ((ComponentBinder)component).applyModel(context, this);
        } else if (component instanceof UIData) {
            for (UIComponent facet : component.getFacets().values()) {
                this.applyModel(context, facet);
            }
        } else {
            Iterator kids = component.getFacetsAndChildren();
            while (kids.hasNext()) {
                this.applyModel(context, (UIComponent)kids.next());
            }
        }
    }

    @Override
    public void applyInnerModel(FacesContext context, String uri, UIComponent component) {
        if (uri != null && uri.length() != 0) {
            ModelBean[] beans = ModelBindingFactory.instance().getModelBeans(uri, component);
            ModelBindingContextImpl inner = new ModelBindingContextImpl(this.phaseId, uri, beans);
            inner.setModelBeanFilter(this.modelBeanFilter);
            inner.applyGlobal(context);
            for (UIComponent kid : component.getChildren()) {
                inner.applyModel(context, kid);
            }
        } else {
            Iterator kids = component.getFacetsAndChildren();
            while (kids.hasNext()) {
                this.applyModel(context, (UIComponent)kids.next());
            }
        }
    }

    @Override
    public void applyDataModel(FacesContext ctx, UIData data, final Class<?> itemType) {
        ModelBinder binder = ModelBindingFactory.instance().createBinder(itemType);
        ModelBindingContextImpl inner = new ModelBindingContextImpl(this.phaseId, this.viewId, this.modelBeans);
        inner.setModelBeanFilter(new ModelBeanFilter(){

            public boolean accept(ModelBean bean) {
                Class<?> targetClass = bean.getTargetClass();
                return targetClass != null && !itemType.isAssignableFrom(targetClass);
            }
        });
        for (UIComponent kid : data.getChildren()) {
            if (kid instanceof UIColumn) {
                inner.applyDataItemModel(ctx, binder, data, kid);
                inner.applyModel(ctx, kid);
                continue;
            }
            inner.applyModel(ctx, kid);
        }
    }

    private void applyDataItemModel(FacesContext ctx, ModelBinder binder, UIData data, UIComponent comp) {
        String id = comp.getId();
        if (id != null && !id.startsWith("j_id")) {
            this.currentModelBean = null;
            this.currentComponent = comp;
            binder.applyDataModel(ctx, this, data);
        }
        if (comp.getFacetCount() > 0) {
            if (comp instanceof UIColumn) {
                for (UIComponent facet : comp.getFacets().values()) {
                    this.applyModel(ctx, facet);
                }
            } else {
                for (UIComponent facet : comp.getFacets().values()) {
                    this.applyDataItemModel(ctx, binder, data, facet);
                }
            }
        }
        if (comp.getChildCount() > 0) {
            for (UIComponent kid : comp.getChildren()) {
                this.applyDataItemModel(ctx, binder, data, kid);
            }
        }
    }

    @Override
    public void inject(FacesContext ctx) {
        for (ModelBean bean : this.modelBeans) {
            ModelBinder binder;
            if (this.modelBeanFilter != null && !this.modelBeanFilter.accept(bean) || (binder = bean.getModelBinder()) == null) continue;
            binder.inject(ctx, bean);
        }
    }

    @Override
    public void outject(FacesContext ctx) {
        for (ModelBean bean : this.modelBeans) {
            ModelBinder binder;
            if (this.modelBeanFilter != null && !this.modelBeanFilter.accept(bean) || (binder = bean.getModelBinder()) == null) continue;
            binder.outject(ctx, bean);
        }
    }
}

