/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.AnnotatedElement;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

class ModelSecurity {
    private boolean denyAll;
    private boolean permitAll;
    private String[] roles;
    private static Class<DenyAll> denyAllClass;
    private static Class<PermitAll> permitAllClass;
    private static Class<RolesAllowed> rolesAllowedClass;

    private ModelSecurity(boolean denyAll, boolean permitAll, String[] roles) {
        this.denyAll = denyAll;
        this.permitAll = permitAll;
        this.roles = roles;
    }

    public boolean isUserInRole(FacesContext context) {
        if (this.denyAll) {
            return false;
        }
        if (this.permitAll) {
            return true;
        }
        if (this.roles != null) {
            ExternalContext ext = context.getExternalContext();
            for (String role : this.roles) {
                if (!ext.isUserInRole(role)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static ModelSecurity scan(AnnotatedElement elem) {
        if (denyAllClass == null || permitAllClass == null || rolesAllowedClass == null) {
            return null;
        }
        boolean denyAll = elem.isAnnotationPresent(denyAllClass);
        boolean permitAll = elem.isAnnotationPresent(permitAllClass);
        RolesAllowed rolesAllowed = elem.getAnnotation(rolesAllowedClass);
        if (denyAll || permitAll || rolesAllowed != null) {
            String[] roles = rolesAllowed != null ? rolesAllowed.value() : null;
            return new ModelSecurity(denyAll, permitAll, roles);
        }
        return null;
    }

    static {
        try {
            denyAllClass = Class.forName("javax.annotation.security.DenyAll");
            permitAllClass = Class.forName("javax.annotation.security.PermitAll");
            rolesAllowedClass = Class.forName("javax.annotation.security.RolesAllowed");
        }
        catch (Throwable ex) {
            denyAllClass = null;
            permitAllClass = null;
            rolesAllowedClass = null;
        }
    }
}

