/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.PhaseId;
import javax.faces.validator.Validator;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.factories.CustomizingConverterFactory;
import org.operamasks.faces.binding.factories.CustomizingValidatorFactory;
import org.operamasks.faces.binding.impl.BindingUtils;
import org.operamasks.faces.binding.impl.CompositeDataItemAdapter;
import org.operamasks.faces.binding.impl.CompositeValidator;
import org.operamasks.faces.binding.impl.CompositeValueAdapter;
import org.operamasks.faces.binding.impl.ConverterAdapter;
import org.operamasks.faces.binding.impl.LocalStringBinding;
import org.operamasks.faces.binding.impl.ModelSecurity;
import org.operamasks.faces.binding.impl.PropertyBinding;
import org.operamasks.faces.binding.impl.PropertyDataItem;
import org.operamasks.faces.binding.impl.PropertyValueAdapter;
import org.operamasks.faces.binding.impl.RequestParamBinding;
import org.operamasks.faces.binding.impl.RowDataValueAdapter;
import org.operamasks.faces.binding.impl.SelectItemsBinding;
import org.operamasks.faces.binding.impl.ValueWrapper;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.ColumnStub;
import org.operamasks.faces.internal.util.OMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueBinding
extends PropertyBinding {
    private String id;
    private String attribute;
    private String expr;
    private String label;
    private String description;
    private ConverterFactory converterFactory;
    private String converterMessage;
    private List<ValidatorFactory> validators;
    private boolean required;
    private String requiredMessage;
    private LocalStringBinding localString;
    private SelectItemsBinding selectItems;
    private RequestParamBinding requestParam;
    private ModelSecurity security;

    public ValueBinding(String viewId) {
        super(viewId);
    }

    @Override
    public void init(Class<? extends Annotation> metaType, Class<?> targetClass, AnnotatedElement elem) {
        super.init(metaType, targetClass, elem);
        this.security = ModelSecurity.scan(elem);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getExpression() {
        return this.expr;
    }

    public void setExpression(String expr) {
        this.expr = expr;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    public void setConverterFactory(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public String getConverterMessage() {
        return this.converterMessage;
    }

    public void setConverterMessage(String message) {
        this.converterMessage = message;
    }

    public void addValidatorFactory(ValidatorFactory factory) {
        if (this.validators == null) {
            this.validators = new ArrayList<ValidatorFactory>();
        }
        this.validators.add(factory);
    }

    public List<ValidatorFactory> getValidatorFactories() {
        if (this.validators == null) {
            return Collections.emptyList();
        }
        return this.validators;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    public void setRequiredMessage(String message) {
        this.requiredMessage = message;
    }

    public LocalStringBinding getLocalString() {
        return this.localString;
    }

    public void setLocalString(LocalStringBinding binding) {
        this.localString = binding;
    }

    public SelectItemsBinding getSelectItems() {
        return this.selectItems;
    }

    public void setSelectItems(SelectItemsBinding binding) {
        this.selectItems = binding;
    }

    public RequestParamBinding getRequestParam() {
        return this.requestParam;
    }

    public void setRequestParam(RequestParamBinding requestParam) {
        this.requestParam = requestParam;
    }

    @Override
    public void apply(FacesContext ctx, ModelBindingContext mbc) {
        Set<UIComponent> labelComps;
        UIComponent comp = mbc.getComponent(this.id);
        if (comp == null) {
            return;
        }
        PhaseId phaseId = mbc.getPhaseId();
        ModelBean bean = mbc.getModelBean();
        ValueExpression previous = comp.getValueExpression(this.attribute);
        if (previous instanceof CompositeDataItemAdapter) {
            return;
        }
        if (previous == null || previous instanceof CompositeValueAdapter) {
            CompositeValueAdapter adapter;
            if (previous == null || phaseId != ((CompositeValueAdapter)previous).getPhaseId()) {
                adapter = new CompositeValueAdapter();
                adapter.setPhaseId(phaseId);
                comp.setValueExpression(this.attribute, (ValueExpression)adapter);
            } else {
                adapter = (CompositeValueAdapter)previous;
            }
            PropertyValueAdapter binding = new PropertyValueAdapter(this, bean);
            adapter.addValueBinding(binding);
            ELContext elctx = ctx.getELContext();
            if ("binding".equals(this.attribute)) {
                binding.setValue(elctx, comp);
            } else if (this.expr != null && binding.getValue(elctx) == null) {
                Object value = bean.evaluateExpression(this.expr, this.type);
                binding.setValue(elctx, value);
            }
        }
        if ("value".equals(this.attribute) && comp instanceof ValueHolder) {
            this.applyConverter(bean, (ValueHolder)comp);
            if (comp instanceof EditableValueHolder) {
                this.applyValidators(bean, phaseId, (EditableValueHolder)comp);
            }
        }
        if (this.requestParam != null && phaseId == PhaseId.RENDER_RESPONSE && !FacesUtils.isPostback(ctx)) {
            if (comp instanceof EditableValueHolder && "value".equals(this.attribute)) {
                this.requestParam.applyRequestValue(ctx, comp);
            } else {
                this.requestParam.applyGlobal(ctx, mbc);
            }
        }
        if (this.selectItems != null) {
            this.selectItems.apply(comp, bean);
        }
        if (comp instanceof UIInput) {
            UIInput in = (UIInput)comp;
            String msg = this.getRequiredMessage();
            if (msg != null && msg.length() > 0 && in.getRequiredMessage() == null) {
                in.setRequiredMessage(this.convertStringValue(bean, this.getRequiredMessage()));
            }
        }
        if ((labelComps = BindingUtils.findLabelComponent(ctx, comp)) != null) {
            for (UIComponent labelComp : labelComps) {
                if (labelComp != null) {
                    this.setText(labelComp, bean, this.label, "label", "value");
                }
                this.setText(comp, bean, this.description, "description", "title");
                if (this.security == null || comp.getValueExpression("disabled") != null) continue;
                boolean disabled = !this.security.isUserInRole(ctx);
                comp.setValueExpression("disabled", (ValueExpression)new ValueWrapper(disabled, Boolean.TYPE));
                if (labelComp == null) continue;
                labelComp.setValueExpression("disabled", (ValueExpression)new ValueWrapper(disabled, Boolean.TYPE));
            }
        }
    }

    private String convertStringValue(ModelBean scope, String value) {
        if (scope != null) {
            return scope.evaluateExpression(value, String.class);
        }
        return FacesUtils.evaluateExpressionGet(value, String.class);
    }

    @Override
    public void applyDataItem(FacesContext ctx, ModelBindingContext mbc, UIData data) {
        UIComponent comp = mbc.getComponent(this.id);
        if (comp == null) {
            return;
        }
        PhaseId phaseId = mbc.getPhaseId();
        ValueExpression previous = comp.getValueExpression(this.attribute);
        if (previous == null || previous instanceof CompositeDataItemAdapter) {
            CompositeDataItemAdapter adapter;
            if (previous == null || phaseId != ((CompositeDataItemAdapter)previous).getPhaseId()) {
                adapter = new CompositeDataItemAdapter(data);
                adapter.setPhaseId(phaseId);
                comp.setValueExpression(this.attribute, (ValueExpression)adapter);
            } else {
                adapter = (CompositeDataItemAdapter)previous;
            }
            adapter.addDataItem(new PropertyDataItem(this));
        }
        if ("value".equals(this.attribute) && comp instanceof ValueHolder) {
            this.applyConverter(null, (ValueHolder)comp);
            if (comp instanceof EditableValueHolder) {
                this.applyValidators(null, phaseId, (EditableValueHolder)comp);
            }
        }
        RowDataValueAdapter rowData = new RowDataValueAdapter(data);
        if (comp instanceof ColumnStub) {
            this.setText(comp, (Object)rowData, this.label, "label", "columnHeader");
        } else {
            UIComponent labelComp = BindingUtils.findLabelFacet(ctx, comp, true);
            if (labelComp != null) {
                this.setText(labelComp, (Object)rowData, this.label, "label", "value");
            }
        }
        this.setText(comp, (Object)rowData, this.description, "description", "title");
        if (this.security != null && comp.getValueExpression("disabled") == null) {
            boolean disabled = !this.security.isUserInRole(ctx);
            comp.setValueExpression("disabled", (ValueExpression)new ValueWrapper(disabled, Boolean.TYPE));
        }
    }

    protected void applyConverter(ModelBean bean, ValueHolder comp) {
        Converter converter;
        ConverterFactory factory = this.converterFactory;
        if (factory == null) {
            return;
        }
        Converter previous = comp.getConverter();
        if ((previous == null || previous instanceof ConverterAdapter) && (converter = factory instanceof CustomizingConverterFactory ? ((CustomizingConverterFactory)factory).createConverter(bean, this.type) : factory.createConverter(this.type)) != null) {
            ConverterAdapter adapter;
            if (previous == null) {
                adapter = new ConverterAdapter();
                comp.setConverter((Converter)adapter);
            } else {
                adapter = (ConverterAdapter)previous;
            }
            adapter.setFallback(converter);
        }
    }

    protected void applyValidators(ModelBean bean, PhaseId phaseId, EditableValueHolder comp) {
        if (this.required) {
            comp.setRequired(true);
        }
        if (this.validators != null) {
            CompositeValidator composite = CompositeValidator.getCompositeValidator(comp, phaseId);
            for (ValidatorFactory factory : this.validators) {
                Validator validator = bean != null && factory instanceof CustomizingValidatorFactory ? ((CustomizingValidatorFactory)factory).createValidator(bean) : factory.createValidator();
                if (validator == null) continue;
                composite.addValidator(validator);
            }
        }
    }

    private void setText(UIComponent comp, Object scope, String text, String messageId, String attribute) {
        if (comp.getValueExpression(attribute) == null) {
            if ((text == null || text.length() == 0) && (text = OMUtils.getLocalString(this.getDeclaringClass(), this.id + "." + messageId)) == null && messageId.equals("label")) {
                text = OMUtils.toCamelCase(this.id);
            }
            if (text != null) {
                ValueExpression ve = BindingUtils.createValueWrapper(scope, text, String.class);
                comp.setValueExpression(attribute, ve);
            }
        }
    }

    @Override
    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        Object value;
        ModelBean bean;
        if (this.isWriteable() && this.localString != null && this.getModelValue(bean = mbc.getModelBean()) == null && (value = this.localString.getValue(bean)) != null) {
            this.setModelValue(bean, value);
        }
    }
}

