/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl.processor.bean;

import java.lang.reflect.AnnotatedElement;
import org.operamasks.faces.annotation.Inject;
import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.application.ManagedBeanFactory;
import org.operamasks.faces.binding.impl.Binders;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.DependencyBinder;
import org.operamasks.faces.binding.impl.DependencyBinding;
import org.operamasks.faces.binding.impl.InjectBinder;
import org.operamasks.faces.binding.impl.processor.bean.AnnotationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectProcessor
extends AnnotationProcessor<Inject> {
    public InjectProcessor() {
        super(Inject.class);
    }

    @Override
    public boolean exclusive() {
        return false;
    }

    @Override
    protected Binding build(Inject meta, Class<?> targetClass, AnnotatedElement f) {
        DependencyBinding b = new DependencyBinding();
        b.init(Inject.class, targetClass, f);
        DependencyBinder binder = Binders.getDependencyBinder(b.getType());
        String expr = meta.value();
        if (binder != null) {
            binder.init(b, meta);
        } else {
            binder = expr.length() != 0 ? new InjectBinder(expr, meta.renew()) : this.createManagedBeanBinder(b, meta);
        }
        if (binder != null) {
            b.setBinder(binder);
            b.setOrder(meta.order());
            return b;
        }
        return null;
    }

    private DependencyBinder createManagedBeanBinder(DependencyBinding b, Inject meta) {
        String name = null;
        ManagedBeanScope scope = null;
        for (Class<?> c = b.getType(); c != null; c = c.getSuperclass()) {
            ManagedBean mb = c.getAnnotation(ManagedBean.class);
            if (mb == null) continue;
            name = mb.name();
            scope = mb.scope();
            if (name.length() != 0) break;
            name = c.getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            break;
        }
        if (name == null) {
            String classname = b.getType().getName();
            for (ManagedBeanFactory f : ManagedBeanContainer.getInstance().getBeanFactories()) {
                if (!classname.equals(f.getBeanClassName())) continue;
                name = f.getBeanName();
                scope = f.getScope();
            }
        }
        if (name != null) {
            String expr = "#{" + name + "}";
            boolean renew = meta.renew();
            if (scope == null || scope == ManagedBeanScope.NONE || scope == ManagedBeanScope.REQUEST) {
                renew = true;
            } else if (scope == ManagedBeanScope.APPLICATION) {
                renew = false;
            }
            return new InjectBinder(expr, renew);
        }
        return null;
    }
}

