/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl.processor.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.faces.FacesException;
import org.operamasks.faces.annotation.Converter;
import org.operamasks.faces.annotation.Validator;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ConverterRegistry;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.application.ValidatorRegistry;
import org.operamasks.faces.binding.factories.CustomizingConverterFactory;
import org.operamasks.faces.binding.factories.CustomizingValidatorFactory;
import org.operamasks.resources.Resources;

public class ProcessorUtils {
    static ConverterFactory createConverterFactory(Annotation a) {
        Class<? extends Annotation> at = a.annotationType();
        if (a instanceof Converter) {
            return ProcessorUtils.createConverterFactory((Converter)a);
        }
        if (at.isAnnotationPresent(Converter.class)) {
            try {
                ConverterFactory factory = ProcessorUtils.createConverterFactory(at.getAnnotation(Converter.class));
                CustomizingConverterFactory customized = new CustomizingConverterFactory(factory);
                for (Method method : at.getDeclaredMethods()) {
                    String name = method.getName();
                    if (name.equals("message")) continue;
                    Object value = method.invoke((Object)a, new Object[0]);
                    customized.setConverterProperty(name, value);
                }
                return customized;
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
        return null;
    }

    static ConverterFactory createConverterFactory(Converter meta) {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        if (meta.id().length() != 0) {
            ConverterFactory factory = registry.getConverterFactory(meta.id());
            if (factory == null) {
                throw new FacesException(Resources._T("JSF_NO_SUCH_CONVERTER_ID", meta.id()));
            }
            return factory;
        }
        return registry.createConverterFactory(meta.value());
    }

    static String getConverterMessage(Annotation a) {
        String message;
        try {
            Method m = a.annotationType().getMethod("message", new Class[0]);
            if (m.getReturnType() == String.class && (message = (String)m.invoke((Object)a, new Object[0])) != null && message.length() != 0) {
                return message;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        Converter meta = a.annotationType().getAnnotation(Converter.class);
        if (meta != null && (message = meta.message()) != null && message.length() != 0) {
            return message;
        }
        return null;
    }

    public static ValidatorFactory createValidatorFactory(Annotation a) {
        Class<? extends Annotation> at = a.annotationType();
        if (a instanceof Validator) {
            return ProcessorUtils.createValidatorFactory((Validator)a);
        }
        if (at.isAnnotationPresent(Validator.class)) {
            try {
                ValidatorFactory factory = ProcessorUtils.createValidatorFactory(at.getAnnotation(Validator.class));
                CustomizingValidatorFactory customized = new CustomizingValidatorFactory(factory);
                for (Method method : at.getDeclaredMethods()) {
                    String name = method.getName();
                    Object value = method.invoke((Object)a, new Object[0]);
                    customized.setValidatorProperty(name, value);
                }
                return customized;
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
        return null;
    }

    static ValidatorFactory createValidatorFactory(Validator meta) {
        ValidatorRegistry registry = ValidatorRegistry.getInstance();
        if (meta.id().length() != 0) {
            ValidatorFactory factory = registry.getValidatorFactory(meta.id());
            if (factory == null) {
                throw new FacesException(Resources._T("JSF_NO_SUCH_VALIDATOR_ID", meta.id()));
            }
            return factory;
        }
        return registry.createValidatorFactory(meta.value());
    }
}

