/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.operamasks.faces.component.ComponentContainer;
import org.operamasks.faces.component.ComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentContainer
extends ComponentContainer {
    private Map<String, ComponentFactory> registry = new HashMap<String, ComponentFactory>();
    private Map<Class<? extends UIComponent>, ComponentFactory> factoryCache = new HashMap<Class<? extends UIComponent>, ComponentFactory>();

    @Override
    public void addComponentFactory(ComponentFactory factory) {
        String componentType = factory.getConfig().getComponentType();
        this.registry.put(componentType, factory);
    }

    @Override
    public boolean containsComponentFactory(String componentType) {
        return this.registry.containsKey(componentType);
    }

    @Override
    public Collection<String> getComponentTypes() {
        return Collections.unmodifiableCollection((Collection)this.registry.keySet());
    }

    @Override
    public Collection<ComponentFactory> getComponentFactories() {
        return Collections.unmodifiableCollection(this.registry.values());
    }

    @Override
    public ComponentFactory getComponentFactory(String componentType) {
        if (componentType.equals("org.operamasks.faces.widget.button")) {
            return this.registry.get("org.operamasks.faces.component.widget.UIButton");
        }
        if (componentType.equals("org.operamasks.faces.widget.Separator")) {
            return this.registry.get("org.operamasks.faces.component.widget.UISeparator");
        }
        if ("org.operamasks.faces.widget.OutputColumn".equals(componentType)) {
            return this.registry.get("org.operamasks.faces.component.grid.UIOutputColumn");
        }
        return this.registry.get(componentType);
    }

    @Override
    public ComponentFactory getComponentFactoryByClass(Class<? extends UIComponent> compClass) {
        ComponentFactory fac = this.factoryCache.get(compClass);
        if (fac == null) {
            for (Map.Entry<String, ComponentFactory> entry : this.registry.entrySet()) {
                ComponentFactory f = entry.getValue();
                Class<? extends UIComponent> clz = f.getComponentClass();
                if (!this.factoryCache.containsKey(clz)) {
                    this.factoryCache.put(clz, f);
                }
                if (clz != compClass) continue;
                fac = f;
                break;
            }
        }
        return fac;
    }

    @Override
    public void removeComponentFactory(String componentType) {
        ComponentFactory f = this.registry.get(componentType);
        this.factoryCache.remove(f.getComponentClass());
        this.registry.remove(componentType);
    }

    @Override
    public ComponentFactory getComponentFactoryByName(String compClassName) {
        for (String type : this.registry.keySet()) {
            ComponentFactory fac = this.registry.get(type);
            String className = fac.getConfig().getComponentClass();
            if (!compClassName.equals(className)) continue;
            return fac;
        }
        return null;
    }
}

