/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component.action;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import org.operamasks.faces.component.action.Action;
import org.operamasks.faces.component.action.ActionEvent;
import org.operamasks.faces.component.action.ActionSupport;
import org.operamasks.faces.component.action.ActionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAction
implements Action,
Serializable {
    private Map<String, Object> attrs = new HashMap<String, Object>();
    private transient PropertyChangeSupport changeSupport;

    @Override
    public abstract void processAction(ActionEvent var1) throws AbortProcessingException;

    @Override
    public Collection<String> getAttributesKey() {
        return Collections.unmodifiableCollection(this.attrs.keySet());
    }

    @Override
    public void setAttribute(String key, Object value) {
        Object oldValue = null;
        if (this.attrs.containsKey(key)) {
            oldValue = this.attrs.get(key);
        }
        this.attrs.put(key, value);
        this.firePropertyChange(key, oldValue, value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Object oldDisabled = this.attrs.get("disabled");
        this.firePropertyChange("disabled", oldDisabled, !enabled);
        this.attrs.put("disabled", !enabled);
    }

    @Override
    public void setImmediate(boolean immediate) {
        Object oldImmediate = this.attrs.get("immediate");
        this.firePropertyChange("immediate", oldImmediate, immediate);
        this.attrs.put("immediate", immediate);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attrs.get(key);
    }

    @Override
    public boolean isEnabled() {
        Object v = this.getAttribute("disabled");
        if (v == null) {
            return true;
        }
        if (v instanceof Boolean) {
            return (Boolean)v == false;
        }
        if (v instanceof String) {
            Boolean obj = (Boolean)ActionUtil.getObjectValue(FacesContext.getCurrentInstance(), (String)v, Boolean.class);
            return obj == null ? Boolean.TRUE : obj == false;
        }
        return true;
    }

    @Override
    public boolean isImmediate() {
        Object v = this.getAttribute("immediate");
        if (v == null) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            Boolean obj = (Boolean)ActionUtil.getObjectValue(FacesContext.getCurrentInstance(), (String)v, Boolean.class);
            return obj == null ? Boolean.FALSE : obj;
        }
        return false;
    }

    protected synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null || oldValue == newValue || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        int i;
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        PropertyChangeListener[] listeners = this.changeSupport.getPropertyChangeListeners();
        for (i = 0; i < listeners.length && listeners[i] != listener; ++i) {
        }
        if (i >= listeners.length) {
            this.changeSupport.addPropertyChangeListener(listener);
            this.recordComponentListener(listener);
        }
    }

    private void recordComponentListener(PropertyChangeListener listener) {
        if (listener instanceof UIComponent) {
            Map reqMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
            this.getListenerRecord(reqMap).add(listener);
            if (!(listener instanceof ActionSupport)) {
                this.getListenerToActionMapping(reqMap).put(listener, this);
            }
        }
    }

    private List<PropertyChangeListener> getListenerRecord(Map<String, Object> reqMap) {
        ArrayList componentListeners = (ArrayList)reqMap.get("org.operamasks.faces.component_list_record");
        if (componentListeners == null) {
            componentListeners = new ArrayList();
            reqMap.put("org.operamasks.faces.component_list_record", componentListeners);
        }
        return componentListeners;
    }

    private Map<PropertyChangeListener, Action> getListenerToActionMapping(Map<String, Object> reqMap) {
        HashMap mapping = (HashMap)reqMap.get("org.operamasks.faces.component_action_mapping");
        if (mapping == null) {
            mapping = new HashMap();
            reqMap.put("org.operamasks.faces.component_action_mapping", mapping);
        }
        return mapping;
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void clearPropertyChangeListener() {
        if (this.changeSupport == null || this.changeSupport.getPropertyChangeListeners() == null) {
            return;
        }
        for (PropertyChangeListener pcl : this.changeSupport.getPropertyChangeListeners()) {
            this.changeSupport.removePropertyChangeListener(pcl);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attrs == null ? 0 : ((Object)this.attrs).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAction other = (AbstractAction)obj;
        return !(this.attrs == null ? other.attrs != null : !((Object)this.attrs).equals(other.attrs));
    }
}

