/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.config;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.application.ApplicationEvent;
import org.operamasks.faces.application.ApplicationListener;
import org.operamasks.faces.application.ELResolverRegistry;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.application.ViewMapper;
import org.operamasks.faces.application.impl.DefaultDynamicViewMapper;
import org.operamasks.faces.application.impl.DefaultNavigationHandler;
import org.operamasks.faces.application.impl.DefaultViewMapper;
import org.operamasks.faces.binding.ModelBindingFactory;
import org.operamasks.faces.component.ComponentConfig;
import org.operamasks.faces.config.AnnotationProcessor;
import org.operamasks.faces.config.ConverterConfig;
import org.operamasks.faces.config.FacesConfigLoader;
import org.operamasks.faces.config.ManagedBeanConfig;
import org.operamasks.faces.config.NavigationCase;
import org.operamasks.faces.config.ValidatorConfig;
import org.operamasks.faces.debug.Debug;
import org.operamasks.faces.debug.DebugMode;
import org.operamasks.faces.internal.util.LoadFileUtils;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.internal.util.TemplateEngine;
import org.operamasks.faces.lifecycle.PhaseListenerAdapter;
import org.operamasks.faces.render.AbstractRenderKit;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceMode;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;
import org.operamasks.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FacesConfig {
    private static final Logger configLogger = LoggerUtil.getLogger("org.operamasks.faces.config");
    private static final Logger lifecycleLogger = LoggerUtil.getLogger("org.operamasks.faces.lifecycle");
    private ServletContext context;
    private List<String> applicationFactories = FacesConfig.newList();
    private List<String> facesContextFactories = FacesConfig.newList();
    private List<String> lifecycleFactories = FacesConfig.newList();
    private List<String> renderKitFactories = FacesConfig.newList();
    private List<String> actionListeners = FacesConfig.newList();
    private String defaultRenderKitId;
    private String messageBundle;
    private List<String> navigationHandlers = FacesConfig.newList();
    private List<String> viewHandlers = FacesConfig.newList();
    private List<String> viewMappers = FacesConfig.newList();
    private List<String> stateManagers = FacesConfig.newList();
    private List<String> elResolvers = FacesConfig.newList();
    private List<String> propertyResolvers = FacesConfig.newList();
    private List<String> variableResolvers = FacesConfig.newList();
    private Locale defaultLocale;
    private List<Locale> supportedLocales = FacesConfig.newList();
    private List<ResourceBundleConfig> resourceBundles = FacesConfig.newList();
    private List<ComponentConfig> components = FacesConfig.newList();
    private List<ConverterConfig> converters = FacesConfig.newList();
    private List<ValidatorConfig> validators = FacesConfig.newList();
    private List<ManagedBeanConfig> managedBeans = FacesConfig.newList();
    private List<NavigationCase> navigationCases = FacesConfig.newList();
    private List<RenderKitConfig> renderKits = FacesConfig.newList();
    private List<String> phaseListeners = FacesConfig.newList();
    private List<ViewMappingConfig> viewMappings = FacesConfig.newList();
    private List<String> metaDataJars = FacesConfig.newList();
    private List<String> metaDataDirs = FacesConfig.newList();
    private List<String> metaDataPackages = FacesConfig.newList();
    private static final String FACELET_VIEW_HANDLER = "com.sun.facelets.FaceletViewHandler";
    private static final String FACELET_VIEW_HANDLER_HOOK = "org.operamasks.faces.facelets.FaceletViewHandlerHook";
    private static final String DYNAMIC_FACELET_VIEW_HANDLER = "org.operamasks.faces.facelets.DynamicFaceletViewHandler";
    private List<DynamicViewMappingConfig> dynamicViewMappings = FacesConfig.newList();
    private TemplateEngineConfig templateEngineConfig = new TemplateEngineConfig();
    private static String[] operamasksConfigs = new String[]{"META-INF/core-config.xml", "META-INF/html-basic-config.xml", "META-INF/jsf-ajax-config.xml", "META-INF/ajax-config.xml", "META-INF/widget-config.xml", "META-INF/layout-config.xml", "META-INF/graph-config.xml", "META-INF/misc-config.xml"};

    FacesConfig(ServletContext context) {
        this.context = context;
    }

    void load() {
        this.loadDefaultConfig();
        this.loadFromMetaInf();
        this.loadContextSpecified();
        this.loadFromWebInf();
        this.loadFromMetaData();
        this.applyConfig();
    }

    private void loadDefaultConfig() {
        for (String config : operamasksConfigs) {
            URL resource = LoadFileUtils.getClassLoader().getResource(config);
            if (resource == null) continue;
            this.parse(resource);
        }
    }

    private void loadFromMetaInf() {
        try {
            ClassLoader loader = FacesConfig.getClassLoader();
            Enumeration<URL> resources = loader.getResources("META-INF/faces-config.xml");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                configLogger.info(Resources._T("JSF_LOAD_FACES_CONFIG", resource.getFile()));
                this.parse(resource);
            }
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private void loadContextSpecified() {
        String parameter = this.context.getInitParameter("javax.faces.CONFIG_FILES");
        if (parameter == null) {
            return;
        }
        for (String path : parameter.split(",")) {
            try {
                URL resource = this.context.getResource(path.trim());
                configLogger.info(Resources._T("JSF_LOAD_FACES_CONFIG", resource.getFile()));
                this.parse(resource);
            }
            catch (MalformedURLException ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }

    private void loadFromWebInf() {
        URL resource;
        try {
            resource = this.context.getResource("/WEB-INF/faces-config.xml");
            if (resource != null) {
                configLogger.info(Resources._T("JSF_LOAD_FACES_CONFIG", resource.getFile()));
                this.parse(resource);
            }
        }
        catch (MalformedURLException ex) {
            throw new FacesException((Throwable)ex);
        }
        try {
            resource = this.context.getResource("/WEB-INF/operamasks.xml");
            if (resource != null) {
                configLogger.info(Resources._T("JSF_LOAD_FACES_CONFIG", resource.getFile()));
                this.parseExtension(resource);
            }
        }
        catch (MalformedURLException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private void loadFromMetaData() {
        AnnotationProcessor processor = new AnnotationProcessor(this.context, FacesConfig.getClassLoader());
        for (ManagedBeanConfig mbean : this.managedBeans) {
            processor.scanManagedBean(mbean);
        }
        processor.setMetaDataJars(this.metaDataJars);
        processor.setMetaDataDirs(this.metaDataDirs);
        if (this.metaDataPackages.size() == 0) {
            this.metaDataPackages.add("*");
        }
        processor.setMetaDataPackages(this.metaDataPackages);
        processor.scan();
        for (ManagedBeanConfig bean : processor.getManagedBeans()) {
            this.addManagedBean(bean);
        }
        this.converters.addAll(processor.getConverters());
        this.validators.addAll(processor.getValidators());
        this.phaseListeners.addAll(processor.getPhaseListeners());
    }

    private Document parseResource(URL resource) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            return db.parse(resource.toString());
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private void parse(URL resource) {
        Document doc = this.parseResource(resource);
        Element root = doc.getDocumentElement();
        for (Node kid = root.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            String tag = kid.getNodeName();
            if (tag.equals("application")) {
                this.parseApplication(kid);
                continue;
            }
            if (tag.equals("factory")) {
                this.parseFactory(kid);
                continue;
            }
            if (tag.equals("component")) {
                this.parseComponent(kid);
                continue;
            }
            if (tag.equals("converter")) {
                this.parseConverter(kid);
                continue;
            }
            if (tag.equals("managed-bean")) {
                this.parseManagedBean(kid);
                continue;
            }
            if (tag.equals("navigation-rule")) {
                this.parseNavigationRule(kid);
                continue;
            }
            if (tag.equals("referenced-bean")) continue;
            if (tag.equals("render-kit")) {
                this.parseRenderKit(kid);
                continue;
            }
            if (tag.equals("lifecycle")) {
                this.parseLifecycle(kid);
                continue;
            }
            if (!tag.equals("validator")) continue;
            this.parseValidator(kid);
        }
    }

    private void parseExtension(URL resource) {
        Document doc = this.parseResource(resource);
        Element root = doc.getDocumentElement();
        for (Node kid = root.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            String tag = kid.getNodeName();
            if (tag.equals("view-mapper")) {
                this.viewMappers.add(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("view-mapping")) {
                this.parseViewMapping(kid);
                continue;
            }
            if (tag.equals("debug-mode")) {
                this.parseDebugMode(kid);
                continue;
            }
            if (tag.equals("metadata")) {
                this.parseMetadata(kid);
                continue;
            }
            if (tag.equals("client-exception")) {
                this.parseShowException(kid);
                continue;
            }
            if (tag.equals("template-engine")) {
                this.parseTemplateEngine(kid);
                continue;
            }
            if (tag.equals("dynamic-view-mapping")) {
                this.parseDynamicViewMapping(kid);
                continue;
            }
            if (!tag.equals("resource")) continue;
            this.parseResource(kid);
        }
    }

    private void parseDynamicViewMapping(Node dynamicViewMapping) {
        DynamicViewMappingConfig config = new DynamicViewMappingConfig();
        for (Node kid = dynamicViewMapping.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            if (kid.getNodeName().equals("url-pattern")) {
                config.viewIds.add(kid.getTextContent().trim());
                continue;
            }
            if (kid.getNodeName().equals("template-context-handler")) {
                config.templateHandler = kid.getTextContent().trim();
                continue;
            }
            if (kid.getNodeName().equals("strategy")) {
                config.strategy = kid.getTextContent().trim();
                continue;
            }
            if (!kid.getNodeName().equals("keep-generated")) continue;
            config.keepGenerated = kid.getTextContent().trim();
        }
        this.dynamicViewMappings.add(config);
    }

    private void parseTemplateEngine(Node templateEngine) {
        for (Node kid = templateEngine.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            Element child = (Element)kid;
            if ("name".equals(child.getNodeName())) {
                this.templateEngineConfig.templateName = child.getTextContent().trim();
                continue;
            }
            if ("param".equals(child.getNodeName())) {
                Node item;
                String paramKey = null;
                String paramValue = null;
                NodeList elementsByTagName = child.getElementsByTagName("param-name");
                if (elementsByTagName.getLength() > 0) {
                    item = elementsByTagName.item(0);
                    paramKey = item.getTextContent().trim();
                }
                if ((elementsByTagName = child.getElementsByTagName("param-value")).getLength() > 0) {
                    item = elementsByTagName.item(0);
                    paramValue = item.getTextContent().trim();
                }
                if (paramKey == null || paramValue == null) continue;
                this.templateEngineConfig.params.put(paramKey, paramValue);
                continue;
            }
            if (!"working-dir".equals(child.getNodeName())) continue;
            this.templateEngineConfig.workingDir = child.getTextContent().trim();
        }
    }

    private void parseShowException(Node el) {
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            String tag = kid.getNodeName();
            String nodeText = kid.getTextContent().trim();
            if ("catch-all".equals(tag)) {
                if (!"false".equals(nodeText) && !"off".equals(nodeText)) continue;
                ComponentResource.setCatchAllException(false);
                continue;
            }
            if (!"show-exception".equals(tag) || !"false".equals(nodeText) && !"off".equals(nodeText)) continue;
            ComponentResource.setShowClientException(false);
        }
    }

    private void parseFactory(Node el) {
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            String tag = kid.getNodeName();
            if (tag.equals("application-factory")) {
                this.applicationFactories.add(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("faces-context-factory")) {
                this.facesContextFactories.add(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("lifecycle-factory")) {
                this.lifecycleFactories.add(kid.getTextContent().trim());
                continue;
            }
            if (!tag.equals("render-kit-factory")) continue;
            this.renderKitFactories.add(kid.getTextContent().trim());
        }
    }

    private void parseApplication(Node el) {
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            String tag = kid.getNodeName();
            if (tag.equals("action-listener")) {
                this.actionListeners.add(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("default-render-kit-id")) {
                this.defaultRenderKitId = kid.getTextContent().trim();
                continue;
            }
            if (tag.equals("message-bundle")) {
                this.messageBundle = kid.getTextContent().trim();
                continue;
            }
            if (tag.equals("navigation-handler")) {
                this.navigationHandlers.add(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("view-handler")) {
                String name = kid.getTextContent().trim();
                if (name.equals(FACELET_VIEW_HANDLER)) {
                    try {
                        FacesConfig.getClassLoader().loadClass(DYNAMIC_FACELET_VIEW_HANDLER);
                        name = DYNAMIC_FACELET_VIEW_HANDLER;
                    }
                    catch (ClassNotFoundException e) {
                        name = FACELET_VIEW_HANDLER_HOOK;
                    }
                }
                this.viewHandlers.add(name);
                continue;
            }
            if (tag.equals("state-manager")) {
                this.stateManagers.add(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("el-resolver")) {
                this.elResolvers.add(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("property-resolver")) {
                this.propertyResolvers.add(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("variable-resolver")) {
                this.variableResolvers.add(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("locale-config")) {
                this.parseLocaleConfig(kid);
                continue;
            }
            if (!tag.equals("resource-bundle")) continue;
            ResourceBundleConfig rb = new ResourceBundleConfig();
            rb.displayName = FacesConfig.getElementContent(kid, "display-name");
            rb.baseName = FacesConfig.getElementContent(kid, "base-name");
            rb.var = FacesConfig.getElementContent(kid, "var");
            this.resourceBundles.add(rb);
        }
    }

    private void parseLocaleConfig(Node el) {
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            Locale l;
            String localeString;
            if (kid.getNodeType() != 1) continue;
            String tag = kid.getNodeName();
            if (tag.equals("default-locale")) {
                localeString = kid.getTextContent().trim();
                l = OMUtils.getLocaleFromString(localeString);
                if (l == null) continue;
                this.defaultLocale = l;
                continue;
            }
            if (!tag.equals("supported-locale") || (l = OMUtils.getLocaleFromString(localeString = kid.getTextContent().trim())) == null) continue;
            this.supportedLocales.add(l);
        }
    }

    private void parseComponent(Node el) {
        String componentType = FacesConfig.getElementContent(el, "component-type");
        String componentClass = FacesConfig.getElementContent(el, "component-class");
        ComponentConfig config = new ComponentConfig(componentType, componentClass);
        this.components.add(config);
    }

    private void parseConverter(Node el) {
        ConverterConfig config = new ConverterConfig();
        config.setConverterId(FacesConfig.getElementContent(el, "converter-id"));
        config.setConverterForClass(FacesConfig.getElementContent(el, "converter-for-class"));
        config.setConverterClass(FacesConfig.getElementContent(el, "converter-class"));
        this.converters.add(config);
    }

    private void parseManagedBean(Node el) {
        ManagedBeanConfig bean = new ManagedBeanConfig();
        bean.setDisplayName(FacesConfig.getElementContent(el, "display-name"));
        bean.setDescription(FacesConfig.getElementContent(el, "description"));
        bean.setManagedBeanName(FacesConfig.getElementContent(el, "managed-bean-name"));
        bean.setManagedBeanClass(FacesConfig.getElementContent(el, "managed-bean-class"));
        bean.setManagedBeanScope(FacesConfig.getElementContent(el, "managed-bean-scope"));
        Node mapEntriesNode = FacesConfig.getElementByTagName(el, "map-entries");
        Node listEntriesNode = FacesConfig.getElementByTagName(el, "list-entries");
        if (mapEntriesNode != null) {
            bean.setMapEntries(this.parseMapEntries(mapEntriesNode));
        } else if (listEntriesNode != null) {
            bean.setListEntries(this.parseListEntries(listEntriesNode));
        } else {
            for (Node managedPropertyNode : FacesConfig.getElementsByTagName(el, "managed-property")) {
                bean.addManagedProperty(this.parseManagedProperty(managedPropertyNode));
            }
        }
        this.addManagedBean(bean);
    }

    private void addManagedBean(ManagedBeanConfig bean) {
        String name = bean.getManagedBeanName();
        for (ManagedBeanConfig exist : this.managedBeans) {
            String newBeanClass;
            if (!name.equals(exist.getManagedBeanName())) continue;
            String oldBeanClass = exist.getManagedBeanClass();
            if (!oldBeanClass.equals(newBeanClass = bean.getManagedBeanClass())) {
                configLogger.warning(Resources._T("JSF_DUPPLICATE_MANAGED_BEAN", name, oldBeanClass, newBeanClass));
            }
            return;
        }
        this.managedBeans.add(bean);
    }

    private ManagedBeanConfig.Property parseManagedProperty(Node el) {
        ManagedBeanConfig.Property property = new ManagedBeanConfig.Property();
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            String tag = kid.getNodeName();
            if (tag.equals("property-name")) {
                property.setPropertyName(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("property-class")) {
                property.setPropertyClass(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("null-value")) {
                property.setValue(null);
                continue;
            }
            if (tag.equals("value")) {
                property.setValue(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("map-entries")) {
                property.setMapEntries(this.parseMapEntries(kid));
                continue;
            }
            if (!tag.equals("list-entries")) continue;
            property.setListEntries(this.parseListEntries(kid));
        }
        return property;
    }

    private ManagedBeanConfig.MapEntries parseMapEntries(Node el) {
        ManagedBeanConfig.MapEntries mapEntries = new ManagedBeanConfig.MapEntries();
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            String tag = kid.getNodeName();
            if (tag.equals("key-class")) {
                mapEntries.setKeyClass(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("value-class")) {
                mapEntries.setValueClass(kid.getTextContent().trim());
                continue;
            }
            if (!tag.equals("map-entry")) continue;
            ManagedBeanConfig.MapEntry entry = new ManagedBeanConfig.MapEntry();
            entry.setKey(FacesConfig.getElementContent(kid, "key"));
            if (FacesConfig.getElementByTagName(kid, "null-value") != null) {
                entry.setValue(null);
            } else {
                entry.setValue(FacesConfig.getElementContent(kid, "value"));
            }
            mapEntries.addMapEntry(entry);
        }
        return mapEntries;
    }

    private ManagedBeanConfig.ListEntries parseListEntries(Node el) {
        ManagedBeanConfig.ListEntries listEntries = new ManagedBeanConfig.ListEntries();
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            String tag = kid.getNodeName();
            if (tag.equals("value-class")) {
                listEntries.setValueClass(kid.getTextContent().trim());
                continue;
            }
            if (tag.equals("null-value")) {
                listEntries.addValue(null);
                continue;
            }
            if (!tag.equals("value")) continue;
            listEntries.addValue(kid.getTextContent().trim());
        }
        return listEntries;
    }

    private void parseNavigationRule(Node el) {
        String fromViewId = FacesConfig.getElementContent(el, "from-view-id");
        if (fromViewId == null || fromViewId.length() == 0) {
            fromViewId = "*";
        }
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1 || !kid.getNodeName().equals("navigation-case")) continue;
            NavigationCase navcase = new NavigationCase();
            navcase.setFromViewId(fromViewId);
            navcase.setFromAction(FacesConfig.getElementContent(kid, "from-action"));
            navcase.setFromOutcome(FacesConfig.getElementContent(kid, "from-outcome"));
            navcase.setToViewId(FacesConfig.getElementContent(kid, "to-view-id"));
            if (FacesConfig.getElementByTagName(kid, "redirect") != null) {
                navcase.setRedirect(true);
            }
            this.navigationCases.add(navcase);
        }
    }

    private void parseRenderKit(Node el) {
        RenderKitConfig rk = new RenderKitConfig();
        rk.renderKitId = FacesConfig.getElementContent(el, "render-kit-id");
        rk.renderKitClass = FacesConfig.getElementContent(el, "render-kit-class");
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1 || !kid.getNodeName().equals("renderer")) continue;
            RendererConfig rd = new RendererConfig();
            rd.componentFamily = FacesConfig.getElementContent(kid, "component-family");
            rd.rendererType = FacesConfig.getElementContent(kid, "renderer-type");
            rd.rendererClass = FacesConfig.getElementContent(kid, "renderer-class");
            rk.renderers.add(rd);
        }
        this.renderKits.add(rk);
    }

    private void parseLifecycle(Node el) {
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1 || !kid.getNodeName().equals("phase-listener")) continue;
            this.phaseListeners.add(kid.getTextContent().trim());
        }
    }

    private void parseValidator(Node el) {
        ValidatorConfig v = new ValidatorConfig();
        v.setValidatorId(FacesConfig.getElementContent(el, "validator-id"));
        v.setValidatorClass(FacesConfig.getElementContent(el, "validator-class"));
        this.validators.add(v);
    }

    private void parseViewMapping(Node el) {
        ViewMappingConfig config = new ViewMappingConfig();
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            if (kid.getNodeName().equals("url-pattern")) {
                config.viewIds.add(kid.getTextContent().trim());
                continue;
            }
            if (!kid.getNodeName().equals("model-bean")) continue;
            config.beanNames.add(kid.getTextContent().trim());
        }
        this.viewMappings.add(config);
    }

    private void parseDebugMode(Node el) {
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            String misc;
            if (kid.getNodeType() != 1) continue;
            if (kid.getNodeName().equals("lifecycle-phases")) {
                this.parseLifecyclePhasesDebugMode(kid);
                continue;
            }
            if (kid.getNodeName().equals("include-component-ids")) {
                Debug.setValue(DebugMode.INCLUDE_COMPONENT_IDS, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("exclude-component-ids")) {
                Debug.setValue(DebugMode.EXCLUDE_COMPONENT_IDS, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("include-component-classes")) {
                Debug.setValue(DebugMode.INCLUDE_COMPONENT_CLASSES, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("exclude-component-classes")) {
                Debug.setValue(DebugMode.EXCLUDE_COMPONENT_CLASSES, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("include-component-methods")) {
                Debug.setValue(DebugMode.INCLUDE_COMPONENT_METHODS, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("exclude-component-methods")) {
                Debug.setValue(DebugMode.EXCLUDE_COMPONENT_METHODS, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("include-renderer-types")) {
                Debug.setValue(DebugMode.INCLUDE_RENDERER_TYPES, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("exclude-renderer-types")) {
                Debug.setValue(DebugMode.EXCLUDE_RENDERER_TYPES, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("include-renderer-methods")) {
                Debug.setValue(DebugMode.INCLUDE_RENDERER_METHODS, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("exclude-renderer-methods")) {
                Debug.setValue(DebugMode.EXCLUDE_RENDERER_METHODS, kid.getTextContent().trim().split(","));
                continue;
            }
            if (kid.getNodeName().equals("exception")) {
                String exception = kid.getTextContent().trim().toLowerCase();
                if (!"true".equals(exception) && !"on".equals(exception)) continue;
                Debug.setValue(DebugMode.EXCEPTION, true);
                continue;
            }
            if (kid.getNodeName().equals("uncompressed-js")) {
                String uncompressedJs = kid.getTextContent().trim().toLowerCase();
                if (!"true".equals(uncompressedJs) && !"on".equals(uncompressedJs)) continue;
                Debug.setValue(DebugMode.UNCOMPRESSED_JS, true);
                continue;
            }
            if (kid.getNodeName().equals("beautify-js")) {
                String beautifyjs = kid.getTextContent().trim().toLowerCase();
                if (!"true".equals(beautifyjs) && !"on".equals(beautifyjs)) continue;
                Debug.setValue(DebugMode.BEAUTIFY_JS, true);
                continue;
            }
            if (kid.getNodeName().equals("disable-alias")) {
                String disablealias = kid.getTextContent().trim().toLowerCase();
                if (!"true".equals(disablealias) && !"on".equals(disablealias)) continue;
                Debug.setValue(DebugMode.DISABLE_ALIAS, true);
                continue;
            }
            if (!kid.getNodeName().equals("misc") || !"true".equals(misc = kid.getTextContent().trim().toLowerCase()) && !"on".equals(misc)) continue;
            Debug.setValue(DebugMode.MISC, true);
        }
    }

    private void parseResource(Node el) {
        FacesContext context = FacesContext.getCurrentInstance();
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            if (kid.getNodeName().equals("merge-js")) {
                String mergeJs = kid.getTextContent().trim().toLowerCase();
                if ("true".equals(mergeJs) || "on".equals(mergeJs)) {
                    ResourceMode.setValue(context, ResourceMode.MERGE_JS, Boolean.TRUE);
                    continue;
                }
                if (!"false".equals(mergeJs) && !"off".equals(mergeJs)) continue;
                ResourceMode.setValue(context, ResourceMode.MERGE_JS, Boolean.FALSE);
                continue;
            }
            if (!kid.getNodeName().equals("merge-css")) continue;
            String mergeCss = kid.getTextContent().trim().toLowerCase();
            if ("true".equals(mergeCss) || "on".equals(mergeCss)) {
                ResourceMode.setValue(context, ResourceMode.MERGE_CSS, Boolean.TRUE);
                continue;
            }
            if (!"false".equals(mergeCss) && !"off".equals(mergeCss)) continue;
            ResourceMode.setValue(context, ResourceMode.MERGE_CSS, Boolean.FALSE);
        }
    }

    private void parseMetadata(Node el) {
        for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            if (kid.getNodeName().equals("jar")) {
                this.metaDataJars.add(kid.getTextContent().trim());
                continue;
            }
            if (kid.getNodeName().equals("dir")) {
                this.metaDataDirs.add(kid.getTextContent().trim());
                continue;
            }
            if (!kid.getNodeName().equals("package")) continue;
            this.metaDataPackages.add(kid.getTextContent().trim());
        }
    }

    private void parseLifecyclePhasesDebugMode(Node kid) {
        String phases = kid.getTextContent().trim();
        StringTokenizer tokenizer = new StringTokenizer(phases, ",");
        while (tokenizer.hasMoreTokens()) {
            String strPhaseOrdinal = tokenizer.nextToken();
            int phaseOrdinal = -1;
            try {
                phaseOrdinal = Integer.parseInt(strPhaseOrdinal);
                if (phaseOrdinal < 1 || phaseOrdinal > 6) continue;
                Debug.setValue(Debug.DEBUG_MODE_LIFECYCLE_PHASES[phaseOrdinal - 1], true);
            }
            catch (Exception e) {}
        }
    }

    private static Node getElementByTagName(Node el, String tag) {
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !tag.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }

    private static List<Node> getElementsByTagName(Node el, String tag) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !tag.equals(node.getNodeName())) continue;
            nodeList.add(node);
        }
        return nodeList;
    }

    private static String getElementContent(Node el, String tag) {
        Node node = FacesConfig.getElementByTagName(el, tag);
        if (node == null) {
            return null;
        }
        return node.getTextContent().trim();
    }

    private void applyConfig() {
        this.applyFactoryConfig();
        this.applyApplicationConfig();
        this.applyELResolverConfig();
        this.applyManagedBeanConfig();
        this.applyNavigationRuleConfig();
        this.applyRenderKitConfig();
        this.applyLifecycleConfig();
        this.applyViewMappingConfig();
        this.applyTemplateEngineConfig();
        this.applyDynamicViewMappingConfig();
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application app = factory.getApplication();
        ApplicationAssociate associate = ApplicationAssociate.getInstance(this.context);
        ApplicationListener[] applicationListeners = associate.getApplicationListeners();
        if (applicationListeners != null) {
            ApplicationEvent event = new ApplicationEvent(app, this.context);
            for (ApplicationListener l : applicationListeners) {
                try {
                    l.applicationInitialized(event);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void applyFactoryConfig() {
        for (String factory : this.applicationFactories) {
            FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)factory);
        }
        for (String factory : this.facesContextFactories) {
            FactoryFinder.setFactory((String)"javax.faces.context.FacesContextFactory", (String)factory);
        }
        for (String factory : this.lifecycleFactories) {
            FactoryFinder.setFactory((String)"javax.faces.lifecycle.LifecycleFactory", (String)factory);
        }
        for (String factory : this.renderKitFactories) {
            FactoryFinder.setFactory((String)"javax.faces.render.RenderKitFactory", (String)factory);
        }
    }

    private void applyApplicationConfig() {
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application app = factory.getApplication();
        ApplicationAssociate associate = ApplicationAssociate.getInstance(this.context);
        ApplicationListener[] applicationListeners = associate.getApplicationListeners();
        if (applicationListeners != null) {
            ApplicationEvent event = new ApplicationEvent(app, this.context);
            for (ApplicationListener l : applicationListeners) {
                try {
                    l.applicationCreated(event);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!this.actionListeners.isEmpty()) {
            ActionListener actionListener = FacesConfig.createInstance(ActionListener.class, this.actionListeners, app.getActionListener());
            app.setActionListener(actionListener);
        }
        if (this.defaultRenderKitId != null) {
            app.setDefaultRenderKitId(this.defaultRenderKitId);
        }
        if (this.messageBundle != null) {
            app.setMessageBundle(this.messageBundle);
        }
        if (!this.navigationHandlers.isEmpty()) {
            NavigationHandler navigationHandler = FacesConfig.createInstance(NavigationHandler.class, this.navigationHandlers, app.getNavigationHandler());
            app.setNavigationHandler(navigationHandler);
        }
        if (!this.viewHandlers.isEmpty()) {
            ViewHandler viewHandler = FacesConfig.createInstance(ViewHandler.class, this.viewHandlers, app.getViewHandler());
            app.setViewHandler(viewHandler);
        }
        if (!this.viewMappers.isEmpty()) {
            ModelBindingFactory mbf = ModelBindingFactory.instance();
            ViewMapper viewMapper = FacesConfig.createInstance(ViewMapper.class, this.viewMappers, mbf.getViewMapper());
            mbf.setViewMapper(viewMapper);
        }
        if (!this.stateManagers.isEmpty()) {
            StateManager stateManager = FacesConfig.createInstance(StateManager.class, this.stateManagers, app.getStateManager());
            app.setStateManager(stateManager);
        }
        if (this.defaultLocale != null) {
            app.setDefaultLocale(this.defaultLocale);
        }
        if (!this.supportedLocales.isEmpty()) {
            app.setSupportedLocales(this.supportedLocales);
        }
        if (!this.components.isEmpty()) {
            for (ComponentConfig componentConfig : this.components) {
                app.addComponent(componentConfig.getComponentType(), componentConfig.getComponentClass());
            }
        }
        if (!this.converters.isEmpty()) {
            for (ConverterConfig converterConfig : this.converters) {
                if (converterConfig.getConverterId() != null) {
                    app.addConverter(converterConfig.getConverterId(), converterConfig.getConverterClass());
                }
                if (converterConfig.getConverterForClass() == null) continue;
                try {
                    Class c = Utils.findClass((String)converterConfig.getConverterForClass(), (ClassLoader)FacesConfig.getClassLoader());
                    app.addConverter(c, converterConfig.getConverterClass());
                }
                catch (ClassNotFoundException ex) {
                    throw new FacesException(Resources._T("JSF_CLASS_NOT_FOUND", converterConfig.getConverterClass()), (Throwable)ex);
                }
            }
        }
        if (!this.validators.isEmpty()) {
            for (ValidatorConfig validatorConfig : this.validators) {
                app.addValidator(validatorConfig.getValidatorId(), validatorConfig.getValidatorClass());
            }
        }
        if (!this.resourceBundles.isEmpty()) {
            for (ResourceBundleConfig resourceBundleConfig : this.resourceBundles) {
                associate.addResourceBundle(resourceBundleConfig.var, resourceBundleConfig.baseName, resourceBundleConfig.displayName);
            }
        }
    }

    private void applyELResolverConfig() {
        PropertyResolver resolver;
        ELResolverRegistry registry = ELResolverRegistry.getInstance();
        if (!this.elResolvers.isEmpty()) {
            for (String name : this.elResolvers) {
                ELResolver resolver2 = FacesConfig.createInstance(ELResolver.class, name, null);
                registry.addELResolverFromConfig(resolver2);
            }
        }
        if (!this.propertyResolvers.isEmpty()) {
            resolver = registry.getDefaultPropertyResolver();
            resolver = FacesConfig.createInstance(PropertyResolver.class, this.propertyResolvers, resolver);
            registry.setPropertyResolverFromConfig(resolver);
        }
        if (!this.variableResolvers.isEmpty()) {
            resolver = registry.getDefaultVariableResolver();
            resolver = (VariableResolver)FacesConfig.createInstance(VariableResolver.class, this.variableResolvers, resolver);
            registry.setVariableResolverFromConfig((VariableResolver)resolver);
        }
        registry.registerELResolverWithJsp(this.context);
    }

    private void applyManagedBeanConfig() {
        ManagedBeanContainer container = ManagedBeanContainer.getInstance();
        for (ManagedBeanConfig mbean : this.managedBeans) {
            container.addBeanFactory(mbean);
        }
    }

    private void applyNavigationRuleConfig() {
        DefaultNavigationHandler handler = DefaultNavigationHandler.getInstance();
        if (handler != null) {
            for (NavigationCase navcase : this.navigationCases) {
                handler.addNavigationCase(navcase);
            }
        }
    }

    private void applyRenderKitConfig() {
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        for (RenderKitConfig rkc : this.renderKits) {
            RenderKit rk;
            String renderKitId = rkc.renderKitId;
            if (renderKitId == null) {
                renderKitId = "HTML_BASIC";
            }
            if ((rk = rkFactory.getRenderKit(null, renderKitId)) == null) {
                if (rkc.renderKitClass == null) {
                    throw new FacesException(Resources._T("JSF_NO_SUCH_RENDER_KIT_ID", renderKitId));
                }
                rk = FacesConfig.createInstance(RenderKit.class, rkc.renderKitClass, null);
                if (rk == null) {
                    rk = new AbstractRenderKit(){

                        protected ResponseWriter implCreateResponseWriter(Writer writer, String contentType, String encoding) {
                            return null;
                        }

                        public ResponseStateManager getResponseStateManager() {
                            return null;
                        }
                    };
                }
                rkFactory.addRenderKit(renderKitId, rk);
            }
            for (RendererConfig rdc : rkc.renderers) {
                Renderer rd = FacesConfig.createInstance(Renderer.class, rdc.rendererClass, null);
                if (rd == null) {
                    rd = new Renderer(){};
                }
                rk.addRenderer(rdc.componentFamily, rdc.rendererType, rd);
            }
        }
    }

    private void applyLifecycleConfig() {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
        for (String className : this.phaseListeners) {
            PhaseListenerAdapter listener = new PhaseListenerAdapter(FacesConfig.loadClass(className));
            lifecycle.addPhaseListener((PhaseListener)listener);
            if (!lifecycleLogger.isLoggable(Level.FINEST)) continue;
            lifecycleLogger.finest("PhaseListener '" + className + "' added");
        }
    }

    private void applyViewMappingConfig() {
        DefaultViewMapper viewMapper = DefaultViewMapper.getInstance();
        if (viewMapper != null) {
            for (ViewMappingConfig config : this.viewMappings) {
                for (String viewId : config.viewIds) {
                    for (String beanName : config.beanNames) {
                        viewMapper.addViewMapping(viewId, beanName);
                    }
                }
            }
        }
    }

    private void applyDynamicViewMappingConfig() {
        DefaultDynamicViewMapper viewMapper = DefaultDynamicViewMapper.getInstance();
        if (viewMapper != null) {
            for (DynamicViewMappingConfig config : this.dynamicViewMappings) {
                for (String viewId : config.viewIds) {
                    String templateHandler = config.templateHandler;
                    String strategy = config.strategy;
                    String keepGenerated = config.keepGenerated;
                    viewMapper.addViewMapping(viewId, templateHandler, strategy, keepGenerated);
                }
            }
        }
    }

    private void applyTemplateEngineConfig() {
        TemplateEngine templateEngine = TemplateEngine.getInstance();
        templateEngine.setTemplateName(this.templateEngineConfig.templateName);
        templateEngine.setParams(this.templateEngineConfig.params);
        templateEngine.setWorkingDir(this.templateEngineConfig.workingDir);
    }

    private static ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = FacesConfigLoader.class.getClassLoader();
        }
        return loader;
    }

    private static <T> T createInstance(Class<T> root, List<String> classNames, T delegate) {
        T result = delegate;
        for (String name : classNames) {
            result = FacesConfig.createInstance(root, name, result);
        }
        return result;
    }

    private static Class<?> loadClass(String className) {
        Class<?> clazz;
        try {
            clazz = FacesConfig.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new FacesException(Resources._T("JSF_CLASS_NOT_FOUND", className), (Throwable)ex);
        }
        return clazz;
    }

    private static <T> T createInstance(Class<T> root, String className, T delegate) {
        Class<?> clazz;
        try {
            clazz = FacesConfig.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new FacesException(Resources._T("JSF_CLASS_NOT_FOUND", className), (Throwable)ex);
        }
        if (!root.isAssignableFrom(clazz)) {
            throw new FacesException(Resources._T("JSF_UNEXPECTED_CLASS", className, root.getName()));
        }
        T result = null;
        try {
            try {
                Constructor<?> cons = clazz.getConstructor(root);
                result = (T)cons.newInstance(delegate);
            }
            catch (NoSuchMethodException ex) {
                result = (T)clazz.newInstance();
            }
        }
        catch (Throwable ex) {
            configLogger.log(Level.SEVERE, Resources._T("JSF_INSTANTIATION_ERROR", className), ex);
        }
        return result;
    }

    private static <T> List<T> newList() {
        return new ArrayList();
    }

    static /* synthetic */ List access$100() {
        return FacesConfig.newList();
    }

    private static class TemplateEngineConfig {
        public String templateName;
        public Map<String, String> params = new HashMap<String, String>();
        public String workingDir;

        private TemplateEngineConfig() {
        }
    }

    private static class DynamicViewMappingConfig {
        public List<String> viewIds = FacesConfig.access$100();
        public String templateHandler;
        public String strategy;
        public String keepGenerated;

        private DynamicViewMappingConfig() {
        }
    }

    private static class ViewMappingConfig {
        public List<String> viewIds = FacesConfig.access$100();
        public List<String> beanNames = FacesConfig.access$100();

        private ViewMappingConfig() {
        }
    }

    private static class ResourceBundleConfig {
        public String var;
        public String baseName;
        public String displayName;

        private ResourceBundleConfig() {
        }
    }

    private static class RendererConfig {
        public String componentFamily;
        public String rendererType;
        public String rendererClass;

        private RendererConfig() {
        }
    }

    private static class RenderKitConfig {
        public String renderKitId;
        public String renderKitClass;
        public List<RendererConfig> renderers = FacesConfig.access$100();

        private RenderKitConfig() {
        }
    }
}

