/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.config;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.application.ApplicationEvent;
import org.operamasks.faces.application.ApplicationListener;
import org.operamasks.faces.config.BootstrapFacesContext;
import org.operamasks.faces.config.FacesConfig;
import org.operamasks.faces.config.VendorConfigProcessor;
import org.operamasks.faces.util.LoggerUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FacesConfigLoader
implements ServletContextListener {
    private final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.config");
    private static final String WEB_XML_ENTRY = "/WEB-INF/web.xml";
    private static final String FACES_SERVLET = "javax.faces.webapp.FacesServlet";
    private static final String RESOURCE_SERVLET = "org.operamasks.faces.render.resource.ResourceServlet";

    public void loadFacesConfig(ServletContext context) {
        if (ApplicationAssociate.getInstance(context) != null) {
            return;
        }
        WebXmlHandler handler = new WebXmlHandler();
        this.parseWebXml(context, handler);
        String[] facesMappings = handler.getFacesMappings();
        if (facesMappings != null) {
            BootstrapFacesContext facesctx = new BootstrapFacesContext(context);
            try {
                FacesConfig config = new FacesConfig(context);
                config.load();
                ApplicationAssociate associate = ApplicationAssociate.getInstance(context);
                associate.setFacesMappings(facesMappings);
                associate.setResourceMapping(handler.getResourceMapping());
            }
            catch (Throwable ex) {
                FactoryFinder.releaseFactories();
                this.logger.warning("load config error: " + ex.getMessage());
                throw new RuntimeException(ex);
            }
            finally {
                facesctx.release();
            }
        }
    }

    public void unloadFacesConfig(ServletContext context) {
        ApplicationAssociate associate = ApplicationAssociate.getInstance(context);
        if (associate == null) {
            return;
        }
        ApplicationListener[] applicationListeners = associate.getApplicationListeners();
        if (applicationListeners != null) {
            try {
                ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                Application application = factory.getApplication();
                ApplicationEvent event = new ApplicationEvent(application, context);
                for (ApplicationListener l : applicationListeners) {
                    try {
                        l.applicationDestroyed(event);
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        FactoryFinder.releaseFactories();
        context.setAttribute(ApplicationAssociate.ASSOCIATE_KEY, null);
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        this.loadFacesConfig(context);
        this.processVendorConfig(context);
    }

    private void processVendorConfig(ServletContext context) {
        VendorConfigProcessor vendorConfigProcessor = this.getCurrentVendorConfigProcessor(context);
        if (vendorConfigProcessor != null) {
            vendorConfigProcessor.process(context);
        }
    }

    private VendorConfigProcessor getCurrentVendorConfigProcessor(ServletContext context) {
        return null;
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        this.unloadFacesConfig(context);
    }

    private void parseWebXml(ServletContext context, WebXmlHandler handler) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(context.getResourceAsStream(WEB_XML_ENTRY), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            this.logger.log(Level.WARNING, "parse web.xml fails: " + e);
        }
        catch (SAXException e) {
            this.logger.log(Level.WARNING, "parse web.xml fails: " + e);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "parse web.xml fails: " + e);
        }
    }

    private static class WebXmlHandler
    extends DefaultHandler {
        private List<String> facesServletNames = new ArrayList<String>();
        private Map<String, String> servletMappings = new HashMap<String, String>();
        private String resourceServletName = null;
        private static final int INITIAL = 0;
        private static final int SERVLET = 1;
        private static final int SERVLET_MAPPING = 2;
        private int state = 0;
        private String servletName;
        private String servletClass;
        private StringBuilder content = new StringBuilder();

        private WebXmlHandler() {
        }

        public String[] getFacesMappings() {
            if (this.facesServletNames.isEmpty()) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry<String, String> e : this.servletMappings.entrySet()) {
                String pattern = e.getKey();
                String servletName = e.getValue();
                if (!this.facesServletNames.contains(servletName)) continue;
                if (pattern.equals("/") || pattern.equals("/*")) {
                    pattern = "/";
                } else if (pattern.startsWith("/") && pattern.endsWith("/*")) {
                    pattern = pattern.substring(0, pattern.length() - 2);
                } else if (pattern.startsWith("/")) {
                    if (pattern.endsWith("/")) {
                        pattern = pattern.substring(0, pattern.length() - 1);
                    }
                } else {
                    pattern = pattern.startsWith("*.") ? pattern.substring(1) : null;
                }
                if (pattern == null || result.contains(pattern)) continue;
                result.add(pattern);
            }
            return result.toArray(new String[result.size()]);
        }

        public String getResourceMapping() {
            if (this.resourceServletName != null) {
                for (Map.Entry<String, String> e : this.servletMappings.entrySet()) {
                    String pattern = e.getKey();
                    String servletName = e.getValue();
                    if (!this.resourceServletName.equals(servletName) || !pattern.startsWith("/") || !pattern.endsWith("/*")) continue;
                    return pattern;
                }
            }
            return null;
        }

        public void startElement(String uri, String localeName, String qName, Attributes attributes) throws SAXException {
            this.content.setLength(0);
            switch (this.state) {
                case 0: {
                    if (qName.equals("servlet")) {
                        this.state = 1;
                        break;
                    }
                    if (!qName.equals("servlet-mapping")) break;
                    this.state = 2;
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    this.state = 0;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.state != 0) {
                this.content.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localeName, String qName) throws SAXException {
            switch (this.state) {
                case 1: {
                    if (qName.equals("servlet-name")) {
                        this.servletName = this.content.toString().trim();
                        break;
                    }
                    if (qName.equals("servlet-class")) {
                        this.servletClass = this.content.toString().trim();
                        break;
                    }
                    if (!qName.equals("servlet")) break;
                    if (this.servletName != null && this.servletClass != null) {
                        if (FacesConfigLoader.FACES_SERVLET.equals(this.servletClass)) {
                            this.facesServletNames.add(this.servletName);
                        } else if (FacesConfigLoader.RESOURCE_SERVLET.equals(this.servletClass)) {
                            this.resourceServletName = this.servletName;
                        }
                    }
                    this.servletClass = null;
                    this.servletName = null;
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (qName.equals("servlet-name")) {
                        this.servletName = this.content.toString().trim();
                        break;
                    }
                    if (qName.equals("url-pattern")) {
                        String pattern = this.content.toString().trim();
                        this.servletMappings.put(pattern, this.servletName);
                        break;
                    }
                    if (!qName.equals("servlet-mapping")) break;
                    this.servletName = null;
                    this.state = 0;
                }
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }
    }
}

