/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.conversation;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.application.ManagedBeanFactory;
import org.operamasks.faces.conversation.ConversationContext;
import org.operamasks.faces.conversation.ConversationContextManager;
import org.operamasks.faces.conversation.ConversationIdGenerator;
import org.operamasks.faces.util.LoggerUtil;

public class ConversationHelper {
    public static final String CONVERSATION_ID_NAME = "jconversationid";
    public static final String CONVERSATION_CONTEXT_MANAGER = "_ConersationContextManager_";
    public static final String CONVERSATION_ID_GENERATOR = "_ConversationIdGenerator_";
    private static final String QUERY_STRING_DELIMITER = "?";
    private static final String PARAMETER_PAIR_DELIMITER = "&";
    private static final String PARAMETER_ASSIGNMENT_OPERATOR = "=";
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.conversation");

    public static ConversationContextManager getCctxManager(FacesContext context) {
        Object cctxManager = context.getExternalContext().getSessionMap().get(CONVERSATION_CONTEXT_MANAGER);
        if (cctxManager != null) {
            return (ConversationContextManager)cctxManager;
        }
        return null;
    }

    public static ConversationIdGenerator getCidGenerator(FacesContext context) {
        Object cidGenerator = context.getExternalContext().getSessionMap().get(CONVERSATION_ID_GENERATOR);
        if (cidGenerator != null) {
            return (ConversationIdGenerator)cidGenerator;
        }
        return null;
    }

    public static String getCidFromRequest(FacesContext context) {
        Object cid = context.getExternalContext().getRequestParameterMap().get(CONVERSATION_ID_NAME);
        if (cid != null) {
            return cid.toString();
        }
        return null;
    }

    public static void setCurrentCid(FacesContext context, String cid) {
        context.getExternalContext().getRequestMap().put(CONVERSATION_ID_NAME, cid);
    }

    public static String getCurrentCid(FacesContext context) {
        Object cid = context.getExternalContext().getRequestMap().get(CONVERSATION_ID_NAME);
        assert (cid != null);
        return cid.toString();
    }

    public static String appendCidIfNecessary(String cid, String url) {
        int queryStringIndex = url.indexOf(QUERY_STRING_DELIMITER);
        if (queryStringIndex < 0 || url.indexOf("jconversationid=", queryStringIndex) < 0) {
            url = url + (queryStringIndex < 0 ? QUERY_STRING_DELIMITER : PARAMETER_PAIR_DELIMITER) + CONVERSATION_ID_NAME + PARAMETER_ASSIGNMENT_OPERATOR + cid;
        }
        return url;
    }

    public static ConversationContextManager getConversationContextManager(FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        ConversationContextManager cctxManager = (ConversationContextManager)sessionMap.get(CONVERSATION_CONTEXT_MANAGER);
        if (cctxManager == null) {
            cctxManager = new ConversationContextManager();
            sessionMap.put(CONVERSATION_CONTEXT_MANAGER, cctxManager);
        }
        return cctxManager;
    }

    public static ConversationContext getConversationContext(FacesContext context, String cid) {
        ConversationContext cctx = null;
        ConversationContextManager cctxManager = ConversationHelper.getCctxManager(context);
        if (cctxManager != null) {
            cctx = cctxManager.getCctxMap().get(cid);
        }
        return cctx;
    }

    public static ConversationContext getConversationContext(FacesContext context) {
        return ConversationHelper.getConversationContext(context, ConversationHelper.getCurrentCid(context));
    }

    public static String beginConversation(FacesContext context) {
        ConversationContextManager cctxManager = ConversationHelper.getConversationContextManager(context);
        String cid = ConversationHelper.getCidGenerator(context).nextId();
        cctxManager.beginOrRestoreCctx(cid);
        return cid;
    }

    public static void endConversation(FacesContext ctx, String cid) {
        ConversationContextManager cctxManager = ConversationHelper.getCctxManager(ctx);
        if (cctxManager != null) {
            Map<String, ConversationContext> cctxMap = cctxManager.getCctxMap();
            ManagedBeanContainer container = ManagedBeanContainer.getInstance(ctx);
            ConversationContext cctxt = cctxMap.get(cid);
            if (cctxt == null) {
                return;
            }
            cctxt.clearViewStateMap();
            Map<String, Object> map = cctxt.getConversationMap();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String beanName = entry.getKey();
                ConversationHelper.destroyBean(container, ManagedBeanScope.CONVERSATION, beanName, entry.getValue());
            }
            cctxMap.remove(cid);
        }
    }

    private static void destroyBean(ManagedBeanContainer container, ManagedBeanScope scope, String beanName, Object bean) {
        try {
            ManagedBeanFactory factory;
            if (container != null && (factory = container.getBeanFactory(beanName)) != null && scope == factory.getScope() && factory.isInstance(bean)) {
                factory.destroyBean(bean);
            }
        }
        catch (Throwable ex) {
            logger.log(Level.FINE, ex.getMessage(), ex);
        }
    }
}

