/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.debug;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.operamasks.faces.debug.DebugMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debug {
    private static final String KEY_DEBUG_MODE = "org.operamasks.faces.DEBUG_MODE";
    private static final String NAME_DEBUG_LOGGER = "org.operamasks.faces.Debug";
    private static final String NAME_DEBUG_RESOURCES = "org.operamasks.faces.debug.Debug_Messages";
    private static String[] COMPONENT_LIFECYCLE_METHODS = new String[]{"encodeAll", "encodeBegin", "encodeChildren", "encodeEnd", "processDecodes", "processValidators", "processUpdates", "broadcast"};
    private static String[] RENDERER_LIFECYCLE_METHODS = new String[]{"encodeBegin", "encodeChildren", "encodeEnd", "decode"};
    private static final String KEY_DEBUGLOGHANDLER_OUTPUTSTREAM = "org.operamasks.faces.DebugLogHander.outputStream";
    public static final DebugMode[] DEBUG_MODE_LIFECYCLE_PHASES;

    public static Map<DebugMode, Object> createDefaultDebugMode() {
        HashMap<DebugMode, Object> debugMode = new HashMap<DebugMode, Object>();
        debugMode.put(DebugMode.RESTORE_VIEW, false);
        debugMode.put(DebugMode.APPLY_REQUEST_VALUES, false);
        debugMode.put(DebugMode.PROCESS_VALIDATIONS, false);
        debugMode.put(DebugMode.INVOKE_APPLICATION, false);
        debugMode.put(DebugMode.RENDER_RESPONSE, false);
        debugMode.put(DebugMode.INCLUDE_COMPONENT_IDS, new String[0]);
        debugMode.put(DebugMode.EXCLUDE_COMPONENT_IDS, new String[0]);
        debugMode.put(DebugMode.INCLUDE_COMPONENT_CLASSES, new String[0]);
        debugMode.put(DebugMode.EXCLUDE_COMPONENT_CLASSES, new String[0]);
        debugMode.put(DebugMode.INCLUDE_COMPONENT_METHODS, new String[0]);
        debugMode.put(DebugMode.EXCLUDE_COMPONENT_METHODS, new String[0]);
        debugMode.put(DebugMode.INCLUDE_RENDERER_TYPES, new String[0]);
        debugMode.put(DebugMode.EXCLUDE_RENDERER_TYPES, new String[0]);
        debugMode.put(DebugMode.INCLUDE_RENDERER_METHODS, new String[0]);
        debugMode.put(DebugMode.EXCLUDE_RENDERER_METHODS, new String[0]);
        debugMode.put(DebugMode.EXCEPTION, false);
        debugMode.put(DebugMode.UNCOMPRESSED_JS, false);
        debugMode.put(DebugMode.BEAUTIFY_JS, false);
        debugMode.put(DebugMode.MISC, false);
        return debugMode;
    }

    public static boolean isEnabled(FacesContext context, DebugMode mode) {
        Object obj = Debug.getValue(mode);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return true;
    }

    public static Object getValue(FacesContext context, DebugMode mode) {
        return Debug.getDebugMode(context).get((Object)mode);
    }

    private static Map<DebugMode, Object> getDebugMode(FacesContext context) {
        Map<DebugMode, Object> debugMode = (Map<DebugMode, Object>)context.getExternalContext().getApplicationMap().get(KEY_DEBUG_MODE);
        if (debugMode == null) {
            debugMode = Debug.createDefaultDebugMode();
            context.getExternalContext().getApplicationMap().put(KEY_DEBUG_MODE, debugMode);
        }
        return debugMode;
    }

    public static boolean isEnabled(DebugMode mode) {
        return Debug.isEnabled(FacesContext.getCurrentInstance(), mode);
    }

    public static Object getValue(DebugMode mode) {
        return Debug.getValue(FacesContext.getCurrentInstance(), mode);
    }

    public static void setValue(DebugMode mode, Object value) {
        Debug.getDebugMode(FacesContext.getCurrentInstance()).put(mode, value);
    }

    public static void setValue(FacesContext context, DebugMode mode, Object value) {
        Debug.getDebugMode(context).put(mode, value);
    }

    public static Logger getLogger() {
        return Logger.getLogger(NAME_DEBUG_LOGGER);
    }

    public static String getServerLog(FacesContext context) {
        OutputStream out = (OutputStream)context.getExternalContext().getRequestMap().get(KEY_DEBUGLOGHANDLER_OUTPUTSTREAM);
        if (out != null) {
            return out.toString();
        }
        return null;
    }

    public static String getServerLog() {
        return Debug.getServerLog(FacesContext.getCurrentInstance());
    }

    public static boolean isDebugComponent(Class componentClass) {
        String componentClassName;
        if (!UIComponent.class.isAssignableFrom(componentClass)) {
            return false;
        }
        String[] includeComponentClasses = (String[])Debug.getValue(DebugMode.INCLUDE_COMPONENT_CLASSES);
        String[] excludeComponentClasses = (String[])Debug.getValue(DebugMode.EXCLUDE_COMPONENT_CLASSES);
        if (Debug.isMatch(excludeComponentClasses, componentClassName = componentClass.getName())) {
            return false;
        }
        return Debug.isMatch(includeComponentClasses, componentClassName);
    }

    private static boolean isMatch(String[] regexes, String value) {
        for (String regex : regexes) {
            if (!Pattern.matches(regex, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDebugRenderer(String rendererType) {
        String[] includeRendererTypes = (String[])Debug.getValue(DebugMode.INCLUDE_RENDERER_TYPES);
        String[] excludeRendererTypes = (String[])Debug.getValue(DebugMode.EXCLUDE_RENDERER_TYPES);
        if (Debug.isMatch(excludeRendererTypes, rendererType)) {
            return false;
        }
        return Debug.isMatch(includeRendererTypes, rendererType);
    }

    public static boolean isDebugComponentMethod(Method method, UIComponent component) {
        String[] includeComponentIds = (String[])Debug.getValue(DebugMode.INCLUDE_COMPONENT_IDS);
        String[] excludeComponentIds = (String[])Debug.getValue(DebugMode.EXCLUDE_COMPONENT_IDS);
        String[] includeComponentMethods = (String[])Debug.getValue(DebugMode.INCLUDE_COMPONENT_METHODS);
        String[] excludeComponentMethods = (String[])Debug.getValue(DebugMode.EXCLUDE_COMPONENT_METHODS);
        String methodName = method.getName();
        if (!Debug.isBelongTo(COMPONENT_LIFECYCLE_METHODS, methodName)) {
            return false;
        }
        if (Debug.isMatch(excludeComponentMethods, methodName)) {
            return false;
        }
        String componentId = Debug.getComponentId(component);
        if (Debug.isMatch(excludeComponentIds, componentId)) {
            return false;
        }
        return Debug.isMatch(includeComponentMethods, methodName) && Debug.isMatch(includeComponentIds, componentId);
    }

    private static String getComponentId(UIComponent component) {
        String componentId = "???";
        if (component instanceof UIComponentBase) {
            Class<?> componentBaseClass = component.getClass();
            while (!componentBaseClass.equals(UIComponentBase.class) && !componentBaseClass.equals(Object.class)) {
                componentBaseClass = componentBaseClass.getSuperclass();
            }
            if (componentBaseClass.equals(UIComponentBase.class)) {
                try {
                    Field idField = componentBaseClass.getDeclaredField("id");
                    idField.setAccessible(true);
                    componentId = (String)idField.get(component);
                    idField.setAccessible(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (componentId == null) {
            componentId = "???";
        }
        return componentId;
    }

    private static boolean isBelongTo(String[] valueSet, String value) {
        for (String aValue : valueSet) {
            if (!aValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDebugRendererMethod(Method method, Object[] args) {
        String[] includeComponentIds = (String[])Debug.getValue(DebugMode.INCLUDE_COMPONENT_IDS);
        String[] excludeComponentIds = (String[])Debug.getValue(DebugMode.EXCLUDE_COMPONENT_IDS);
        String[] includeRendererMethods = (String[])Debug.getValue(DebugMode.INCLUDE_RENDERER_METHODS);
        String[] excludeRendererMethods = (String[])Debug.getValue(DebugMode.EXCLUDE_RENDERER_METHODS);
        String methodName = method.getName();
        if (!Debug.isBelongTo(RENDERER_LIFECYCLE_METHODS, methodName)) {
            return false;
        }
        if (Debug.isMatch(excludeRendererMethods, methodName)) {
            return false;
        }
        UIComponent component = (UIComponent)args[1];
        String componentId = Debug.getComponentId(component);
        if (Debug.isMatch(excludeComponentIds, componentId)) {
            return false;
        }
        return Debug.isMatch(includeRendererMethods, methodName) && Debug.isMatch(includeComponentIds, componentId);
    }

    static {
        LogManager.getLogManager().addLogger(new DebugLogger(NAME_DEBUG_LOGGER, NAME_DEBUG_RESOURCES));
        DEBUG_MODE_LIFECYCLE_PHASES = new DebugMode[]{DebugMode.RESTORE_VIEW, DebugMode.APPLY_REQUEST_VALUES, DebugMode.PROCESS_VALIDATIONS, DebugMode.UPDATE_MODE_VALUES, DebugMode.INVOKE_APPLICATION, DebugMode.RENDER_RESPONSE};
    }

    private static class DebugLogHandler
    extends StreamHandler {
        private DebugLogHandler() {
        }

        public synchronized void publish(LogRecord record) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (context == null) {
                return;
            }
            OutputStream out = (OutputStream)context.getExternalContext().getRequestMap().get(Debug.KEY_DEBUGLOGHANDLER_OUTPUTSTREAM);
            if (out == null) {
                out = new ByteArrayOutputStream();
                context.getExternalContext().getRequestMap().put(Debug.KEY_DEBUGLOGHANDLER_OUTPUTSTREAM, out);
            }
            this.setOutputStream(out);
            super.publish(record);
        }
    }

    private static class DebugLogger
    extends Logger {
        protected DebugLogger(String name, String resourceBundleName) {
            super(name, resourceBundleName);
            this.addHandler(new DebugLogHandler());
        }

        public void log(LogRecord record) {
            record.setSourceClassName(Debug.NAME_DEBUG_LOGGER);
            record.setSourceMethodName(null);
            super.log(record);
        }
    }
}

