/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.developer.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateRenderer;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeEncodeHelper {
    public static void encodeLiteAttributes(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar, Set<String> candidates, Map<String, LiteAttributeEncoder> liteAttributes) throws IOException {
        for (String attr : candidates) {
            LiteAttributeEncoder encoder = liteAttributes.get(attr);
            if (encoder == null) continue;
            encoder.encode(context, component, out, jsvar);
        }
    }

    public static void encodeLiteAttributes(UIComponent component, Set<String> candidates, Map<String, LiteAttributeEncoder> liteAttributes) throws IOException {
        if (candidates.isEmpty()) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String jsvar = FacesUtils.getJsvar(context, component);
        AttributeEncodeHelper.encodeLiteAttributes(context, component, out, jsvar, candidates, liteAttributes);
    }

    public static void encodeLiteAttributes(UIComponent component, Set<String> candidates, PartialUpdateRenderer renderer) throws IOException {
        if (candidates.isEmpty()) {
            return;
        }
        Map<String, LiteAttributeEncoder> liteAttributes = renderer.getLiteAttributes();
        AttributeEncodeHelper.encodeLiteAttributes(component, candidates, liteAttributes);
    }
}

