/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.el;

import java.lang.reflect.Array;
import java.util.List;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import org.operamasks.el.eval.TypeCoercion;

public class PropertyResolverAdapter
extends PropertyResolver {
    private ELResolver elResolver;

    public PropertyResolverAdapter(ELResolver elResolver) {
        this.elResolver = elResolver;
    }

    public Object getValue(Object base, Object property) throws EvaluationException {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            return this.elResolver.getValue(context.getELContext(), base, property);
        }
        catch (javax.el.PropertyNotFoundException ex) {
            throw new PropertyNotFoundException((Throwable)ex);
        }
        catch (ELException ex) {
            throw new EvaluationException((Throwable)ex);
        }
    }

    public Object getValue(Object base, int index) throws EvaluationException {
        if (base == null) {
            return null;
        }
        if (base.getClass().isArray()) {
            try {
                return Array.get(base, index);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }
        if (base instanceof List) {
            try {
                return ((List)base).get(index);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return null;
            }
        }
        throw new PropertyNotFoundException();
    }

    public void setValue(Object base, Object property, Object value) throws EvaluationException {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            this.elResolver.setValue(context.getELContext(), base, property, value);
        }
        catch (javax.el.PropertyNotFoundException ex) {
            throw new PropertyNotFoundException((Throwable)ex);
        }
        catch (PropertyNotWritableException ex) {
            throw new PropertyNotFoundException((Throwable)ex);
        }
        catch (ELException ex) {
            throw new EvaluationException((Throwable)ex);
        }
    }

    public void setValue(Object base, int index, Object value) throws EvaluationException {
        if (base == null) {
            throw new PropertyNotFoundException();
        }
        Class<?> type = base.getClass();
        if (type.isArray()) {
            try {
                Array.set(base, index, TypeCoercion.coerce((Object)value, type.getComponentType()));
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new PropertyNotFoundException((Throwable)ex);
            }
        } else if (base instanceof List) {
            try {
                ((List)base).set(index, value);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new PropertyNotFoundException((Throwable)ex);
            }
        } else {
            throw new PropertyNotFoundException();
        }
    }

    public boolean isReadOnly(Object base, Object property) throws EvaluationException {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            return this.elResolver.isReadOnly(context.getELContext(), base, property);
        }
        catch (javax.el.PropertyNotFoundException ex) {
            throw new PropertyNotFoundException((Throwable)ex);
        }
        catch (ELException ex) {
            throw new EvaluationException((Throwable)ex);
        }
    }

    public boolean isReadOnly(Object base, int index) throws EvaluationException {
        if (base == null) {
            throw new PropertyNotFoundException();
        }
        if (base instanceof List || base.getClass().isArray()) {
            return false;
        }
        throw new PropertyNotFoundException();
    }

    public Class getType(Object base, Object property) throws EvaluationException {
        if (base == null) {
            throw new PropertyNotFoundException();
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            return this.elResolver.getType(context.getELContext(), base, property);
        }
        catch (javax.el.PropertyNotFoundException ex) {
            throw new PropertyNotFoundException((Throwable)ex);
        }
        catch (ELException ex) {
            throw new EvaluationException((Throwable)ex);
        }
    }

    public Class getType(Object base, int index) throws EvaluationException {
        if (base == null) {
            throw new PropertyNotFoundException();
        }
        if (base.getClass().isArray()) {
            int length = Array.getLength(base);
            if (index < 0 || index >= length) {
                throw new PropertyNotFoundException();
            }
            return base.getClass().getComponentType();
        }
        if (base instanceof List) {
            List list = (List)base;
            if (index < 0 || index >= list.size()) {
                throw new PropertyNotFoundException();
            }
            Object value = list.get(index);
            return value != null ? value.getClass() : Object.class;
        }
        throw new PropertyNotFoundException();
    }
}

