/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.event;

import java.util.List;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.event.ModelEvent;
import org.operamasks.faces.event.ModelEventListener;
import org.operamasks.faces.util.ConcurrentListMap;

public class EventBroadcaster {
    private static final String ALL_EVENT_TYPE = "*";
    private ConcurrentListMap<String, ModelEventListener> listeners = new ConcurrentListMap();

    public static EventBroadcaster getInstance() {
        return ApplicationAssociate.getInstance().getSingleton(EventBroadcaster.class);
    }

    private EventBroadcaster() {
    }

    public void addEventListener(String eventType, ModelEventListener listener) {
        this.listeners.putIfAbsent(eventType, listener);
    }

    public void removeEventListener(String eventType, ModelEventListener listener) {
        this.listeners.remove(eventType, listener);
    }

    public void broadcast(Object source, String eventType, Object ... params) {
        if (eventType == null || eventType.length() == 0 || eventType.equals(ALL_EVENT_TYPE)) {
            throw new IllegalArgumentException(eventType);
        }
        ModelEvent event = new ModelEvent(source, eventType, params);
        String key = eventType;
        while (true) {
            int sep;
            List<ModelEventListener> list;
            if ((list = this.listeners.list(key)) != null) {
                for (ModelEventListener listener : list) {
                    listener.processModelEvent(event);
                }
            }
            if ((sep = key.lastIndexOf(46)) != -1) {
                key = key.substring(0, sep);
                continue;
            }
            if (key.equals(ALL_EVENT_TYPE)) break;
            key = ALL_EVENT_TYPE;
        }
    }
}

