/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.event;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import org.operamasks.faces.event.RowSelectEvent;
import org.operamasks.faces.event.RowSelectListener;

public class MethodExpressionRowSelectListener
implements RowSelectListener,
StateHolder {
    private MethodExpression methodExpression;
    private boolean isTransient;

    public MethodExpressionRowSelectListener() {
    }

    public MethodExpressionRowSelectListener(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    public void processRowSelect(RowSelectEvent event) throws AbortProcessingException {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            this.methodExpression.invoke(elContext, new Object[]{event});
        }
        catch (ELException ex) {
            throw new AbortProcessingException(ex.getMessage(), ex.getCause());
        }
    }

    public Object saveState(FacesContext context) {
        return this.methodExpression;
    }

    public void restoreState(FacesContext context, Object state) {
        this.methodExpression = (MethodExpression)state;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodExpressionRowSelectListener) {
            MethodExpressionRowSelectListener other = (MethodExpressionRowSelectListener)obj;
            return this.methodExpression.equals((Object)other.methodExpression);
        }
        return false;
    }

    public int hashCode() {
        return this.methodExpression.hashCode();
    }
}

