/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.facelets;

import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.impl.DefaultFacelet;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.impl.ResourceResolver;
import com.sun.facelets.util.ParameterCheck;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.application.impl.DynamicFacesConfig;
import org.operamasks.faces.conversation.ConversationContext;
import org.operamasks.faces.facelets.DynamicFacesSAXCompiler;
import org.operamasks.faces.internal.util.DynamicFacesStrategy;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.internal.util.TemplateEngine;
import org.operamasks.faces.template.api.FactoryFinder;
import org.operamasks.faces.template.api.Template;
import org.operamasks.faces.template.api.TemplateContext;
import org.operamasks.faces.template.api.TemplateContextHandler;
import org.operamasks.faces.template.api.TemplateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicFacesFaceletFactory
extends DefaultFaceletFactory {
    private static final String DYNAMIC_FACES_REQUEST = "DYNAMIC_FACES_REQUEST";
    private static final String DYNAMIC_GENERATED_FACES_PAGES = "__DYNAMIC_GENERATED_FACES_PAGES__";

    public DynamicFacesFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L);
    }

    public DynamicFacesFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        super(compiler, resolver, refreshPeriod);
    }

    public Facelet getFacelet(String uri) throws IOException, FaceletException, FacesException, ELException {
        Facelet result = null;
        try {
            result = super.getFacelet(uri);
        }
        catch (FileNotFoundException fnfe) {
            boolean isDynamicFacesRequest = this.checkDynamicFacesRequest(uri);
            if (isDynamicFacesRequest) {
                DynamicFacesConfig dynamicFacesConfig = OMUtils.getDynamicViewMapper().mapViewId(uri);
                if (dynamicFacesConfig != null) {
                    Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
                    requestMap.put(DYNAMIC_FACES_REQUEST, Boolean.TRUE);
                    DynamicFacesStrategy strategy = dynamicFacesConfig.getStrategy();
                    if (strategy == null) {
                        strategy = DynamicFacesStrategy.REQUEST;
                    }
                    boolean keepGenerated = dynamicFacesConfig.isKeepGenerated();
                    result = this.createDynamicFacelet(uri, strategy, keepGenerated);
                }
                throw fnfe;
            }
            throw fnfe;
        }
        return result;
    }

    public Facelet getFacelet(URL url) throws IOException, FaceletException, FacesException, ELException {
        ParameterCheck.notNull((String)"url", (Object)url);
        String file = url.getFile();
        FacesContext context = FacesContext.getCurrentInstance();
        String dynamicFacesSuffix = OMUtils.getDynamicfacesDefaultSuffix(context);
        if (dynamicFacesSuffix != null && file.endsWith(dynamicFacesSuffix)) {
            String uri = "/" + file.replaceFirst(this.baseUrl.getFile(), "");
            DynamicFacesConfig dynamicFacesConfig = OMUtils.getDynamicViewMapper().mapViewId(uri);
            if (dynamicFacesConfig != null) {
                Map requestMap = context.getExternalContext().getRequestMap();
                requestMap.put(DYNAMIC_FACES_REQUEST, Boolean.TRUE);
                DynamicFacesStrategy strategy = dynamicFacesConfig.getStrategy();
                if (strategy == null) {
                    strategy = DynamicFacesStrategy.REQUEST;
                }
                boolean keepGenerated = dynamicFacesConfig.isKeepGenerated();
                DefaultFacelet result = this.createDynamicFacelet(uri, strategy, keepGenerated);
                return result;
            }
            return null;
        }
        return super.getFacelet(url);
    }

    private boolean checkDynamicFacesRequest(String uri) {
        ServletContext servletContext;
        String realPath;
        File file;
        String localUri = uri;
        if (!localUri.startsWith("/")) {
            localUri = "/" + localUri;
        }
        String dFacesPath = null;
        FacesContext context = FacesContext.getCurrentInstance();
        int periodPos = localUri.lastIndexOf(".");
        if (periodPos >= 0) {
            if (OMUtils.getDynamicfacesDefaultSuffix(context) == null) {
                return false;
            }
            dFacesPath = localUri.substring(0, periodPos) + OMUtils.getDynamicfacesDefaultSuffix(context);
        }
        return (file = new File(realPath = (servletContext = (ServletContext)context.getExternalContext().getContext()).getRealPath(dFacesPath))).exists();
    }

    private DefaultFacelet createDynamicFacelet(String uri, DynamicFacesStrategy strategy, boolean keepGenerated) throws IOException, FaceletException, FacesException, ELException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + uri);
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            byte[] dFacesContent = this.getDFacesContent(uri, strategy);
            if (dFacesContent == null) {
                Map targetMap = null;
                switch (strategy) {
                    case REQUEST: {
                        targetMap = context.getExternalContext().getRequestMap();
                        this.generateDynamicPage(uri, context, targetMap);
                        break;
                    }
                    case CONVERSATION: {
                        targetMap = ConversationContext.getCurrentInstance().getConversationMap();
                        this.generateDynamicPage(uri, context, targetMap);
                        break;
                    }
                    case SESSION: {
                        targetMap = context.getExternalContext().getSessionMap();
                        this.generateDynamicPage(uri, context, targetMap);
                        break;
                    }
                    case APPLICATION: {
                        targetMap = context.getExternalContext().getApplicationMap();
                        this.generateDynamicPage(uri, context, targetMap);
                        break;
                    }
                }
                dFacesContent = this.getDFacesContent(uri, strategy);
            }
            if (dFacesContent == null) {
                throw new FileNotFoundException();
            }
            if (keepGenerated) {
                String generatedPageFileName = null;
                switch (strategy) {
                    case REQUEST: {
                        generatedPageFileName = uri + "_" + System.currentTimeMillis();
                        break;
                    }
                    case CONVERSATION: {
                        generatedPageFileName = uri + "_cid_" + ConversationContext.getCurrentInstance().getId();
                        break;
                    }
                    case SESSION: {
                        generatedPageFileName = uri + "_sessionid_" + ((HttpSession)context.getExternalContext().getSession(false)).getId();
                        break;
                    }
                    case APPLICATION: {
                        generatedPageFileName = uri;
                        break;
                    }
                }
                if (generatedPageFileName != null) {
                    this.writeGeneratedPage(generatedPageFileName, dFacesContent);
                }
            }
            assert (this.compiler instanceof DynamicFacesSAXCompiler);
            FaceletHandler h = ((DynamicFacesSAXCompiler)this.compiler).compile(dFacesContent, uri);
            URL dynamicFacesURL = this.getDynamicFacesURL(uri);
            DefaultFacelet f = new DefaultFacelet((DefaultFaceletFactory)this, this.compiler.createExpressionFactory(), dynamicFacesURL, uri, h);
            return f;
        }
        catch (FileNotFoundException fnfe) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning(uri + " not found.");
            }
            throw new FileNotFoundException("Facelet Not Found: " + uri);
        }
    }

    public URL getDynamicFacesURL(String uri) {
        ServletContext servletContext;
        String realPath;
        File file;
        String localUri = uri;
        if (!localUri.startsWith("/")) {
            localUri = "/" + localUri;
        }
        String dFacesPath = null;
        FacesContext context = FacesContext.getCurrentInstance();
        int periodPos = localUri.lastIndexOf(".");
        if (periodPos >= 0) {
            if (OMUtils.getDynamicfacesDefaultSuffix(context) == null) {
                return null;
            }
            dFacesPath = localUri.substring(0, periodPos) + OMUtils.getDynamicfacesDefaultSuffix(context);
        }
        if ((file = new File(realPath = (servletContext = (ServletContext)context.getExternalContext().getContext()).getRealPath(dFacesPath))).exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public long getRefreshPeriod() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (Boolean.TRUE.equals(requestMap.get(DYNAMIC_FACES_REQUEST))) {
                return -1L;
            }
            return super.getRefreshPeriod();
        }
        return super.getRefreshPeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGeneratedPage(String generatedPageFileName, byte[] dFacesContent) throws IOException {
        String realPath;
        File outputFile;
        String dynamicFacesWorkingDir;
        FacesContext context = FacesContext.getCurrentInstance();
        ServletContext servletContext = (ServletContext)context.getExternalContext().getContext();
        if (!generatedPageFileName.startsWith("/")) {
            generatedPageFileName = "/" + generatedPageFileName;
        }
        if ((dynamicFacesWorkingDir = TemplateEngine.getInstance().getWorkingDir()) == null) {
            dynamicFacesWorkingDir = "/WEB-INF/working";
        }
        if (!(outputFile = new File(realPath = servletContext.getRealPath(dynamicFacesWorkingDir + generatedPageFileName))).getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            String message = "Unable to create directory " + outputFile.getParentFile();
            throw new IOException(message);
        }
        ByteArrayInputStream in = null;
        FileOutputStream out = null;
        try {
            int cout;
            in = new ByteArrayInputStream(dFacesContent);
            out = new FileOutputStream(outputFile);
            byte[] buf = new byte[1024];
            while ((cout = in.read(buf)) != -1) {
                out.write(buf, 0, cout);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDynamicPage(String uri, FacesContext context, Map<String, Object> targetMap) {
        HashMap<String, byte[]> pagesMap = null;
        pagesMap = (HashMap<String, byte[]>)targetMap.get(DYNAMIC_GENERATED_FACES_PAGES);
        if (pagesMap == null) {
            pagesMap = new HashMap<String, byte[]>();
            targetMap.put(DYNAMIC_GENERATED_FACES_PAGES, pagesMap);
        }
        byte[] pageContent = this.createFacesPage(uri, context);
        HashMap<String, byte[]> hashMap = pagesMap;
        synchronized (hashMap) {
            pagesMap.put(uri, pageContent);
        }
    }

    private byte[] createFacesPage(String alias, FacesContext context) {
        TemplateEngine templateEngine = TemplateEngine.getInstance();
        TemplateFactory fac = null;
        String templateName = templateEngine.getTemplateName();
        fac = templateName == null ? FactoryFinder.getDefaultTemplateFactory() : FactoryFinder.getTemplateFactory(templateName, templateEngine.getParams());
        ServletContext servletContext = (ServletContext)context.getExternalContext().getContext();
        fac.setTemplateHome(servletContext.getRealPath("/"));
        String dFacesPath = null;
        int periodPos = alias.lastIndexOf(".");
        if (periodPos >= 0) {
            dFacesPath = alias.substring(0, periodPos) + OMUtils.getDynamicfacesDefaultSuffix(context);
        }
        assert (dFacesPath != null);
        Template dfacesTpl = fac.getTemplate(dFacesPath);
        TemplateContext tplContext = dfacesTpl.createContext();
        DynamicFacesConfig dynamicFacesConfig = OMUtils.getDynamicViewMapper().mapViewId(alias);
        TemplateContextHandler tplContextHandler = this.getTemplateContextHandler(context, dynamicFacesConfig.getTemplateContextHandlerName());
        if (tplContextHandler != null) {
            tplContextHandler.apply(tplContext, context);
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BufferedOutputStream out = new BufferedOutputStream(bout);
            dfacesTpl.merge(tplContext, out);
            out.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private TemplateContextHandler getTemplateContextHandler(FacesContext context, String templateContextHandlerName) {
        ManagedBeanContainer managedBeanContainer = ManagedBeanContainer.getInstance();
        Object bean = managedBeanContainer.getBean(context, templateContextHandlerName);
        if (bean instanceof TemplateContextHandler) {
            return (TemplateContextHandler)bean;
        }
        return null;
    }

    private byte[] getDFacesContent(String key, DynamicFacesStrategy strategy) {
        byte[] result = null;
        ExternalContext externContext = FacesContext.getCurrentInstance().getExternalContext();
        Map pagesMap = null;
        switch (strategy) {
            case REQUEST: {
                pagesMap = (Map)externContext.getRequestMap().get(DYNAMIC_GENERATED_FACES_PAGES);
                break;
            }
            case CONVERSATION: {
                pagesMap = (Map)ConversationContext.getCurrentInstance().get(DYNAMIC_GENERATED_FACES_PAGES);
                break;
            }
            case SESSION: {
                pagesMap = (Map)externContext.getSessionMap().get(DYNAMIC_GENERATED_FACES_PAGES);
                break;
            }
            case APPLICATION: {
                pagesMap = (Map)externContext.getApplicationMap().get(DYNAMIC_GENERATED_FACES_PAGES);
                break;
            }
        }
        if (pagesMap != null) {
            result = (byte[])pagesMap.get(key);
        }
        return result;
    }
}

