/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.facelets;

import com.sun.facelets.FaceletException;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.compiler.CompilationManager;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.EncodingHandler;
import com.sun.facelets.compiler.SAXCompiler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DynamicFacesSAXCompiler
extends SAXCompiler {
    public final FaceletHandler compile(byte[] dFacesContent, String alias) throws IOException, FaceletException, ELException, FacesException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.doCompile(dFacesContent, alias);
    }

    public FaceletHandler doCompile(byte[] dFacesContent, String alias) throws IOException, FaceletException, ELException, FacesException {
        CompilationManager mngr = null;
        InputStream is = null;
        String encoding = "UTF-8";
        try {
            is = new BufferedInputStream(new ByteArrayInputStream(dFacesContent), 1024);
            mngr = new CompilationManager(alias, (Compiler)this);
            encoding = DynamicFacesSAXCompiler.writeXmlDecl((InputStream)is, (CompilationManager)mngr);
            SAXCompiler.CompilationHandler handler = new SAXCompiler.CompilationHandler(mngr, alias);
            SAXParser parser = this.createSAXParser(handler);
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(is);
            inputSource.setEncoding(encoding);
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new FaceletException("Error Parsing " + alias + ": " + e.getMessage(), e.getCause());
        }
        catch (ParserConfigurationException e) {
            throw new FaceletException("Error Configuring Parser " + alias + ": " + e.getMessage(), e.getCause());
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return new EncodingHandler(mngr.createFaceletHandler(), encoding);
    }
}

