/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.operamasks.faces.interceptor.Interceptor;
import org.operamasks.faces.interceptor.InterceptorException;
import org.operamasks.faces.interceptor.InvokeContext;

public class InterceptorUtils {
    public static Object intercept(Object target, Method method, Object[] args, Method superMethod, Interceptor interceptor) throws InterceptorException {
        InvokeContext ctx = new InvokeContext(target, method, args, superMethod);
        try {
            if (interceptor == null) {
                return ctx.invokeSuper();
            }
            interceptor.invoke(ctx);
            return ctx.getReturnValue();
        }
        catch (Throwable e) {
            Throwable ue = e;
            if (e instanceof InvocationTargetException) {
                ue = ((InvocationTargetException)e).getTargetException();
            } else if (e instanceof UndeclaredThrowableException) {
                ue = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
            }
            if (ue instanceof RuntimeException) {
                throw (RuntimeException)ue;
            }
            throw new InterceptorException(ue);
        }
    }
}

