/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.util.LoggerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFileUtils {
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.config");

    private LoadFileUtils() {
    }

    public static ClassLoader getClassLoader() {
        ApplicationAssociate associate = ApplicationAssociate.getInstance();
        if (associate != null) {
            return associate.getClassLoader();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getConfigClassesInstance(Class<? extends T> t, InputStream configStream, ClassLoader cl) {
        ArrayList result = new ArrayList();
        BufferedReader reader = null;
        try {
            String name;
            reader = new BufferedReader(new InputStreamReader(configStream));
            while ((name = reader.readLine()) != null) {
                if ((name = name.trim()).length() == 0) continue;
                Class<?> clazz = cl.loadClass(name);
                Object item = clazz.newInstance();
                result.add(item);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "read config file fails: " + e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "load class fails: " + e);
        }
        catch (InstantiationException e) {
            logger.log(Level.WARNING, "instantiation fails: " + e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "illegal access: " + e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "close stream fails: " + e);
                }
            }
        }
        return result;
    }
}

