/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.internal.util;

import elite.lang.Closure;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.FunctionMapperImpl;
import org.operamasks.el.eval.MethodExpressionImpl;
import org.operamasks.el.eval.StackTrace;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Parser;
import org.operamasks.faces.annotation.LocalString;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.application.impl.ComponentViewState;
import org.operamasks.faces.application.impl.DefaultDynamicViewMapper;
import org.operamasks.faces.application.impl.DynamicViewMapper;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.AjaxActionStub;
import org.operamasks.faces.internal.stub.event.AjaxActionEventStub;
import org.operamasks.faces.internal.util.ViewStateStrategy;
import org.operamasks.faces.render.ajax.AjaxRenderKitImpl;
import org.operamasks.faces.util.DeepCloneManager;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMUtils {
    public static final String AJAX_ACTION_EL_FLAG = "";
    public static final String CURRENT_PHASE_ID = "org.operamasks.faces.CURRENT_PHASE_ID";
    public static final String RENDER_ID_PARAM = "org.operamasks.faces.RenderId";
    public static final String AJAX_RENDER_KIT = "AJAX";
    public static final String AJAX_SUB_RENDER_KIT = ":AJAX";
    public static final String ORIGINAL_VIEW_ID = "org.operamasks.faces.ORIGINAL_VIEW_ID";
    private static final String AJAX_REQUEST_HEADER = "X-Requested-By";
    private static final String AJAX_REQUEST_VALUE = "XMLHttpRequest";
    public static final String FAVAX_DFACES_DEFAULT_SUFFIX = "javax.dfaces.DEFAULT_SUFFIX";
    public static final String DEFAULT_TEMPLATE_ENGINE_WORKING_DIR = "/WEB-INF/working";
    public static final String KEY_ORIGINAL_VIEW_STATE_MAPS = "__KEY_ORIGINAL_VIEW_STATE_MAPS__";
    public static final String KEY_VIEW_STATE_STRATEGY = "org.operamasks.faces.VIEW_STATE_STRATEGY";
    public static final String VIEW_ROOT_ID = "___viewroot___";
    public static final String AJAX_ACTION_LIST = "org.operamasks.AjaxActionList";
    private static boolean strict = Boolean.getBoolean("apusic.strict");
    private static final String[] EMPTY_ELEMENTS = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};

    private OMUtils() {
    }

    public static Locale getLocaleFromString(String localeExpr) {
        Locale result = Locale.getDefault();
        if (localeExpr.indexOf("_") == -1 && localeExpr.indexOf("-") == -1) {
            if (localeExpr.length() == 2) {
                result = new Locale(localeExpr, AJAX_ACTION_EL_FLAG);
            }
        } else if (localeExpr.length() == 5) {
            String language = localeExpr.substring(0, 2);
            String country = localeExpr.substring(3, 5);
            result = new Locale(language, country);
        }
        return result;
    }

    public static Locale getLocaleFromExpression(FacesContext context, ValueExpression expr) throws FacesException {
        if (expr.isLiteralText()) {
            return OMUtils.getLocaleFromString(expr.getExpressionString());
        }
        try {
            Object value = expr.getValue(context.getELContext());
            if (value == null || value.equals(AJAX_ACTION_EL_FLAG)) {
                return null;
            }
            if (value instanceof Locale) {
                return (Locale)value;
            }
            if (value instanceof String) {
                return OMUtils.getLocaleFromString((String)value);
            }
            throw new FacesException(Resources._T("JSF_LOCALE_TYPE_EXPECTED", expr.getExpressionString()));
        }
        catch (ELException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    public static UIComponent cloneComponent(UIComponent source, boolean deep) {
        if (deep) {
            if (source == null) {
                return null;
            }
            FacesContext context = FacesContext.getCurrentInstance();
            DeepCloneManager componentCloneManager = new DeepCloneManager();
            return componentCloneManager.deepCloneComponent(context, source);
        }
        if (source == null) {
            return null;
        }
        UIComponent newOne = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            newOne = (UIComponent)source.getClass().newInstance();
            newOne.restoreState(context, source.saveState(context));
        }
        catch (Exception ex) {
            throw new FacesException(Resources._T("JSF_CREATE_COMPONENT_ERROR", source.getClass()), (Throwable)ex);
        }
        return newOne;
    }

    public static UIComponent cloneComponent(UIComponent source) {
        return OMUtils.cloneComponent(source, false);
    }

    public static final String getRequestRenderId(FacesContext context) {
        String renderId = null;
        if (AjaxRenderKitImpl.isAjaxResponse(context) && (renderId = (String)context.getExternalContext().getRequestParameterMap().get(RENDER_ID_PARAM)) != null && renderId.length() == 0) {
            renderId = null;
        }
        return renderId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodExpression resolveMethodExpression(AjaxActionEventStub ajaxEvent) {
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        AjaxActionStub ajaxAction = (AjaxActionStub)ajaxEvent.getComponent();
        String expression = ajaxAction.getActionExpression().getExpressionString();
        FunctionMapper fm = ajaxAction.getFunctionMapper();
        VariableMapper vm = ajaxAction.getVariableMapper();
        Object obj = null;
        elContext.putContext(AjaxActionEventStub.class, ajaxEvent.getClass());
        try {
            obj = OMUtils.evaluateExpression(elContext, fm, vm, expression);
        }
        finally {
            elContext.putContext(AjaxActionEventStub.class, (Object)AJAX_ACTION_EL_FLAG);
        }
        Class returnType = null;
        Class<?>[] parameterTypes = null;
        if (obj instanceof Method) {
            returnType = ((Method)obj).getReturnType();
            parameterTypes = ((Method)obj).getParameterTypes();
        } else if (obj instanceof Closure) {
            returnType = ((Closure)obj).getMethodInfo(elContext).getReturnType();
            parameterTypes = ((Closure)obj).getMethodInfo(elContext).getParamTypes();
        }
        if (parameterTypes != null) {
            return OMUtils.createMethodExpression(fm, vm, expression, returnType, parameterTypes);
        }
        return null;
    }

    private static MethodExpression createMethodExpression(FunctionMapper fm, VariableMapper vm, String expression, Class<?> expectedType, Class<?>[] expectedParamTypes) {
        if (expectedParamTypes == null) {
            expectedParamTypes = new Class[]{};
        }
        ELNode node = Parser.parse((String)expression);
        return new MethodExpressionImpl(expression, node, expectedType, (Class[])expectedParamTypes, fm, vm);
    }

    public static FunctionMapper buildFunctionMapper(ELNode node, FunctionMapper fm) {
        if (node == null || fm == null) {
            return null;
        }
        FunctionMapperBuilder fmb = new FunctionMapperBuilder(fm);
        node.applyFunctionMapper((FunctionMapper)fmb);
        return fmb.build();
    }

    public static VariableMapper buildVariableMapper(ELNode node, VariableMapper vm) {
        if (node == null || vm == null) {
            return null;
        }
        VariableMapperBuilder vmb = new VariableMapperBuilder(vm);
        node.applyVariableMapper((VariableMapper)vmb);
        return vmb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object evaluateExpression(ELContext elctx, FunctionMapper fm, VariableMapper vm, String expression) {
        ELNode node = Parser.parse((String)expression);
        StackTrace.addFrame((ELContext)elctx, (String)"__eval__", null, (int)0);
        try {
            EvaluationContext env = new EvaluationContext(elctx, fm, vm);
            Object object = node.getValue(env);
            return object;
        }
        finally {
            StackTrace.removeFrame((ELContext)elctx);
        }
    }

    public static String getFieldValueString(UIComponent comp, String fieldName) throws NoSuchFieldException {
        Field f = null;
        Class<?> clz = comp.getClass();
        while (clz.getSuperclass() != null) {
            try {
                f = clz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException ex) {
                clz = clz.getSuperclass();
            }
        }
        Object value = null;
        if (f != null) {
            f.setAccessible(true);
            try {
                value = f.get(comp);
            }
            catch (IllegalAccessException ex) {
                throw new FacesException((Throwable)ex);
            }
            if (value == null) {
                FacesContext ctxt = FacesContext.getCurrentInstance();
                ValueExpression ve = comp.getValueExpression(fieldName);
                if (ve != null) {
                    try {
                        value = ve.getValue(ctxt.getELContext());
                    }
                    catch (ELException e) {
                        throw new FacesException((Throwable)e);
                    }
                }
            }
        } else {
            throw new NoSuchFieldException();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static PhaseId getCurrentPhaseId(FacesContext context) {
        PhaseId phaseId = (PhaseId)context.getExternalContext().getRequestMap().get(CURRENT_PHASE_ID);
        return phaseId == null ? PhaseId.ANY_PHASE : phaseId;
    }

    public static boolean strict() {
        return strict;
    }

    public static boolean isMixedValueExpression(String expression) {
        if (expression == null) {
            return false;
        }
        if (expression.startsWith("#{") && expression.endsWith("}")) {
            return false;
        }
        return FacesUtils.isValueExpression(expression);
    }

    public static String toCamelCase(String str) {
        StringBuilder buf = new StringBuilder(str.length() * 2);
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i == 0) {
                c = Character.toUpperCase(c);
                buf.append(c);
                continue;
            }
            if (Character.isUpperCase(c)) {
                buf.append(' ');
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String getLocalString(Class<?> declaringClass, String basename, String key, Locale locale) {
        String msgtext;
        ResourceBundle bundle = OMUtils.getLocalStringBundle(declaringClass, basename, locale);
        if (bundle == null) {
            return null;
        }
        String classname = declaringClass.getName();
        try {
            msgtext = bundle.getString(classname + "." + key);
        }
        catch (MissingResourceException ex) {
            try {
                msgtext = bundle.getString(classname.substring(classname.lastIndexOf(46) + 1) + "." + key);
            }
            catch (MissingResourceException ex2) {
                try {
                    msgtext = bundle.getString(key);
                }
                catch (MissingResourceException ex3) {
                    return null;
                }
            }
        }
        if (msgtext != null && msgtext.startsWith("%") && msgtext.endsWith("%")) {
            try {
                String ref = msgtext.substring(1, msgtext.length() - 1);
                msgtext = bundle.getString(ref);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return msgtext;
    }

    public static String getLocalString(Class<?> declaringClass, String key) {
        return OMUtils.getLocalString(declaringClass, null, key, FacesUtils.getCurrentLocale());
    }

    public static String getLocalString(Class<?> declaringClass, String basename, String key) {
        return OMUtils.getLocalString(declaringClass, basename, key, FacesUtils.getCurrentLocale());
    }

    public static ResourceBundle getLocalStringBundle(Class<?> declaringClass, String basename, Locale locale) {
        if (basename == null || basename.length() == 0) {
            LocalString meta = declaringClass.getAnnotation(LocalString.class);
            if (meta != null && meta.basename().length() != 0) {
                basename = meta.basename();
            } else {
                String classname = declaringClass.getName();
                basename = classname.substring(0, classname.lastIndexOf(46) + 1) + "LocalStrings";
            }
        }
        try {
            ClassLoader loader = declaringClass.getClassLoader();
            if (loader != null) {
                return ResourceBundle.getBundle(basename, locale, loader);
            }
            return ResourceBundle.getBundle(basename, locale);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public static ResourceBundle getLocalStringBundle(Class<?> declaringClass) {
        return OMUtils.getLocalStringBundle(declaringClass, null, FacesUtils.getCurrentLocale());
    }

    public static ClassLoader getCurrentLoader(Class<?> fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClassLoader();
        }
        return loader;
    }

    public static boolean isAjaxResponse(FacesContext context) {
        String renderKitId = context.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            return false;
        }
        if (!AJAX_RENDER_KIT.equals(renderKitId) && !renderKitId.endsWith(AJAX_SUB_RENDER_KIT)) {
            return false;
        }
        Object requestObj = context.getExternalContext().getRequest();
        if (!(requestObj instanceof HttpServletRequest)) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)requestObj;
        String header = request.getHeader(AJAX_REQUEST_HEADER);
        if (!AJAX_REQUEST_VALUE.equals(header)) {
            return false;
        }
        String originalViewId = (String)request.getAttribute(ORIGINAL_VIEW_ID);
        String currentViewId = context.getViewRoot().getViewId();
        return originalViewId == null || currentViewId.equals(originalViewId);
    }

    public static boolean isEmptyElement(String name) {
        return Arrays.binarySearch(EMPTY_ELEMENTS, name.toLowerCase()) >= 0;
    }

    public static String getActionURL(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        return context.getExternalContext().encodeActionURL(url);
    }

    public static String getDynamicfacesDefaultSuffix(FacesContext context) {
        ServletContext servletContext = (ServletContext)context.getExternalContext().getContext();
        return servletContext.getInitParameter(FAVAX_DFACES_DEFAULT_SUFFIX);
    }

    public static DynamicViewMapper getDynamicViewMapper() {
        return DefaultDynamicViewMapper.getInstance();
    }

    public static void updateValueBindings(FacesContext context, UIComponent root) {
        Iterator<UIComponent> it = FacesUtils.createFacetsAndChildrenIterator(root, true);
        while (it.hasNext()) {
            UIComponent component = it.next();
            ValueExpression binding = component.getValueExpression("binding");
            if (binding == null) continue;
            binding.setValue(context.getELContext(), (Object)component);
        }
    }

    public static int parseViewStateStrategy(String str) {
        if (str == null) {
            ServletContext sctx = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            if (ViewStateStrategy.DELTA.toString().equalsIgnoreCase(sctx.getInitParameter(KEY_VIEW_STATE_STRATEGY))) {
                return ViewStateStrategy.DELTA.ordinal();
            }
            return ViewStateStrategy.FULL.ordinal();
        }
        if (ViewStateStrategy.DELTA.toString().equalsIgnoreCase(str)) {
            return ViewStateStrategy.DELTA.ordinal();
        }
        return ViewStateStrategy.FULL.ordinal();
    }

    public static boolean isDeltaViewState(FacesContext context) {
        String str = (String)context.getExternalContext().getRequestMap().get(KEY_VIEW_STATE_STRATEGY);
        return ViewStateStrategy.DELTA.ordinal() == OMUtils.parseViewStateStrategy(str);
    }

    public static boolean isObjectEquals(Object originalObj, Object newObj) {
        if (originalObj == null && newObj == null) {
            return true;
        }
        if (originalObj == null || newObj == null) {
            return false;
        }
        if (!originalObj.getClass().equals(newObj.getClass())) {
            return false;
        }
        if (originalObj instanceof Object[]) {
            Object[] originalArray = (Object[])originalObj;
            Object[] newArray = (Object[])newObj;
            if (originalArray.length != newArray.length) {
                return false;
            }
            int len = originalArray.length;
            for (int i = 0; i < len; ++i) {
                Object origValue = originalArray[i];
                Object newValue = newArray[i];
                boolean result = OMUtils.isObjectEquals(origValue, newValue);
                if (result) continue;
                return false;
            }
        } else {
            boolean result = originalObj.equals(newObj);
            if (!result) {
                return false;
            }
        }
        return true;
    }

    public static Map<String, Map<String, ComponentViewState>> getOrigViewStateMaps(FacesContext context) {
        ApplicationAssociate appAssociate = ApplicationAssociate.getInstance(context);
        Map result = (ConcurrentHashMap)appAssociate.getAttribute(KEY_ORIGINAL_VIEW_STATE_MAPS);
        if (result == null) {
            ConcurrentHashMap newMap = new ConcurrentHashMap();
            result = appAssociate.getAttributes().putIfAbsent(KEY_ORIGINAL_VIEW_STATE_MAPS, newMap);
            if (result == null) {
                result = newMap;
            }
        }
        return result;
    }

    private static class VariableMapperBuilder
    extends VariableMapper {
        private VariableMapper source;
        private VariableMapper target;

        VariableMapperBuilder(VariableMapper source) {
            this.source = source;
        }

        public ValueExpression resolveVariable(String name) {
            ValueExpression value = this.source.resolveVariable(name);
            if (value != null) {
                if (this.target == null) {
                    this.target = new VariableMapperImpl();
                }
                this.target.setVariable(name, value);
            }
            return value;
        }

        public ValueExpression setVariable(String name, ValueExpression value) {
            throw new IllegalStateException();
        }

        public VariableMapper build() {
            return this.target;
        }
    }

    private static class FunctionMapperBuilder
    extends FunctionMapper {
        private FunctionMapper source;
        private FunctionMapperImpl target;

        FunctionMapperBuilder(FunctionMapper source) {
            this.source = source;
        }

        public Method resolveFunction(String prefix, String localName) {
            Method m = this.source.resolveFunction(prefix, localName);
            if (m != null) {
                if (this.target == null) {
                    this.target = new FunctionMapperImpl();
                }
                this.target.addFunction(prefix, localName, m);
            }
            return m;
        }

        public FunctionMapper build() {
            return this.target;
        }
    }
}

