/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.operamasks.faces.layout.Facelet;
import org.operamasks.faces.layout.LayoutManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutContext {
    private static final String LAYOUT_CONTEXT_STACK_ATTR = "org.operamasks.faces.layout.LAYOUT_CONTEXT_STACK";
    private LayoutContext parent;
    private LayoutManager layout;

    public static LayoutContext getCurrentInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context == null ? null : LayoutContext.getCurrentInstance(context);
    }

    public static LayoutContext getCurrentInstance(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        List stack = (List)requestMap.get(LAYOUT_CONTEXT_STACK_ATTR);
        if (stack != null && !stack.isEmpty()) {
            return (LayoutContext)stack.get(stack.size() - 1);
        }
        return null;
    }

    public static void pushLayoutContext(FacesContext context, LayoutManager layout) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ArrayList<LayoutContext> stack = (ArrayList<LayoutContext>)requestMap.get(LAYOUT_CONTEXT_STACK_ATTR);
        if (stack == null) {
            stack = new ArrayList<LayoutContext>();
            requestMap.put(LAYOUT_CONTEXT_STACK_ATTR, stack);
        }
        LayoutContext parent = null;
        if (!stack.isEmpty()) {
            parent = (LayoutContext)stack.get(stack.size() - 1);
        }
        stack.add(new LayoutContext(parent, layout));
    }

    public static void popLayoutContext(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        List stack = (List)requestMap.get(LAYOUT_CONTEXT_STACK_ATTR);
        if (stack != null) {
            stack.remove(stack.size() - 1);
            if (stack.isEmpty()) {
                requestMap.remove(LAYOUT_CONTEXT_STACK_ATTR);
            }
        }
    }

    private LayoutContext(LayoutContext parent, LayoutManager layout) {
        this.parent = parent;
        this.layout = layout;
    }

    public LayoutContext getParent() {
        return this.parent;
    }

    public LayoutManager getLayoutManager() {
        return this.layout;
    }

    public int getFaceletCount() {
        return this.layout.getFacelets().size();
    }

    public Facelet[] getFacelets() {
        List<Facelet> facelets = this.layout.getFacelets();
        Facelet[] result = new Facelet[facelets.size()];
        return facelets.toArray(result);
    }

    public Map<String, Facelet> getFacelet() {
        HashMap<String, Facelet> result = new HashMap<String, Facelet>();
        for (Facelet facelet : this.layout.getFacelets()) {
            String name = facelet.getName();
            if (name == null || result.containsKey(name)) continue;
            result.put(name, facelet);
        }
        return result;
    }

    public Map<String, Object> getAttributes() {
        return this.layout.getAttributes();
    }
}

