/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.lifecycle;

import java.beans.Beans;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.operamasks.faces.annotation.AfterPhase;
import org.operamasks.faces.annotation.BeforePhase;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseListenerAdapter
implements PhaseListener {
    private Object delegate;
    private List<Method> beforePhaseMethods = new LinkedList<Method>();
    private List<Method> afterPhaseMethods = new LinkedList<Method>();
    private boolean isImpl = false;
    private Class<?> delegateClass;
    protected static final Logger log = LoggerUtil.getLogger("org.operamasks.faces.lifecycle");

    public PhaseListenerAdapter(Class<?> delegateClass) {
        this.delegateClass = delegateClass;
        if (PhaseListener.class.isAssignableFrom(delegateClass)) {
            this.isImpl = true;
        } else {
            this.scan(delegateClass);
        }
    }

    private void scan(Class<?> listenerClass) {
        Class<?> clz = listenerClass;
        while (clz.getSuperclass() != null) {
            Method[] methods;
            for (Method m : methods = clz.getDeclaredMethods()) {
                AfterPhase a;
                BeforePhase p = m.getAnnotation(BeforePhase.class);
                if (p != null) {
                    m.setAccessible(true);
                    this.beforePhaseMethods.add(m);
                }
                if ((a = m.getAnnotation(AfterPhase.class)) == null) continue;
                m.setAccessible(true);
                this.afterPhaseMethods.add(m);
            }
            clz = clz.getSuperclass();
        }
    }

    private void createDelegateInstance() {
        ApplicationAssociate assoc = ApplicationAssociate.getInstance();
        try {
            this.delegate = Beans.instantiate(assoc.getClassLoader(), this.delegateClass.getName());
        }
        catch (Exception e) {
            throw new FacesException(Resources._T("JSF_INSTANTIATION_ERROR", this.delegateClass.getName()), (Throwable)e);
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (this.delegate == null) {
            this.createDelegateInstance();
        }
        if (this.isImpl) {
            PhaseListener listener = (PhaseListener)this.delegate;
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.delegate.getClass().getName() + ".afterPhase() called.");
            }
            listener.afterPhase(event);
        } else {
            for (Method m : this.afterPhaseMethods) {
                try {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(this.delegate.getClass().getName() + "." + m.getName() + "(...) called.");
                    }
                    m.invoke(this.delegate, event);
                }
                catch (Exception e) {
                    throw new FacesException("invoke phase listener error", (Throwable)e);
                }
            }
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (this.delegate == null) {
            this.createDelegateInstance();
        }
        if (this.isImpl) {
            PhaseListener listener = (PhaseListener)this.delegate;
            listener.beforePhase(event);
        } else {
            for (Method m : this.beforePhaseMethods) {
                try {
                    m.invoke(this.delegate, event);
                }
                catch (Exception e) {
                    throw new FacesException("invoke phase listener error", (Throwable)e);
                }
            }
        }
    }

    public PhaseId getPhaseId() {
        if (this.delegate == null) {
            this.createDelegateInstance();
        }
        if (this.isImpl) {
            PhaseListener listener = (PhaseListener)this.delegate;
            return listener.getPhaseId();
        }
        return PhaseId.ANY_PHASE;
    }
}

