/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.IOException;
import java.io.Writer;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.util.HtmlEncoder;

public class AjaxHtmlResponseWriter
extends HtmlResponseWriter {
    private AjaxResponseWriter outer;
    private boolean viewStateChanged;
    private boolean writeFullState;
    private Map<String, String> requestParams;

    AjaxHtmlResponseWriter(Writer writer, String contentType, String encoding) {
        super(writer, contentType, encoding);
        if (!FacesUtils.isTransientStateSupported(FacesContext.getCurrentInstance())) {
            this.writeFullState = true;
        }
    }

    AjaxHtmlResponseWriter(Writer writer, AjaxResponseWriter outer) {
        super(writer, outer.getContentType(), outer.getCharacterEncoding());
        this.outer = outer;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new AjaxHtmlResponseWriter(writer, this.getContentType(), this.getCharacterEncoding());
    }

    public void setViewStateChanged() {
        if (this.outer != null) {
            this.outer.setViewStateChanged();
        } else {
            this.viewStateChanged = true;
            if (!this.writeFullState && !FacesUtils.isMarkedForTransientState(FacesContext.getCurrentInstance())) {
                this.writeFullState = true;
            }
        }
    }

    public void setViewStateChanged(boolean writeFullState) {
        if (this.outer != null) {
            this.outer.setViewStateChanged(writeFullState);
        } else {
            this.viewStateChanged = true;
            if (writeFullState) {
                this.writeFullState = true;
            }
        }
    }

    public boolean isViewStateChanged() {
        return this.viewStateChanged;
    }

    public boolean isWriteFullState() {
        return this.writeFullState;
    }

    public void addRequestParameter(String key, String value) {
        if (this.outer != null) {
            this.outer.addRequestParameter(key, value);
        } else if (key != null && value != null) {
            if (this.requestParams == null) {
                this.requestParams = new LinkedHashMap<String, String>();
            }
            this.requestParams.put(key, value);
            this.setViewStateChanged(false);
        }
    }

    public void writeState(FacesContext context) throws IOException {
        if (this.viewStateChanged) {
            String script;
            String[] state = FacesUtils.getViewState(context);
            Formatter fmt = new Formatter();
            fmt.format("OM.ajax.actionId=%s;\n", HtmlEncoder.enquote(OMUtils.getActionURL(context)));
            if (!this.writeFullState) {
                fmt.format("OM.ajax.viewId='%s';\n", context.getViewRoot().getViewId());
            }
            if (state[0] != null) {
                fmt.format("OM.ajax.viewState='%s';\n", state[0]);
            }
            if (state[1] != null) {
                fmt.format("OM.ajax.renderKitId='%s';\n", state[1]);
            }
            if (this.requestParams != null) {
                for (String key : this.requestParams.keySet()) {
                    String value = this.requestParams.get(key);
                    fmt.format("OM.ajax.addRequestParameter(%s,%s);\n", HtmlEncoder.enquote(key), HtmlEncoder.enquote(value));
                }
            }
            if ((script = fmt.toString()).length() > 0) {
                this.out.write("<script type=\"text/javascript\">\n");
                this.out.write(script);
                this.out.write("</script>\n");
            }
        }
    }
}

