/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.operamasks.faces.developer.ajax.FormUpdatable;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.PartialUpdateRenderer;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.user.ajax.PartialUpdateFilter;
import org.operamasks.faces.user.ajax.UpdateLevel;
import org.operamasks.faces.util.Repainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxUpdateMarker {
    private Map<UpdateLevel, Set<UIComponent>> updateStore;
    private Map<UpdateLevel, Set<UIComponent>> recursiveUpdateStore;
    private Map<UpdateLevel, Set<String>> idStore;
    private Map<UpdateLevel, Set<String>> recursiveIdStore;
    private boolean organized = false;
    private Map<UIComponent, Set<String>> compAttrMap;
    private Map<String, Set<String>> idAttrMap;
    private Map<UIComponent, PartialUpdateFilter> compFilterMap;
    private Map<String, PartialUpdateFilter> idFilterMap;
    private UpdateLevel defaultLevel = UpdateLevel.Data;
    private static final String PAGE_UPDATELEVEL_KEY = "org.operamasks.faces.PAGE_UPDATELEVEL";

    public UpdateLevel getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(UpdateLevel defaultLevel) {
        this.defaultLevel = defaultLevel;
    }

    public AjaxUpdateMarker() {
        this.updateStore = new HashMap<UpdateLevel, Set<UIComponent>>();
        this.recursiveUpdateStore = new HashMap<UpdateLevel, Set<UIComponent>>();
        this.idStore = new HashMap<UpdateLevel, Set<String>>();
        this.recursiveIdStore = new HashMap<UpdateLevel, Set<String>>();
        this.compAttrMap = new HashMap<UIComponent, Set<String>>();
        this.idAttrMap = new HashMap<String, Set<String>>();
        this.compFilterMap = new HashMap<UIComponent, PartialUpdateFilter>();
        this.idFilterMap = new HashMap<String, PartialUpdateFilter>();
    }

    private Set<UIComponent> getUpdateSet(UpdateLevel level) {
        Set<UIComponent> markedSet = this.updateStore.get((Object)level);
        if (markedSet == null) {
            markedSet = new HashSet<UIComponent>();
            this.updateStore.put(level, markedSet);
        }
        return markedSet;
    }

    private Set<UIComponent> getRecursiveUpdateSet(UpdateLevel level) {
        Set<UIComponent> markedSet = this.recursiveUpdateStore.get((Object)level);
        if (markedSet == null) {
            markedSet = new HashSet<UIComponent>();
            this.recursiveUpdateStore.put(level, markedSet);
        }
        return markedSet;
    }

    private Set<String> getIdSet(UpdateLevel level) {
        Set<String> markedSet = this.idStore.get((Object)level);
        if (markedSet == null) {
            markedSet = new HashSet<String>();
            this.idStore.put(level, markedSet);
        }
        return markedSet;
    }

    private Set<String> getRecursiveIdSet(UpdateLevel level) {
        Set<String> markedSet = this.recursiveIdStore.get((Object)level);
        if (markedSet == null) {
            markedSet = new HashSet<String>();
            this.recursiveIdStore.put(level, markedSet);
        }
        return markedSet;
    }

    private Set<String> getAttributeSet(UIComponent key) {
        Set<String> attr = this.compAttrMap.get(key);
        if (attr == null) {
            attr = new HashSet<String>();
            this.compAttrMap.put(key, attr);
        }
        return attr;
    }

    private Set<String> getAttributeSet(String key) {
        Set<String> attr = this.idAttrMap.get(key);
        if (attr == null) {
            attr = new HashSet<String>();
            this.idAttrMap.put(key, attr);
        }
        return attr;
    }

    public void markUpdate(String ... ids) {
        this.cleanIdList(false, this.defaultLevel, ids);
        this.getIdSet(this.defaultLevel).addAll((Collection<String>)Arrays.asList(ids));
    }

    public void markUpdate(UpdateLevel level, String ... ids) {
        this.cleanIdList(false, level, ids);
        this.getIdSet(level).addAll((Collection<String>)Arrays.asList(ids));
    }

    public void markUpdate(boolean recursive, UpdateLevel level, String ... ids) {
        if (recursive) {
            this.cleanIdList(true, level, ids);
            this.getRecursiveIdSet(level).addAll((Collection<String>)Arrays.asList(ids));
        } else {
            this.markUpdate(level, ids);
        }
    }

    public void markUpdate(UIComponent ... components) {
        List<UIComponent> list = Arrays.asList(components);
        this.cleanCompList(false, this.defaultLevel, list);
        this.getUpdateSet(this.defaultLevel).addAll(list);
    }

    public void markUpdate(UpdateLevel level, UIComponent ... components) {
        List<UIComponent> list = Arrays.asList(components);
        this.cleanCompList(false, level, list);
        this.getUpdateSet(level).addAll(list);
    }

    public void markUpdate(boolean recursive, UpdateLevel level, UIComponent ... components) {
        if (recursive) {
            List<UIComponent> list = Arrays.asList(components);
            this.cleanCompList(true, level, list);
            this.getRecursiveUpdateSet(level).addAll(list);
        } else {
            this.markUpdate(level, components);
        }
    }

    public void markUpdate(Collection<UIComponent> components) {
        this.cleanCompList(false, this.defaultLevel, components);
        this.getUpdateSet(this.defaultLevel).addAll(components);
    }

    public void markUpdate(UpdateLevel level, Collection<UIComponent> components) {
        this.cleanCompList(false, level, components);
        this.getUpdateSet(level).addAll(components);
    }

    public void markUpdate(boolean recursive, UpdateLevel level, Collection<UIComponent> components) {
        if (recursive) {
            this.cleanCompList(true, level, components);
            this.getRecursiveUpdateSet(level).addAll(components);
        } else {
            this.markUpdate(level, components);
        }
    }

    public void markUpdate(PartialUpdateFilter filter, UpdateLevel level, String ... ids) {
        this.markUpdate(true, level, ids);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.idFilterMap.put(id, filter);
            ++n2;
        }
    }

    public void markUpdate(PartialUpdateFilter filter, UpdateLevel level, UIComponent ... components) {
        this.markUpdate(true, level, components);
        UIComponent[] uIComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            UIComponent c = uIComponentArray[n2];
            this.compFilterMap.put(c, filter);
            ++n2;
        }
    }

    public void markUpdate(PartialUpdateFilter filter, UpdateLevel level, Collection<UIComponent> components) {
        this.markUpdate(true, level, components);
        for (UIComponent c : components) {
            this.compFilterMap.put(c, filter);
        }
    }

    public void markAttributeUpdate(String id, String ... attribute) {
        this.getAttributeSet(id).addAll((Collection<String>)Arrays.asList(attribute));
    }

    public void markAttributeUpdate(UIComponent component, String ... attributes) {
        this.getAttributeSet(component).addAll((Collection<String>)Arrays.asList(attributes));
    }

    public boolean isLevelMatch(UIComponent component, UpdateLevel level) {
        return this.getUpdateSet(level).contains(component);
    }

    public boolean isSkipped(UIComponent component) {
        return this.getUpdateSet(UpdateLevel.Skip).contains(component);
    }

    public boolean isUpdateValue(UIComponent component) {
        return true;
    }

    public boolean isUpdateDataModel(UIComponent component) {
        UpdateLevel level = this.getUpdateLevel(component);
        return level == UpdateLevel.Data || level == UpdateLevel.Lite;
    }

    public UpdateLevel getUpdateLevel(UIComponent component) {
        if (this.isLevelMatch(component, UpdateLevel.Skip)) {
            return UpdateLevel.Skip;
        }
        if (this.isLevelMatch(component, UpdateLevel.ForceRepain)) {
            return UpdateLevel.ForceRepain;
        }
        if (this.isLevelMatch(component, UpdateLevel.Lite)) {
            return UpdateLevel.Lite;
        }
        if (this.isLevelMatch(component, UpdateLevel.Data)) {
            return UpdateLevel.Data;
        }
        if (this.isLevelMatch(component, UpdateLevel.ValueOnly)) {
            return UpdateLevel.ValueOnly;
        }
        return UpdateLevel.Specified;
    }

    public Set<String> getSpecifiedAttributes(UIComponent component) {
        assert (this.organized);
        HashSet<String> attr = new HashSet<String>();
        Set<String> add = this.compAttrMap.get(component);
        if (add != null) {
            attr.addAll(add);
        }
        return attr;
    }

    public void organize(FacesContext context) {
        String pageLvl = context.getExternalContext().getInitParameter(PAGE_UPDATELEVEL_KEY);
        if (pageLvl != null && pageLvl.trim().length() > 0) {
            pageLvl = pageLvl.trim();
            UpdateLevel level = PartialUpdateCandidates.decodeLevel(pageLvl);
            this.markUpdate(new PartialUpdateFilter(){

                public boolean isMatch(UIComponent component) {
                    return component instanceof UIOutput || component instanceof FormUpdatable;
                }
            }, level, new UIComponent[]{context.getViewRoot()});
        }
        this.organized = true;
        this.organizeId(context);
        this.processRecursive(context);
        this.markRepaint(context);
    }

    public boolean isOrganized() {
        return this.organized;
    }

    private void markRepaint(FacesContext context) {
        for (Map.Entry<UIComponent, Set<String>> entry : this.compAttrMap.entrySet()) {
            UIComponent c = entry.getKey();
            Set<String> attributes = this.getSpecifiedAttributes(c);
            PartialUpdateRenderer renderer = AjaxUpdateMarker.getParticialRenderer(c);
            if (renderer == null) continue;
            for (String attr : attributes) {
                if ("value".equalsIgnoreCase(attr) || renderer.getLiteAttributes().keySet().contains(attr) || renderer.getUnupdatableAttributes().contains(attr)) continue;
                this.markUpdate(UpdateLevel.ForceRepain, c);
            }
        }
        Set<UIComponent> repaintSet = this.getUpdateSet(UpdateLevel.ForceRepain);
        for (UIComponent c : repaintSet) {
            UIComponent parent = c.getParent();
            while (parent != null && !repaintSet.contains(parent)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                repaintSet.remove(c);
                continue;
            }
            PartialUpdateRenderer r = AjaxUpdateMarker.getParticialRenderer(c);
            if (!r.isRepaintable(c)) continue;
            Repainter.markForRepaint(c);
        }
    }

    public static PartialUpdateRenderer getParticialRenderer(UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        Renderer renderer = FacesUtils.getRenderer(context, component);
        if (renderer != null && renderer instanceof PartialUpdateRenderer) {
            return (PartialUpdateRenderer)renderer;
        }
        return null;
    }

    private void organizeId(FacesContext context) {
        Iterator<UIComponent> it = FacesUtils.createFacetsAndChildrenIterator((UIComponent)context.getViewRoot(), true);
        while (it.hasNext()) {
            UIComponent c = it.next();
            UpdateLevel[] updateLevelArray = UpdateLevel.values();
            int n = updateLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                UpdateLevel level = updateLevelArray[n2];
                String id = c.getId();
                if (this.getIdSet(level).contains(id)) {
                    this.getUpdateSet(level).add(c);
                }
                if (this.getRecursiveIdSet(level).contains(id)) {
                    this.getRecursiveUpdateSet(level).add(c);
                }
                if (this.idAttrMap.keySet().contains(id)) {
                    this.getAttributeSet(c).addAll((Collection<String>)this.idAttrMap.get(id));
                }
                if (this.idFilterMap.keySet().contains(id)) {
                    this.compFilterMap.put(c, this.idFilterMap.get(id));
                }
                ++n2;
            }
        }
        this.idStore = null;
        this.recursiveIdStore = null;
        this.idAttrMap = null;
        this.idFilterMap = null;
    }

    private void processRecursive(FacesContext context) {
        UpdateLevel[] updateLevelArray = UpdateLevel.values();
        int n = updateLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            UpdateLevel level = updateLevelArray[n2];
            Set<UIComponent> recursive = this.getRecursiveUpdateSet(level);
            Set<UIComponent> target = this.getUpdateSet(level);
            for (UIComponent parent : recursive) {
                PartialUpdateFilter filter = this.compFilterMap.get(parent);
                Iterator<UIComponent> it = FacesUtils.createFacetsAndChildrenIterator(parent, true);
                while (it.hasNext()) {
                    Renderer r;
                    UIComponent c = it.next();
                    if (filter != null && !filter.isMatch(c) || !((r = FacesUtils.getRenderer(context, c)) instanceof PartialUpdateRenderer)) continue;
                    target.add(c);
                }
            }
            ++n2;
        }
        this.recursiveUpdateStore = null;
    }

    private void cleanIdList(boolean recursive, UpdateLevel level, String ... ids) {
        List<String> idList = Arrays.asList(ids);
        UpdateLevel[] updateLevelArray = UpdateLevel.values();
        int n = updateLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            UpdateLevel l = updateLevelArray[n2];
            if (l != level) {
                if (recursive) {
                    this.getRecursiveIdSet(l).removeAll(idList);
                } else {
                    this.getIdSet(l).removeAll(idList);
                }
            }
            ++n2;
        }
    }

    private void cleanCompList(boolean recursive, UpdateLevel level, Collection<UIComponent> components) {
        UpdateLevel[] updateLevelArray = UpdateLevel.values();
        int n = updateLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            UpdateLevel l = updateLevelArray[n2];
            if (l != level) {
                if (recursive) {
                    this.getRecursiveUpdateSet(l).removeAll(components);
                } else {
                    this.getUpdateSet(l).removeAll(components);
                }
            }
            ++n2;
        }
    }
}

