/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.container;

import java.util.ArrayList;
import java.util.Formatter;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.container.ToolBarItemRenderer;
import org.operamasks.faces.render.resource.ResourceManager;

public class ContainerRenderUtils {
    public static boolean isItem(UIComponent component) {
        return ContainerRenderUtils.getRenderer(component) instanceof ToolBarItemRenderer;
    }

    public static UIComponent[] getItems(UIComponent container) {
        ArrayList<UIComponent> items = new ArrayList<UIComponent>();
        for (UIComponent c : container.getChildren()) {
            if (!ContainerRenderUtils.isItem(c)) continue;
            items.add(c);
        }
        return items.toArray(new UIComponent[items.size()]);
    }

    public static UIComponent[] encodeItemInitScript(FacesContext context, UIComponent container, Formatter fmt) {
        ResourceManager rm = ResourceManager.getInstance(context);
        ArrayList<UIComponent> items = new ArrayList<UIComponent>();
        for (UIComponent item : container.getChildren()) {
            Object renderer;
            if (!item.isRendered() || !((renderer = ContainerRenderUtils.getRenderer(context, item)) instanceof ToolBarItemRenderer)) continue;
            ToolBarItemRenderer itemRenderer = (ToolBarItemRenderer)renderer;
            items.add(item);
            if (itemRenderer.ignoreChildren()) {
                fmt.format(itemRenderer.getToolBarItemInitScript(context, item, container), new Object[0]);
                rm.setIgnoreChildren(item, true);
            } else {
                fmt.format(itemRenderer.getToolBarItemInitScript(context, item, container), new Object[0]);
            }
            item.getAttributes().remove("isNew");
        }
        return items.toArray(new UIComponent[items.size()]);
    }

    public static void ignoreItems(FacesContext context, UIComponent container) {
        ResourceManager rm = ResourceManager.getInstance(context);
        for (UIComponent item : container.getChildren()) {
            ToolBarItemRenderer itemRenderer;
            Object renderer = ContainerRenderUtils.getRenderer(context, item);
            if (!(renderer instanceof ToolBarItemRenderer) || !(itemRenderer = (ToolBarItemRenderer)renderer).ignoreChildren()) continue;
            rm.setIgnoreChildren(item, true);
        }
    }

    public static String getItemAddScript(FacesContext context, UIComponent container, String jsvar) {
        StringBuilder itemScript = new StringBuilder();
        for (UIComponent item : container.getChildren()) {
            Object renderer;
            if (!item.isRendered() || !((renderer = ContainerRenderUtils.getRenderer(context, item)) instanceof ToolBarItemRenderer)) continue;
            ToolBarItemRenderer itemRenderer = (ToolBarItemRenderer)renderer;
            itemScript.append(itemRenderer.getToolBarItemAddScript(context, item, jsvar));
        }
        return itemScript.toString();
    }

    public static String encodeAjaxAddItemScript(FacesContext context, UIComponent container, UIComponent child) {
        Object renderer;
        if (child.isRendered() && (renderer = ContainerRenderUtils.getRenderer(context, child)) instanceof ToolBarItemRenderer) {
            ToolBarItemRenderer itemRenderer = (ToolBarItemRenderer)renderer;
            StringBuilder buf = new StringBuilder();
            buf.append(itemRenderer.getToolBarItemInitScript(context, child, container));
            if (itemRenderer.ignoreChildren()) {
                buf.append(itemRenderer.getToolBarItemAddScript(context, child, FacesUtils.getJsvar(context, container)));
                ResourceManager.getInstance(context).setIgnoreChildren(child, true);
            } else {
                buf.append(itemRenderer.getToolBarItemAddScript(context, child, FacesUtils.getJsvar(context, container)));
            }
            return buf.toString();
        }
        return "";
    }

    public static Object getRenderer(FacesContext context, UIComponent component) {
        Renderer renderer = null;
        renderer = FacesUtils.getRenderer(context, component);
        return renderer;
    }

    public static Object getRenderer(UIComponent component) {
        return ContainerRenderUtils.getRenderer(FacesContext.getCurrentInstance(), component);
    }
}

