/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.delegate;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.operamasks.faces.internal.util.LoadFileUtils;
import org.operamasks.faces.render.delegate.ViewDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewDelegateManager {
    private static final String VIEW_DELEGATE_KEY = "org.operamasks.faces.VIEW_DELEGATE";
    private static final String VIEW_DELEGATE_CONFIG_FILE = "META-INF/view_delegate.cfg";
    List<ViewDelegate> delegates = new ArrayList<ViewDelegate>();

    public static ViewDelegateManager getInstance(FacesContext context) {
        return ViewDelegateManager.getInstance(context, true);
    }

    public static ViewDelegateManager getInstance(FacesContext context, boolean create) {
        ExternalContext ext = context.getExternalContext();
        Map appMap = ext.getApplicationMap();
        ViewDelegateManager manager = (ViewDelegateManager)appMap.get(VIEW_DELEGATE_KEY);
        if (manager == null && create) {
            manager = new ViewDelegateManager();
            manager.init();
            appMap.put(VIEW_DELEGATE_KEY, manager);
        }
        return manager;
    }

    private ViewDelegateManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ClassLoader cl = LoadFileUtils.getClassLoader();
        ArrayList<URL> configUrls = new ArrayList<URL>();
        InputStream configStream = null;
        try {
            Enumeration<URL> urls = cl.getResources(VIEW_DELEGATE_CONFIG_FILE);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                configUrls.add(url);
            }
            for (URL url : configUrls) {
                configStream = url.openStream();
                this.delegates.addAll(LoadFileUtils.getConfigClassesInstance(ViewDelegate.class, configStream, cl));
                if (configStream == null) continue;
                configStream.close();
            }
        }
        catch (IOException e) {
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void registerViewDelegate(ViewDelegate delegate) {
        this.delegates.add(delegate);
    }

    public void unregisterViewDelegate(ViewDelegate delegate) {
        this.delegates.remove(delegate);
    }

    public void processViewDelegates(FacesContext context) throws IOException {
        for (ViewDelegate delegate : this.delegates) {
            delegate.delegate(context);
            if (!context.getResponseComplete()) continue;
            return;
        }
    }

    public List<ViewDelegate> getViewDelegates() {
        return this.delegates;
    }
}

