/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.UIOutputRenderer;

public class LinkRenderer
extends UIOutputRenderer {
    protected Object getValue(UIComponent component) {
        return ((UIOutput)component).getValue();
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (RendererUtils.isDisabled(component)) {
            this.renderDisabledLink(context, component);
        } else {
            this.renderActiveLink(context, component);
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        if (RendererUtils.isDisabled(component)) {
            out.endElement("span");
        } else {
            out.endElement("a");
        }
    }

    private void renderActiveLink(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("a", component);
        String id = component.getId();
        if (id != null && !id.startsWith("j_id")) {
            id = component.getClientId(context);
            out.writeAttribute("id", (Object)id, "clientId");
            out.writeAttribute("name", (Object)id, "clientId");
        }
        String url = this.getUrl(context, component);
        String type = (String)component.getAttributes().get("type");
        if (url != null) {
            out.writeURIAttribute("href", (Object)url, "value");
        }
        if (type != null) {
            out.writeAttribute("type", (Object)type, "type");
        }
        RendererUtils.renderPassThruAttributes(out, component);
    }

    private String getUrl(FacesContext context, UIComponent component) {
        StringBuffer buf = new StringBuffer();
        String value = this.getCurrentValue(context, component);
        if (value != null) {
            buf.append(value);
        }
        boolean q = value == null || value.indexOf(63) == -1;
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)kid;
            buf.append(q ? (char)'?' : '&');
            buf.append(param.getName());
            buf.append('=');
            buf.append(param.getValue());
            q = false;
        }
        if (buf.length() == 0) {
            return null;
        }
        String url = context.getApplication().getViewHandler().getResourceURL(context, buf.toString());
        return context.getExternalContext().encodeResourceURL(url);
    }

    private void renderDisabledLink(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("span", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        RendererUtils.renderPassThruAttributes(out, component, "disabled");
    }
}

