/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ResourceRenderer;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.Resource;
import org.operamasks.faces.render.resource.SkinDescriptor;
import org.operamasks.faces.render.resource.SkinManager;
import org.operamasks.faces.tools.annotation.Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceManager {
    private static final String RESOURCE_MANAGER_PARAM = "org.operamasks.faces.RESOURCE_MANAGER";
    static final String VIEW_ID_PREFIX = "/_global";
    static final String RESOURCE_VIEW_ID = "/_global/resource";
    static final String SKIN_VIEW_ID = "/_global/resource/ext/skin";
    static final String LOCAL_RESOURCE_BASE = "META-INF/resource";
    private ApplicationAssociate associate;
    private Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    private boolean beginEncoded;
    private Map<UIComponent, Boolean> ignoreChildren = new HashMap<UIComponent, Boolean>();

    public static ResourceManager getInstance(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ResourceManager manager = (ResourceManager)requestMap.get(RESOURCE_MANAGER_PARAM);
        if (manager == null) {
            manager = new ResourceManager(context);
            requestMap.put(RESOURCE_MANAGER_PARAM, manager);
        }
        return manager;
    }

    private ResourceManager(FacesContext context) {
    }

    public void registerResource(Resource resource) {
        String id = resource.getId();
        if (!this.resources.containsKey(id)) {
            this.resources.put(id, resource);
            if (this.beginEncoded) {
                try {
                    resource.encodeBegin(FacesContext.getCurrentInstance());
                }
                catch (IOException ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
        }
    }

    public boolean isResourceRegistered(String id) {
        return this.resources.containsKey(id);
    }

    public Resource getRegisteredResource(String id) {
        return this.resources.get(id);
    }

    public String getResourceURL(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        String mapping = this.getResourceMapping(RESOURCE_VIEW_ID);
        if (!path.startsWith("/")) {
            mapping = mapping.concat("/");
        }
        return mapping.concat(path);
    }

    public String getResourceURL(String path, Locale locale) {
        String url = this.getResourceURL(path);
        if (locale != null) {
            url = url + "?" + locale;
        }
        return url;
    }

    public String getServiceResourceURL(String serviceName, String path) {
        if (serviceName == null) {
            throw new NullPointerException();
        }
        String viewId = VIEW_ID_PREFIX;
        if (!serviceName.startsWith("/")) {
            viewId = viewId + "/";
        }
        if ((viewId = viewId + serviceName).endsWith("/")) {
            viewId = viewId.substring(0, viewId.length() - 1);
        }
        String mapping = this.getResourceMapping(viewId);
        if (path != null && path.length() != 0) {
            if (!path.startsWith("/")) {
                mapping = mapping + "/";
            }
            mapping = mapping + path;
        }
        return mapping;
    }

    public String getSkinResourceURL(String skin, String path) {
        if (skin == null || path == null) {
            throw new NullPointerException();
        }
        if (skin.indexOf(47) != -1) {
            throw new IllegalArgumentException("Invalid skin name: " + skin);
        }
        String mapping = this.getResourceMapping(SKIN_VIEW_ID);
        StringBuilder buf = new StringBuilder();
        buf.append(mapping);
        buf.append("/");
        buf.append(skin);
        if (!path.startsWith("/")) {
            buf.append("/");
        }
        buf.append(path);
        return buf.toString();
    }

    public String getSkinResourceLocation(SkinDescriptor skinDescriptor) {
        if (skinDescriptor == null) {
            throw new NullPointerException();
        }
        String file = skinDescriptor.getFile();
        StringBuilder buf = new StringBuilder();
        buf.append(file);
        return buf.toString();
    }

    public String getSkinResourceURL(String skin, String path, Locale locale) {
        String url = this.getSkinResourceURL(skin, path);
        if (locale != null) {
            url = url + "?" + locale;
        }
        return url;
    }

    public String getSkinResourceURL(String path) {
        FacesContext context = FacesContext.getCurrentInstance();
        String skin = SkinManager.getCurrentSkin(context);
        return this.getSkinResourceURL(skin, path);
    }

    public String getSkinResourceURL(String path, Locale locale) {
        String url = this.getSkinResourceURL(path);
        if (locale != null) {
            url = url + "?" + locale;
        }
        return url;
    }

    public URL getLocalResource(String url) throws FileNotFoundException {
        return this.getLocalResource(url, null);
    }

    public URL getLocalResource(String uri, String locale) throws FileNotFoundException {
        ClassLoader cl = this.getClassLoader();
        int pos = uri.indexOf(SKIN_VIEW_ID);
        if (pos != -1) {
            int skinStartPos = uri.indexOf(47, pos + SKIN_VIEW_ID.length()) + 1;
            int skinEndPos = uri.indexOf("/", skinStartPos);
            if ((pos = uri.indexOf(47, pos + RESOURCE_VIEW_ID.length())) == -1 || pos == uri.length() - 1) {
                return null;
            }
            String resUri = uri.substring(pos);
            String path = LOCAL_RESOURCE_BASE.concat(resUri);
            URL resource = null;
            resource = cl.getResource(path);
            if (resource == null) {
                pos = uri.indexOf(SKIN_VIEW_ID);
                pos = (uri = uri.substring(0, skinStartPos) + "default" + uri.substring(skinEndPos)).indexOf(47, pos + RESOURCE_VIEW_ID.length());
                if (pos == -1 || pos == uri.length() - 1) {
                    return null;
                }
                resUri = uri.substring(pos);
                path = LOCAL_RESOURCE_BASE.concat(resUri);
                resource = cl.getResource(path);
            }
            if (resource == null) {
                throw new FileNotFoundException(resUri);
            }
            return resource;
        }
        pos = uri.indexOf(RESOURCE_VIEW_ID);
        if (pos != -1) {
            String localPath;
            String suffix;
            String prefix;
            if ((pos = uri.indexOf(47, pos + RESOURCE_VIEW_ID.length())) == -1 || pos == uri.length() - 1) {
                return null;
            }
            String path = LOCAL_RESOURCE_BASE.concat(uri.substring(pos));
            URL resource = null;
            String resoureName = "";
            String debugSuffix = "";
            if (locale != null && locale.length() != 0) {
                int dot = path.indexOf(46);
                if (dot == -1) {
                    prefix = path;
                    suffix = "";
                } else {
                    prefix = path.substring(0, dot);
                    suffix = path.substring(dot);
                }
                dot = prefix.indexOf("-debug");
                if (dot == -1) {
                    resoureName = prefix;
                    debugSuffix = "";
                } else {
                    resoureName = prefix.substring(0, dot);
                    debugSuffix = "-debug";
                }
                localPath = resoureName + "-" + locale + debugSuffix + suffix;
            } else {
                locale = null;
                suffix = null;
                prefix = null;
                localPath = path;
            }
            while (true) {
                if (resource == null) {
                    resource = cl.getResource(localPath);
                }
                if (resource != null || locale == null) break;
                int sep = locale.lastIndexOf("_");
                if (sep != -1) {
                    locale = locale.substring(0, sep);
                    localPath = resoureName + "-" + locale + debugSuffix + suffix;
                    continue;
                }
                locale = null;
                localPath = path;
            }
            if (resource == null) {
                throw new FileNotFoundException(path);
            }
            return resource;
        }
        return null;
    }

    public void consumeResourceRegister(FacesContext context, UIComponent component) {
        if (!this.isComponentRendered(component)) {
            return;
        }
        Renderer renderer = FacesUtils.getRenderer(context, component);
        if (renderer != null && renderer instanceof ResourceRenderer) {
            ResourceRenderer r = (ResourceRenderer)renderer;
            ComponentResource.registerJS(this, r.getDependedJSPackages(context, component));
            ComponentResource.registerCSS(this, r.getDependedCSSPackages(context, component));
        }
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            this.consumeResourceRegister(context, kid);
        }
    }

    public void consumeContainerResources(FacesContext context, UIComponent component) {
        this.consumeResources(context, component, true);
    }

    public void consumeResources(FacesContext context, UIComponent component) {
        this.consumeResources(context, component, false);
    }

    public void consumeResources(FacesContext context, UIComponent component, boolean isContainer) {
        if (!this.isComponentRendered(component)) {
            return;
        }
        boolean isResourceMeta = false;
        if (this.isContainer(component) == isContainer) {
            boolean isResourceRenderer = false;
            Renderer renderer = FacesUtils.getRenderer(context, component);
            if (renderer instanceof ResourceRenderer) {
                isResourceRenderer = true;
                this.consumeResourcesRenderer(context, component, isContainer);
            }
            if (isResourceRenderer) {
                return;
            }
        }
        if (isResourceMeta) {
            return;
        }
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            Boolean ignore = this.ignoreChildren.get(child);
            if (ignore != null && ignore.booleanValue()) continue;
            this.consumeResources(context, child, isContainer);
        }
    }

    private void innerConsumeInitScriptBegin(FacesContext context, UIComponent component) {
        Renderer renderer = FacesUtils.getRenderer(context, component);
        if (renderer instanceof ResourceRenderer) {
            try {
                ((ResourceRenderer)renderer).encodeInitScriptBegin(context, this, component);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            if (((ResourceRenderer)renderer).getEncodeResourceChildren(component)) {
                return;
            }
        }
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            Boolean ignore = this.ignoreChildren.get(child);
            if (!child.isRendered() || Boolean.FALSE.equals(ignore)) continue;
            this.innerConsumeInitScriptBegin(context, child);
        }
    }

    private void innerConsumeInitScriptEnd(FacesContext context, UIComponent component) {
        Renderer renderer = FacesUtils.getRenderer(context, component);
        if (renderer instanceof ResourceRenderer) {
            try {
                ((ResourceRenderer)renderer).encodeInitScriptEnd(context, this, component);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            if (((ResourceRenderer)renderer).getEncodeResourceChildren(component)) {
                return;
            }
        }
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            Boolean ignore = this.ignoreChildren.get(child);
            if (ignore != null && ignore.booleanValue() || !child.isRendered()) continue;
            this.innerConsumeInitScriptEnd(context, child);
        }
    }

    public void consumeInitScriptBegin(FacesContext context, UIComponent component) {
        this.innerConsumeInitScriptBegin(context, component);
    }

    public void consumeInitScriptEnd(FacesContext context, UIComponent component) {
        this.innerConsumeInitScriptEnd(context, component);
    }

    public void consumeResourcesRenderer(FacesContext context, UIComponent component, boolean isContainer) {
        boolean shouldExec;
        if (!this.isComponentRendered(component)) {
            return;
        }
        ResourceRenderer r = this.getResourceRenderer(context, component);
        boolean bl = shouldExec = this.isContainer(component) == isContainer;
        if (r != null && shouldExec) {
            try {
                r.encodeResourceBegin(context, this, component);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
        if (r != null && !r.getEncodeResourceChildren(component)) {
            if (shouldExec) {
                try {
                    r.encodeResourceChildren(context, this, component, isContainer);
                }
                catch (IOException e) {
                    throw new FacesException((Throwable)e);
                }
            }
        } else {
            Iterator kids = component.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent child = (UIComponent)kids.next();
                Boolean ignore = this.ignoreChildren.get(child);
                if (ignore != null && ignore.booleanValue()) continue;
                this.consumeResources(context, child, isContainer);
            }
        }
        if (r != null && shouldExec) {
            try {
                r.encodeResourceEnd(context, this, component);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    private ResourceRenderer getResourceRenderer(FacesContext context, UIComponent component) {
        ResourceRenderer r = null;
        if (component instanceof ResourceRenderer) {
            r = (ResourceRenderer)component;
        } else {
            Renderer renderer = FacesUtils.getRenderer(context, component);
            if (renderer instanceof ResourceRenderer) {
                r = (ResourceRenderer)renderer;
            }
        }
        return r;
    }

    private boolean isComponentRendered(UIComponent component) {
        boolean rendered = false;
        try {
            rendered = component.isRendered();
        }
        catch (Exception e) {
            rendered = false;
        }
        return rendered;
    }

    private boolean isContainer(UIComponent component) {
        return component.getClass().getAnnotation(Container.class) != null;
    }

    public void setIgnoreChildren(UIComponent component, boolean ignore) {
        this.ignoreChildren.put(component, ignore);
    }

    public Map<UIComponent, Boolean> getIgnoreChildren() {
        return this.ignoreChildren;
    }

    public void removeIgnoreChildren(UIComponent component) {
        this.ignoreChildren.remove(component);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.beginEncoded = true;
        for (Resource res : this.getResources()) {
            res.encodeBegin(context);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        for (Resource res : this.getResources()) {
            res.encodeEnd(context);
        }
    }

    public String getLoadScript(FacesContext context) {
        StringBuilder buf = new StringBuilder();
        for (Resource res : this.getResources()) {
            String script = res.getLoadScript(context);
            if (script == null || script.length() == 0) continue;
            buf.append(script);
            if (script.endsWith(";")) continue;
            buf.append(";");
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    public String getUnloadScript(FacesContext context) {
        StringBuilder buf = new StringBuilder();
        for (Resource res : this.getResources()) {
            String script = res.getUnloadScript(context);
            if (script == null || script.length() == 0) continue;
            buf.append(script);
            if (script.endsWith(";")) continue;
            buf.append(";");
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    public void reset() {
        this.beginEncoded = false;
        this.resources.clear();
    }

    private String getResourceMapping(String viewId) {
        String mapping;
        FacesContext context = FacesContext.getCurrentInstance();
        ViewHandler vh = context.getApplication().getViewHandler();
        ApplicationAssociate associate = this.getAssociate(context);
        if (associate != null && (mapping = associate.getResourceMapping()) != null) {
            assert (mapping.startsWith("/") && !mapping.endsWith("/"));
            mapping = mapping.equals(VIEW_ID_PREFIX) ? viewId : (mapping.endsWith(VIEW_ID_PREFIX) ? mapping + viewId.substring(VIEW_ID_PREFIX.length()) : mapping + viewId);
            return vh.getResourceURL(context, mapping);
        }
        return vh.getActionURL(context, viewId);
    }

    private List<Resource> getResources() {
        ArrayList<Resource> result = new ArrayList<Resource>(this.resources.values());
        Collections.sort(result, new Comparator<Resource>(){

            @Override
            public int compare(Resource r1, Resource r2) {
                return r1.getPriority() - r2.getPriority();
            }
        });
        return result;
    }

    private ApplicationAssociate getAssociate(FacesContext context) {
        if (this.associate == null) {
            this.associate = ApplicationAssociate.getInstance(context);
        }
        return this.associate;
    }

    private ClassLoader getClassLoader() {
        FacesContext context = FacesContext.getCurrentInstance();
        ApplicationAssociate associate = this.getAssociate(context);
        if (associate != null) {
            return associate.getClassLoader();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }
}

