/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.resource;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourcePackages {
    private ResourcePackages() {
    }

    private static Package parsePackage(Element el) {
        Package pkg = new Package();
        pkg.name = el.getAttribute("name");
        pkg.url = el.getAttribute("file");
        NodeList requiresList = el.getElementsByTagName("requires");
        pkg.requires = new String[requiresList.getLength()];
        for (int i = 0; i < pkg.requires.length; ++i) {
            Element node = (Element)requiresList.item(i);
            pkg.requires[i] = node.getAttribute("name");
        }
        return pkg;
    }

    public static Map<String, String[]> buildJS(Map<String, Package> jsDeps) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Package pkg : jsDeps.values()) {
            ArrayList<String> urls = new ArrayList<String>();
            ResourcePackages.buildDepends(pkg, urls, "js", jsDeps, null);
            result.put(pkg.name, urls.toArray(new String[urls.size()]));
        }
        return result;
    }

    public static Map<String, String[]> buildCSS(Map<String, Package> cssDeps) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Package pkg : cssDeps.values()) {
            ArrayList<String> urls = new ArrayList<String>();
            ResourcePackages.buildDepends(pkg, urls, "css", null, cssDeps);
            result.put(pkg.name, urls.toArray(new String[urls.size()]));
        }
        return result;
    }

    private static void buildDepends(Package pkg, List<String> urls, String type, Map<String, Package> jsDeps, Map<String, Package> cssDeps) {
        for (String requires : pkg.requires) {
            Package requiredPkg = null;
            if ("js".equals(type)) {
                requiredPkg = jsDeps.get(requires);
            } else if ("css".equals(type)) {
                requiredPkg = cssDeps.get(requires);
            }
            if (requiredPkg == null) {
                throw new IllegalStateException("Unknow required package: " + requires);
            }
            ResourcePackages.buildDepends(requiredPkg, urls, type, jsDeps, cssDeps);
        }
        if (pkg.url != null && pkg.url.length() != 0 && !urls.contains(pkg.url)) {
            urls.add(pkg.url);
        }
    }

    public static void load(InputStream inputStream, Map<String, Package> jsDeps, Map<String, Package> cssDeps) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(false);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(inputStream);
        Element root = doc.getDocumentElement();
        NodeList nodeList = root.getElementsByTagName("packages");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Package pkg;
            int j;
            NodeList packageNodeList;
            Element packagesEle = (Element)nodeList.item(i);
            if ("js".equals(packagesEle.getAttribute("type"))) {
                packageNodeList = packagesEle.getElementsByTagName("package");
                for (j = 0; j < packageNodeList.getLength(); ++j) {
                    pkg = ResourcePackages.parsePackage((Element)packageNodeList.item(j));
                    jsDeps.put(pkg.name, pkg);
                }
                continue;
            }
            if (!"css".equals(packagesEle.getAttribute("type"))) continue;
            packageNodeList = packagesEle.getElementsByTagName("package");
            for (j = 0; j < packageNodeList.getLength(); ++j) {
                pkg = ResourcePackages.parsePackage((Element)packageNodeList.item(j));
                cssDeps.put(pkg.name, pkg);
            }
        }
    }

    public static class Package {
        String name;
        String url;
        String[] requires;
    }
}

