/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.template.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.operamasks.faces.template.api.TemplateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryFinder {
    private static Map<TemplateName, TemplateFactory> factories = new HashMap<TemplateName, TemplateFactory>();
    private static Map<TemplateName, String> factoryClassNames = new HashMap<TemplateName, String>();

    public static TemplateFactory getTemplateFactory(String templateName, Map<String, String> templateParams) {
        TemplateFactory result = factories.get((Object)TemplateName.valueOf(templateName));
        if (result == null) {
            try {
                String factoryClassName = factoryClassNames.get((Object)TemplateName.valueOf(templateName));
                Class<?> factoryCls = Class.forName(factoryClassName);
                result = (TemplateFactory)factoryCls.newInstance();
                if (result != null) {
                    factories.put(TemplateName.valueOf(templateName), result);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        result.init(templateParams);
        return result;
    }

    public static TemplateFactory getDefaultTemplateFactory() {
        return FactoryFinder.getTemplateFactory("jsp", Collections.EMPTY_MAP);
    }

    static {
        factoryClassNames.put(TemplateName.jsp, "org.operamasks.faces.template.impl.jsp.JspTemplateFactory");
        factoryClassNames.put(TemplateName.smart4j, "org.operamasks.faces.template.impl.smarty4j.SmartTemplateFactory");
        factoryClassNames.put(TemplateName.freeMarker, "org.operamasks.faces.template.impl.freemarker.FreeMarkerTemplateFactory");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TemplateName {
        jsp,
        smart4j,
        freeMarker;

    }
}

