/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtils {
    private static Random randGenerator = new Random(System.nanoTime());

    public static <T> T[] push(T[] target, T[] data) {
        Class<?> clazz = target.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(clazz, target.length + data.length);
        System.arraycopy(target, 0, result, 0, target.length);
        System.arraycopy(data, 0, result, target.length, data.length);
        return result;
    }

    public static <T> T[] push(T[] target, T data) {
        return (Object[])ArrayUtils.push(target, new Object[]{data});
    }

    public static <T> String join(T[] target, String join) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (T obj : target) {
            buf.append(obj);
            if (i < target.length - 1) {
                buf.append(join);
            }
            ++i;
        }
        return buf.toString();
    }

    public static <T> T[] clone(T[] target) {
        Class<?> clazz = target.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(clazz, target.length);
        System.arraycopy(target, 0, result, 0, target.length);
        return result;
    }

    public static <T> T[] randomPeek(T[] target, int len) {
        if (len > target.length) {
            len = target.length;
        }
        int sourceLen = target.length;
        HashSet<Integer> indexesSet = new HashSet<Integer>();
        while (indexesSet.size() < len) {
            indexesSet.add(randGenerator.nextInt(sourceLen));
        }
        Integer[] indexes = indexesSet.toArray(new Integer[len]);
        Class<?> clazz = target.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(clazz, len);
        for (int i = 0; i < len; ++i) {
            result[i] = target[indexes[i]];
        }
        return result;
    }
}

