/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentListMap<K, V> {
    private ConcurrentMap<K, CopyOnWriteArrayList<V>> map = new ConcurrentHashMap<K, CopyOnWriteArrayList<V>>();

    public void put(K key, V value) {
        this.addList(key).add(value);
    }

    public void putIfAbsent(K key, V value) {
        this.addList(key).addIfAbsent(value);
    }

    private CopyOnWriteArrayList<V> addList(K key) {
        CopyOnWriteArrayList prev;
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)this.map.get(key);
        if (list == null && (prev = this.map.putIfAbsent(key, list = new CopyOnWriteArrayList())) != null) {
            list = prev;
        }
        return list;
    }

    public void remove(K key, V value) {
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)this.map.get(key);
        if (list != null) {
            list.remove(value);
            if (list.isEmpty()) {
                this.map.remove(key, list);
            }
        }
    }

    public void removeAll() {
        this.map.clear();
    }

    public List<V> list(K key) {
        return (List)this.map.get(key);
    }
}

