/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.util.HashMap;
import java.util.Map;
import org.operamasks.faces.util.JsObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsArray {
    private Map<String, Object> values;

    public void put(String key, Object value) {
        if (this.values == null) {
            this.values = new HashMap<String, Object>();
        }
        this.values.put(key, value);
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public String toString() {
        return this.toString('\'');
    }

    public String toString(char quote) {
        if (quote != '\'' && quote != '\"') {
            quote = (char)39;
        }
        return this.toScript(this.values, quote);
    }

    private String toScript(Map<String, Object> config, char quote) {
        if (config == null || config.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || value.toString() == null) continue;
            buf.append("\n");
            buf.append(key);
            buf.append(": ");
            if (value instanceof Boolean || value instanceof Integer || value instanceof JsObject) {
                buf.append(value);
            } else if (value instanceof Object[][]) {
                Object[][] array = (Object[][])value;
                HashMap<String, Object> nestedConfig = new HashMap<String, Object>();
                for (Object[] data : array) {
                    if (data.length < 2) continue;
                    nestedConfig.put((String)data[0], data[1]);
                }
                buf.append(this.toScript(nestedConfig, quote));
            } else if (value instanceof Map) {
                buf.append(this.toScript((Map)value, quote));
            } else {
                buf.append(quote).append(value.toString()).append(quote);
            }
            buf.append(",");
        }
        if (buf.length() > 1) {
            buf.delete(buf.length() - 1, buf.length());
            buf.append("\n}");
        } else {
            buf.append("}");
        }
        return buf.toString();
    }
}

