/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.util.LoggerUtil;

public class Repainter {
    private static final String REPAINT_KEY = "org.operamasks.faces.component.repaint";
    private static final String REPAINT_STATE_KEY = "org.operamasks.faces.component.repaintstate";
    private static final Logger log = LoggerUtil.getLogger("org.operamasks.faces.view");

    public static void markForRepaint(UIComponent c) {
        c.getAttributes().put(REPAINT_KEY, true);
    }

    private static void unmarkForRepaint(UIComponent c) {
        c.getAttributes().remove(REPAINT_KEY);
    }

    private static boolean isMarkedForRepaint(UIComponent c) {
        return c.getAttributes().containsKey(REPAINT_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repaintChildren(FacesContext context, UIComponent root) {
        ResourceManager rm = ResourceManager.getInstance(context);
        StringBuilder buf = new StringBuilder();
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        Repainter.flagRepainting(context);
        try {
            Repainter.processRepaint(context, root, rm, buf, out);
            try {
                rm.encodeBegin(context);
                out.writeScriptBlock(buf.toString());
                rm.encodeEnd(context);
                rm.reset();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error occured when rendering repaint script.", e);
            }
            out.setViewStateChanged(false);
        }
        finally {
            Repainter.unflagRepainting(context);
        }
    }

    public static void unflagRepainting(FacesContext context) {
        context.getExternalContext().getRequestMap().remove(REPAINT_STATE_KEY);
    }

    public static void flagRepainting(FacesContext context) {
        context.getExternalContext().getRequestMap().put(REPAINT_STATE_KEY, true);
    }

    public static boolean isRepainting(FacesContext context) {
        return context.getExternalContext().getRequestMap().containsKey(REPAINT_STATE_KEY);
    }

    private static void processRepaint(FacesContext context, UIComponent root, ResourceManager rm, StringBuilder buf, AjaxResponseWriter out) {
        Iterator<UIComponent> it = FacesUtils.createChildrenIterator(root, false);
        while (it.hasNext()) {
            UIComponent component = it.next();
            if (!Repainter.isMarkedForRepaint(component)) continue;
            Repainter.unmarkForRepaint(component);
            buf.append(Repainter.repaintComponent(context, rm, out, component));
        }
    }

    public static String repaintComponent(FacesContext context, ResourceManager rm, AjaxResponseWriter out, UIComponent component) {
        StringBuffer buf = new StringBuffer();
        StringWriter strWriter = new StringWriter();
        AjaxHtmlResponseWriter inner = out.cloneWithHtmlWriter(strWriter);
        context.setResponseWriter((ResponseWriter)inner);
        Repainter.consumeResource(context, rm, component);
        try {
            component.encodeAll(context);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "Error occured when repainting component of id '" + component.getId() + "'.", ex);
        }
        String content = HtmlEncoder.enquote(strWriter.toString(), Character.valueOf('\''));
        if (content.length() > 0) {
            String outerId = component.getOuterContainerId(context);
            buf.append(Repainter.omE("OM.O('" + outerId + "'," + content + ");\n"));
        }
        context.setResponseWriter((ResponseWriter)out);
        return buf.toString();
    }

    private static String omE(String script) {
        if (!ComponentResource.getCatchAllException().booleanValue()) {
            return script;
        }
        return "OM.E(function(){" + script + "});\n";
    }

    private static void consumeResource(FacesContext context, ResourceManager rm, UIComponent root) {
        rm.consumeInitScriptBegin(context, root);
        rm.consumeContainerResources(context, root);
        rm.consumeResources(context, root);
        rm.consumeResourceRegister(context, root);
        rm.consumeInitScriptEnd(context, root);
    }
}

