/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.validator.ClientValidator;
import org.operamasks.resources.Resources;

public class DoubleRangeValidator
extends javax.faces.validator.DoubleRangeValidator
implements ClientValidator {
    private boolean minimumSet;
    private boolean maximumSet;
    private String message;

    public DoubleRangeValidator() {
    }

    public DoubleRangeValidator(double maximum) {
        super(maximum);
    }

    public DoubleRangeValidator(double maximum, double minimum) {
        super(maximum, minimum);
    }

    public void setMinimum(double minimum) {
        this.minimumSet = true;
        super.setMinimum(minimum);
    }

    public void setMaximum(double maximum) {
        this.maximumSet = true;
        super.setMaximum(maximum);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getValidatorScript(FacesContext context, UIComponent component) {
        return null;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        try {
            super.validate(context, component, value);
        }
        catch (ValidatorException ex) {
            FacesMessage facesMessage = ex.getFacesMessage();
            if (facesMessage != null && this.message != null) {
                facesMessage.setSummary(this.message);
                facesMessage.setDetail(this.message);
            }
            throw ex;
        }
    }

    public String getValidatorInstanceScript(FacesContext context, UIComponent component) {
        String message = (String)component.getAttributes().get("validatorMessage");
        if (message == null) {
            message = this.message;
        }
        if (this.minimumSet && this.maximumSet) {
            if (message == null) {
                message = Resources._T("JSF_VALIDATE_DOUBLE_RANGE_NOT_IN_RANGE", FacesUtils.getLabel(context, component), String.valueOf(this.getMinimum()), String.valueOf(this.getMaximum()));
            }
            return "new FloatValidator(" + HtmlEncoder.enquote(message) + "," + this.getMinimum() + "," + this.getMaximum() + ")";
        }
        if (this.minimumSet) {
            if (message == null) {
                message = Resources._T("JSF_VALIDATE_DOUBLE_RANGE_MINIMUM", FacesUtils.getLabel(context, component), String.valueOf(this.getMinimum()));
            }
            return "new FloatValidator(" + HtmlEncoder.enquote(message) + "," + this.getMinimum() + ",null)";
        }
        if (this.maximumSet) {
            if (message == null) {
                message = Resources._T("JSF_VALIDATE_DOUBLE_RANGE_MAXIMUM", FacesUtils.getLabel(context, component), String.valueOf(this.getMaximum()));
            }
            return "new FloatValidator(" + HtmlEncoder.enquote(message) + ",null," + this.getMaximum() + ")";
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.maximumSet ? 1231 : 1237);
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.minimumSet ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleRangeValidator other = (DoubleRangeValidator)obj;
        if (this.maximumSet != other.maximumSet) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.minimumSet == other.minimumSet;
    }
}

